package com.digiwin.athena.datamap.mechanism.decisionHandler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.config.OpType;
import com.digiwin.athena.datamap.mechanism.convert.HooksConverter;
import com.digiwin.athena.datamap.mechanism.convert.HooksInfo;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.config.DataType;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.core.TenantObjectAdaptation;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.HashMap;

/**
 * @Description 决策限定能力操作pageViewAdaptation补充表
 * @Author liugl
 * @Date 2024/6/28 10:14
 **/
@Service
@Slf4j
public class DecisionCommonUtil {

    @Autowired
    @Qualifier("dataMapSystem")
    MongoTemplate mongoTemplate;

    @Autowired
    DataPickService dataPickService;

    @Autowired
    HooksConverter hooksConverter;

    /**
     * 根据pluginId 和 tenantId删除定制补充新
     * @param tenantId 租户id
     * @param pluginId 插件id
     * @throws DWException
     */
    public void postRemovePlugin(String tenantId, String pluginId) throws DWException {
        Query queryDelete = Query.query(Criteria.where("tenantId").is(tenantId).and("pluginId").in(pluginId));
        dataPickService.tenantTemplate().remove(queryDelete, DataMapPickService.tableTenantObjectAdaptation(PageView.class));

    }

    /**
     * 新增机制参数
     * @param parseContext
     * @param hooksInfoAll
     * @param pageView
     */
    public void addMechanismParameter(MechanismParseContext parseContext, HooksInfo hooksInfoAll, PageView pageView) {
        BindingContext bindingContext = parseContext.getBindingContext();
        SourceWidget sourceWidget = parseContext.getSourceWidget();
        if ("taskSource".equals(sourceWidget.getType())) {
            TenantObjectAdaptation tenantObjectAdaptation = new TenantObjectAdaptation();
            tenantObjectAdaptation.setExt(new HashMap<>());
            tenantObjectAdaptation.setTenantId(bindingContext.getTenantId());
            tenantObjectAdaptation.setPluginId(bindingContext.getPluginId());
            tenantObjectAdaptation.setCode(sourceWidget.getTarget());
            tenantObjectAdaptation.setType("TM_VARIABLE");
            tenantObjectAdaptation.setBusinessKey(ComponentTypeEnum.MechanismDecision.name());
            buildPageAdaptation(pageView, tenantObjectAdaptation, hooksInfoAll);

            dataPickService.tenantTemplate().save(tenantObjectAdaptation, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
        }
    }

    /**
     * 构建补充信息
     * @param pageView
     * @param pageViewAdaptation
     * @param hooksInfoAll
     */
    private void buildPageAdaptation(PageView pageView, TenantObjectAdaptation pageViewAdaptation, HooksInfo hooksInfoAll) {
        JSONObject pages = new JSONObject(pageView.getPages());
        JSONArray dataStates = pages.getJSONObject("task-detail").getJSONArray("dataStates");
        JSONArray oldHooks;
        // 有些数据中含dataStates层，有些没有，此处做兼容
        if (dataStates != null && !dataStates.isEmpty()) {
            JSONObject dataState = dataStates.getJSONObject(0);
            oldHooks = dataState.getJSONArray("hooks");
        } else {
            JSONObject taskDetail = pages.getJSONObject("task-detail");
            oldHooks = taskDetail.getJSONArray("hooks");
        }
        // Step1：旧数据没有hooks，直接添加hooks
        if (ObjectUtils.isEmpty(oldHooks)) {
            pageViewAdaptation.setDateType(DataType.object);
            pageViewAdaptation.setOp(OpType.put);
            String path = "$.pages.task-detail.dataStates[?(@.code == 'waitting')]";
            pageViewAdaptation.setPath(path);
            pageViewAdaptation.setAttribute("hooks");
            pageViewAdaptation.setValue(hooksConverter.buildHooks(hooksInfoAll));
            return;
        }
        // Step1：旧数据有hooks，添加hooks
        pageViewAdaptation.setDateType(DataType.object);
        pageViewAdaptation.setOp("comb");
        String path = "$.pages.task-detail.dataStates[0].hooks";
        pageViewAdaptation.setPath(path);
        pageViewAdaptation.setValue(hooksConverter.buildHooks(hooksInfoAll));
    }

}
