package com.digiwin.athena.datamap.mechanism.limithandler.parsers.limitAction;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.controlSourcehandlers.ControlSourceHandler;
import com.digiwin.athena.datamap.mechanism.limithandler.ReminderLimitHandler;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@Slf4j
public class DataMapReminderParser implements LimitActionParser {

    @Autowired
    ReminderLimitHandler reminderLimitHandler;

    @Autowired
    MechanismHelpService mechanismHelpService;

    @Autowired
    List<ControlSourceHandler> sourceHandlers;

    @Override
    public boolean accept(String type) {
        return MechanismEnum.LimitActionType.REMINDER.getCode().equalsIgnoreCase(type);
    }

    @Override
    public Object parse(MechanismApiInfoDTO apiInfoDTO) throws Exception {
        LimitAbilityBo bo = mechanismHelpService.convert(apiInfoDTO.getAbility(), LimitAbilityBo.class);
        BindingContext bindingContext = mechanismHelpService.convert(apiInfoDTO.getContext(), BindingContext.class);
        List<SingleStrategyWidget> strategies = bo.getStrategies();
        MechanismParseContext parseContext = buildParseContext(bo, bindingContext);
        if (null != strategies) {
            for (SingleStrategyWidget widget : strategies) {
                if (null != widget.getCondition() && null != widget.getCondition().getVariables()) {
                    reminderLimitHandler.handler(widget, parseContext);
                }
            }
        }
        return null;
    }

    /**
     * 构建解析数据元
     * @param runnableAbility
     * @param bindingContext
     * @return
     * @throws DWBusinessException
     */
    private MechanismParseContext buildParseContext(LimitAbilityBo runnableAbility, BindingContext bindingContext) throws DWBusinessException {
        MechanismParseContext parseContext = new MechanismParseContext();
        parseContext.setSourceWidget(runnableAbility.getCheckSource());
        parseContext.setBo(runnableAbility);
        parseContext.setBindingContext(bindingContext);
        parseContext.setSourceTarget(runnableAbility.getCheckSource().getTarget());

        parseSource(runnableAbility.getCheckSource(), parseContext);
        return parseContext;
    }

    /**
     * 解析数据
     * @param checkSource
     * @param context
     * @throws DWBusinessException
     */
    public void parseSource(SourceWidget checkSource, MechanismParseContext context) throws DWBusinessException {
        if (null == checkSource || null == checkSource.getType()) {
            return;
        }
        for (ControlSourceHandler sourceHandler : sourceHandlers) {
            if (sourceHandler.accept(checkSource)) {
                sourceHandler.parse(checkSource, context);
                break;
            }
        }
    }
}
