package com.digiwin.athena.datamap.mechanism.paradigm;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.datamap.spi.DataMapKgService;
import com.digiwin.athena.mechanism.bo.FieldMapInfo;
import com.digiwin.athena.mechanism.bo.ParadigmCondition;
import com.digiwin.athena.mechanism.bo.ParadigmConditionItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-09-22 15:19
 **/
@Service
public class DataMapParadigmService {

    @Autowired
    DataMapKgService dataMapKgService;

    public ParadigmCondition getParadigmConditionByMechanismCode(String code) {
        if (code == null) {
            return null;
        }

        Object obj = dataMapKgService.getParadigm(code);
        if (null == obj) {
            return null;
        }
        System.out.println(obj);

        ParadigmCondition condition = JSON.parseObject(JSON.toJSONString(obj), ParadigmCondition.class);

        return condition;
    }

    public String getExpression(String code, String dataCode) {
        String exp = null;
        if (null == code || null == dataCode) {
            return null;
        }
        ParadigmCondition condition = getParadigmConditionByMechanismCode(code);
        if (null == condition) {
            return null;
        }
        Map<String, String> keyMaps = new HashMap<>();
        for (Map.Entry<String, List<FieldMapInfo>> en : condition.getFieldMapsTo().entrySet()) {
            for (FieldMapInfo info : en.getValue()) {
                if (dataCode.equals(info.getData_name())) {
                    keyMaps.put(en.getKey(), info.getField());
                    break;
                }
            }
        }
        exp = parseParadigmCondition(condition, keyMaps, null);

        return exp;
    }

    public static String parseParadigmCondition(ParadigmCondition condition, Map<String, String> keyMaps, String itemKey) {

        if (null == itemKey) {
            itemKey = "item";
        }
        String fieldPrefix = "$(" + itemKey + ")";

        String expression = expression(condition.getConditions(), keyMaps, fieldPrefix);

        return expression;
    }

    public static String expression(ParadigmConditionItem item, Map<String, String> keyMaps, String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        String type = item.getType();

        switch (type) {
            case "SINGLE":
                String field = keyMaps.get(item.getLeft());
                if (null == field) {
                    throw new IllegalArgumentException("can not find field from fieldMapsTo by left:" + item.getLeft());
                }
                String path = prefix + "." + field;
                String exp1 = singleExpression(path, item.getOp(), item.getRight());
                sb.append(exp1);
                break;
            case "OR_GROUP":
                int len1 = item.getItems().size();
                for (int i = 0; i < len1; i++) {
                    ParadigmConditionItem item1 = item.getItems().get(i);
                    String itemExp = expression(item1, keyMaps, prefix);
                    if (null != itemExp) {
                        sb.append(" ").append(itemExp).append(" ");
                    }
                    if (i < len1 - 1) {
                        sb.append("||");
                    }
                }
                break;
            case "AND_GROUP":
                int len2 = item.getItems().size();
                for (int i = 0; i < len2; i++) {
                    ParadigmConditionItem item1 = item.getItems().get(i);
                    String itemExp = expression(item1, keyMaps, prefix);
                    if (null != itemExp) {
                        sb.append(" ").append(itemExp).append(" ");
                    }
                    if (i < len2 - 1) {
                        sb.append("&&");
                    }
                }
                break;

            default:
                throw new IllegalArgumentException("condition type error:" + type);
        }

        sb.append(")");
        return sb.toString();
    }

    public static String singleExpression(String left, String op, String right) {
        StringBuilder sb = new StringBuilder();
        switch (op) {
            case "START_WITH":
                sb.append(left).append(".startsWith('").append(right).append("')");
                break;
            case "END_WITH":
                sb.append(left).append(".endsWith('").append(right).append("')");
                break;
            case "EQUAL":
                sb.append(left).append(" == '").append(right).append("'");
                break;
            case "NOT_EQUAL":
                sb.append(left).append(" != '").append(right).append("'");
                break;
            case "CONTAIN":
                sb.append(left).append(" in ").append(right).append("");
                break;

            default:
                throw new IllegalArgumentException("not support op:" + op);
        }

        return sb.toString();
    }

}
