package com.digiwin.athena.datamap.povo;

import com.digiwin.athena.datamap.enums.BusinessMessageSourceMethod;
import com.digiwin.athena.datamap.enums.SourceType;
import com.digiwin.athena.domain.common.BaseObject;
import lombok.*;
import lombok.experimental.SuperBuilder;

import java.util.List;
import java.util.Map;

/**
 * 交付设计器的待办工作台设置中的条件
 */
@EqualsAndHashCode(callSuper = false)
@Data
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class WSConditionVO extends BaseObject {

    /**
     * pageview的createDate，用来排序
     */
    private Long createDate;

    private String appCode;

    private String appName;

    private String taskCode;

    private String taskName;
    /**
     * 此条件对应任务的多语系
     */
    public Map<String, Map<String, String>> taskLang;

    private BusinessMessageSourceMethod businessMessageSourceMethod;
    /**
     * 名称
     */
    private String aliasName;
    /**
     * 代号
     */
    private String aliasCode;

    /**
     * 交付设计器，常规分组条件是否选中
     */
    private Boolean commonEnable;

    /**
     * 交付设计器界面拖拽排序
     */
    private Integer sort;
    /**
     * 类型
     */
    private String dataType;

    private SourceType sourceType;

    private List<PointInTime> pointInTime;

    private List<Dimensionality> dimensionality;
    /**
     * CardGroupGroup中的字段，常规条件列表，默认分组
     */
    private Boolean defaultEffective;

    /**
     * 是否启用
     */
    private Boolean enable;

    /**
     * 分组下，常规条件列表，默认分组，前端取值
     */
    private Boolean defaultGroup;

    /**
     * 生效范围
     */
    private List<ConditionScopeVO> conditionScope;
}
