package com.digiwin.athena.datamap.service;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.datamap.actions.ActionReq;
import com.digiwin.athena.datamap.actions.ActionResp;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;

/**
 * 元数据服务
 * @javadoc
 */
@DWRestfulService
public interface IActionService extends DWService {

    /**
     * 根据actionId发起请求
     * @param req 参数
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/action/process", method = {DWRequestMethod.POST})
    ActionResp postProcess(ActionReq req) throws DWException;

    /**
     * 根据actionId发起请求
     * @param req
     * @return
     * @throws DWException
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/action/process2", method = {DWRequestMethod.POST})
    ActionResp postProcess2(ActionReq req) throws DWException;

    /**
     * 机制业务条件判断
     * @param apiInfoDTO
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/action/judgeBusinessCondition", method = {DWRequestMethod.POST})
    ActionResp judgeBusinessCondition(MechanismApiInfoDTO apiInfoDTO) throws Exception;


    /**
     * 根据actionId获取元数据
     * @param actionId 元数据id
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/action/metadata", method = {DWRequestMethod.GET})
    Object getMetadata(String actionId) throws Exception;
}
