package com.digiwin.athena.datamap.service;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.datamap.povo.UriRequest;

import java.util.Map;

/**
 * 配置服务
 * @javadoc
 */
@DWRestfulService
public interface IConfigService extends DWService {

    /**
     * 获取配置信息
     * @param request
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/config/get", method = {DWRequestMethod.POST})
    Object postConfig(UriRequest request) throws DWException;

    /**
     * 获取批量配置信息
     * @param request
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/config/getBatch", method = {DWRequestMethod.POST})
    Map<String, Object> postConfigBatch(UriRequest request) throws DWException;

}
