package com.digiwin.athena.datamap.service;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.datamap.povo.ViewRequest;
import com.digiwin.athena.domain.core.view.EmailView;

/**
 * 邮箱服务
 * @program: athena2_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2022-01-26 14:59
 * @javadoc
 **/
@DWRestfulService
public interface IEmailService extends DWService {

    /**
     * 获取邮件列表
     * @param request 查询参数
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/email/emails", method = {DWRequestMethod.POST})
    Object postEmails(ViewRequest request) throws DWException;

    /**
     * 获取邮件模板代码
     * @param request 查询参数
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/email/emailTemplateCode", method = {DWRequestMethod.POST})
    Object postEmailTemplateCode(ViewRequest request) throws DWException;

    /**
     * 待废弃方法
     * @param request 查询参数
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/email/emailUpdate", method = {DWRequestMethod.POST})
    Object postEmailUpdate(EmailView request) throws DWException;

}
