package com.digiwin.athena.datamap.service;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.datamap.povo.DataRequest;
import com.digiwin.athena.domain.core.dtdflow.EventTemplate;
import com.digiwin.athena.domain.core.dtdflow.FlowProcess;

/**
 * 流程服务
 * @javadoc
 */
@DWRestfulService
public interface IFlowProcessService extends DWService {

    /**
     * 根据流程代码获取流程实例
     * @param req
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/process/processByCode", method = {DWRequestMethod.POST})
    FlowProcess postProcessByCode(DataRequest req) throws DWException;

    /**
     * 根据流程实例ID获取事件模板
     * @param req
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/process/eventById", method = {DWRequestMethod.POST})
    EventTemplate postEventById(DataRequest req) throws DWException;

}
