package com.digiwin.athena.datamap.service;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.datamap.povo.GenericRequest;

/**
 * 通用服务
 * @program: athena2_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2022-03-09 19:16
 * @javadoc
 **/
@DWRestfulService
public interface IGenericService extends DWService {

    /**
     * 获取项目元数据
     * @param request 入参
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/generic/projectMeta", method = {DWRequestMethod.POST})
    Object postProjectMeta(GenericRequest request) throws DWException;

    /**
     * 获取任务元数据
     * @param request 入参
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/generic/taskMeta", method = {DWRequestMethod.POST})
    Object postTaskMeta(GenericRequest request) throws DWException;

    /**
     * 获取任务页面元数据
     * @param request 入参
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/generic/taskPageMeta", method = {DWRequestMethod.POST})
    Object postTaskPageMeta(GenericRequest request) throws DWException;

    /**
     * 获取数据元对象
     * @param request 入参
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/generic/decisionObjectList", method = {DWRequestMethod.POST})
    Object postDecisionObjectList(GenericRequest request) throws DWException;

    /**
     * 获取项目页面元数据
     * @param request 入参
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/generic/projectPageMeta", method = {DWRequestMethod.POST})
    Object postProjectPageMeta(GenericRequest request) throws DWException;

    /**
     * 清除缓存
     * @param request 入参
     * @return
     * @throws DWException
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/generic/cleanCache", method = {DWRequestMethod.POST})
    Object postCleanCache(GenericRequest request) throws DWException;

    /**
     * 根据key匹配表达式删除缓存-目前给preset迁移使用
     * @param pattern key匹配表达式
     */
    void delMatch(String pattern);

    /**
     * 获取应用关联关系
     * @param request
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/generic/appRelations", method = {DWRequestMethod.POST})
    Object postAppRelations(GenericRequest request) throws Exception;

    /**
     * 获取公司运营单元信息
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/generic/corp", method = {DWRequestMethod.GET})
    Object getCorp() throws DWException;

}
