package com.digiwin.athena.datamap.service;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.datamap.povo.meta.MetaRequest;
import com.digiwin.athena.datamap.povo.meta.MetaResponse;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.dto.BasicQuery;

import java.util.List;

@DWRestfulService
public interface IMetaService extends DWService {

    @DWRequestMapping(path = "/meta/query", method = {DWRequestMethod.POST})
    <T extends TenantObject> MetaResponse postQuery(MetaRequest req) throws DWException;

    @DWRequestMapping(path = "/meta/remove", method = {DWRequestMethod.POST})
    <T extends TenantObject> MetaResponse postRemove(MetaRequest req) throws DWException;

    @DWRequestMapping(path = "/meta/update", method = {DWRequestMethod.POST})
    <T extends TenantObject> MetaResponse postUpdate(MetaRequest req) throws DWException;

    @DWRequestMapping(path = "/meta/save", method = {DWRequestMethod.POST})
    <T extends TenantObject> MetaResponse  postSave(MetaRequest req) throws DWException;

}
