package com.digiwin.athena.datamap.service;

import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.preset.dto.PresetDTO;

import java.util.Map;

@DWRestfulService
public interface IPresetService extends DWService {
    @AllowAnonymous
    @DWRequestMapping(path = "/preset", method = {DWRequestMethod.PUT})
    void put(String colName, PresetDTO content) throws Exception;

    @AllowAnonymous
    @DWRequestMapping(path = "/preset", method = {DWRequestMethod.DELETE})
    void delete(String colName, String key, String tenantVersion) throws Exception;

    @AllowAnonymous
    @DWRequestMapping(path = "/preset", method = {DWRequestMethod.GET})
    Object get(String colName, String key) throws Exception;

    @AllowAnonymous
    @DWRequestMapping(path = "/preset/query", method = {DWRequestMethod.GET})
    Object getQuery(String colName, Map<String, Object> conditions) throws Exception;

    @AllowAnonymous
    @DWRequestMapping(path = "/preset/tanentRule", method = {DWRequestMethod.DELETE})
    void deleteTanentRule(String colName, String pluginId, String tenantVersion) throws Exception;
}
