package com.digiwin.athena.datamap.service;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.*;
import com.digiwin.athena.datamap.povo.*;
import com.digiwin.athena.domain.core.*;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.customBizTask.CustBizTaskConfigDTO;
import com.digiwin.athena.domain.definition.features.DataFeatureSet;
import com.digiwin.athena.dto.*;

import java.util.List;
import java.util.Map;
/**
 * 任务定义接口
 *
 * @javadoc
 */
@DWRestfulService
public interface ITaskService extends DWService {

    /**
     * 根据查询条件query获取任务
     * @param query 查询条件
     * @return 任务
     * @throws DWException
     */
    @DWRequestMapping(path = "/task/tasks", method = {DWRequestMethod.POST})
    List<Task> postTasks(BasicQuery query) throws DWException;

    /**
     * 根据查询条件query获取任务
     * @param request 查询条件
     * @return 任务
     * @throws DWException
     */
    @DWRequestMapping(path = "/task/task", method = {DWRequestMethod.POST})
    Task postTask(BasicQuery request) throws DWException;

    /**
     * 获取任务的执行路径，包含任务和数据节点
     * @param request 请求参数
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/task/executePath", method = {DWRequestMethod.POST})
    TaskPathResp postExecutePath(com.digiwin.athena.kmservice.povo.DataRequest request) throws DWException;

    /**
     * 根据活动code获取活动
     * @param code 活动code
     * @return 活动
     * @throws DWException
     */
    @DWRequestMapping(path = "/task/activityByCode", method = {DWRequestMethod.GET})
    Activity getActivityByCode(@DWRequestParam String code) throws DWException;

    /**
     * 根据活动code获取活动
     * @param request 活动code和运营单元信息
     * @return 活动
     * @throws DWException
     */
    @DWRequestMapping(path = "/task/activityByCode", method = {DWRequestMethod.POST})
    Activity postActivityByCode(DataRequest request) throws DWException;

    /**
     * 根据任务code获取任务
     * @param code 任务code
     * @return 任务
     * @throws DWException
     */
    @DWRequestMapping(path = "/task/taskByCode", method = {DWRequestMethod.GET})
    Task getTaskByCode(@DWRequestParam String code) throws DWException;

    /**
     * 根据任务code获取轻量级侦测定义
     * @param code 任务code
     * @return 轻量级侦测定义
     * @throws DWException
     */
    @DWRequestMapping(path = "/task/taskSchedule", method = {DWRequestMethod.GET})
    List<TaskSchedule> getTaskSchedule(@DWRequestParam String code) throws DWException;

    /**
     * 根据任务code和运营单元获取任务
     * @param request 任务code和运营单元信息
     * @return 任务
     * @throws DWException
     */
    @DWRequestMapping(path = "/task/taskByCode", method = {DWRequestMethod.POST})
    Task postTaskByCode(DataRequest request) throws DWException;

    /**
     * 根据任务code获取任务和里程碑活动
     * @param code 任务code
     * @return 任务 + 活动
     * @throws DWException
     */
    @DWRequestMapping(path = "/task/taskAndMilestoneActivity", method = {DWRequestMethod.GET})
    TaskAndActivity getTaskAndMilestoneActivity(@DWRequestParam String code) throws DWException;

    /**
     * 根据流程code获取流程
     * @param code 流程code
     * @return 返回流程
     * @throws DWException
     */
    @DWRequestMapping(path = "/task/flowByCode", method = {DWRequestMethod.GET})
    FlowGraph getFlowByCode(@DWRequestParam String code) throws DWException;

    /**
     * 根据数据描述code获取数据描述
     * @param code code
     * @return 数据描述
     * @throws DWException
     */
    @DWRequestMapping(path = "/task/dataDescription", method = {DWRequestMethod.GET})
    DataDescription getDataDescription(@DWRequestParam String code) throws DWException;

    /**
     * 根据数据状态code获取数据描述
     * @param stateCode 数据状态code
     * @return 数据描述
     * @throws DWException
     */
    @DWRequestMapping(path = "/task/dataDescriptionByStateCode", method = {DWRequestMethod.GET})
    DataDescription getDataDescriptionByStateCode(@DWRequestParam String stateCode) throws DWException;

    /**
     * 根据数据状态code获取数据状态
     * @param code 数据状态code
     * @return 数据状态
     * @throws DWException
     */
    @DWRequestMapping(path = "/task/dataState", method = {DWRequestMethod.GET})
    DataState getDataState(@DWRequestParam String code) throws DWException;

    /**
     * 根据数据状态code获取数据状态（包含数据描述和数据特征）
     * @param code 数据状态code
     * @return 数据状态（包含数据描述和数据特征）
     * @throws DWException
     */
    @DWRequestMapping(path = "/task/dataStateWithDesc", method = {DWRequestMethod.GET})
    DataStateVO getDataStateWithDesc(@DWRequestParam String code) throws DWException;

    /**
     * 根据数据状态code获取数据状态（包含数据描述和数据特征）
     * @param code 数据状态code
     * @return 数据状态（包含数据描述和数据特征）
     * @throws DWException
     */
    @DWRequestMapping(path = "/task/dataStateTagged", method = {DWRequestMethod.GET})
    DataStateVO getDataStateTagged(@DWRequestParam String code) throws DWException;

     @DWRequestMapping(path = "/task/dataStateNear", method = {DWRequestMethod.POST})
     List<DataStateVO> postDataStateNear(DataRequest request) throws DWException;

    /**
     * 根据数据特征code获取数据特征
     * @param code 数据特征code
     * @return 数据特征
     * @throws DWException
     */
    @DWRequestMapping(path = "/task/dataFeatureSet", method = {DWRequestMethod.GET})
    DataFeatureSet getDataFeatureSet(@DWRequestParam String code) throws DWException;

    /**
     * 删除租户级设置的任务字段，例如交付设计器恢复初始操作
     * @param tenantId 租户id
     * @param taskCode 任务code
     * @param version 租户版本
     * @param fields 需要清理的字段
     * @return 清理结果
     * @throws DWException
     */
    @DWRequestMapping(path = "/task/clearTenantTaskField", method = {DWRequestMethod.POST})
    Object clearTenantTaskField(String tenantId, String taskCode, String version, List<String> fields) throws DWException;

    /**
     * 根据任务code获取任务定义
     * @param taskId 任务code
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/task/getDefinition", method = {DWRequestMethod.GET})
    Map<String, Object> getDefinition(@DWRequestParam String taskId) throws Exception;

    /**
     * 根据项目code查询项目，包含pageView视图数据，项目任务目标，里程碑。过滤里程碑中无授权数据
     * @param taskId 项目定义
     * @return 项目定义
     * @throws Exception
     */
    @DWRequestMapping(path = "/task/definitionByTaskId", method = {DWRequestMethod.GET})
    Map<String, Object> getDefinitionByTaskId(@DWRequestParam String taskId) throws Exception;

    /**
     * 获取项目定义，含租户级配置
     *
     * @param taskId 项目定义编码
     * @param pageCode 页面类型了；例如：project-card
     * @return 返回项目定义
     * @throws Exception
     */
    @DWRequestMapping(path = "/task/definitionWithMultiLanguage", method = {DWRequestMethod.GET})
    Map<String, Object> getDefinitionWithMultiLanguage(@DWRequestParam String taskId, @DWRequestParam String pageCode) throws Exception;

    /**
     * 根据项目编码和运营单元获取项目（pageView视图数据，项目任务目标，里程碑），过滤里程碑中无授权数据
     * @param taskId 项目code
     * @param operationUnit 运营单元
     * @return 项目定义
     * @throws Exception
     */
    @DWRequestMapping(path = "/task/definitionByTaskIdAndOperationUnit", method = {DWRequestMethod.POST})
    Object postDefinitionByTaskIdAndOperationUnit(String taskId, OperationUnit operationUnit) throws Exception;

    /**
     * 根据项目code获取任务
     * @param taskId 任务id
     * @return 任务
     * @throws Exception
     */
    @DWRequestMapping(path = "/task/activities", method = {DWRequestMethod.GET})
    @Deprecated
    Map<String, Object> getActivities(@DWRequestParam String taskId) throws Exception;

    /**
     * 根据项目code获取任务
     * @param taskId 任务id
     * @return 任务
     * @throws Exception
     */
    @DWRequestMapping(path = "/task/activitiesWithMultiLanguage", method = {DWRequestMethod.GET})
    Map<String, Object> getActivitiesWithMultiLanguage(@DWRequestParam String taskId) throws Exception;

    /**
     * 根据任务code获取任务，包含页面设计数据和租户级配置数据
     * @param activityId 任务code
     * @param pageCode 页面设计code
     * @return 任务
     * @throws Exception
     */
    @DWRequestMapping(path = "/task/activityDefinition", method = {DWRequestMethod.GET})
    Map<String, Object> getActivityDefinition(@DWRequestParam String activityId, @DWRequestParam String pageCode) throws Exception;

    /**
     * 根据任务code获取任务，包含页面设计数据和租户级配置数据
     * @param taskId 项目code
     * @param activityId 任务code
     * @param pageCode 页面设计code
     * @return 任务
     * @throws Exception
     */
    @DWRequestMapping(path = "/task/activityDefinitionWithMergeRule", method = {DWRequestMethod.GET})
    Map<String, Object> getActivityDefinitionWithMergeRule(@DWRequestParam String taskId, @DWRequestParam String activityId, @DWRequestParam String pageCode) throws Exception;

    /**
     * 根据任务code获取任务配置 - 是否合并
     * @param taskId 项目code
     * @param activityId 任务code
     * @return 任务配置 - 是否合并
     * @throws Exception
     */
    @DWRequestMapping(path = "/task/activityConfig", method = {DWRequestMethod.GET})
    Map<String, Object> getActivityConfig(@DWRequestParam String taskId, @DWRequestParam String activityId) throws Exception;

    /**
     * 查询任务定义，包含任务流程和页面信息
     * @param taskId 项目code
     * @param activityId 任务code
     * @param pageCode 页面设计code
     * @param operationUnit 运营单元
     * @return 任务
     * @throws Exception
     */
    @DWRequestMapping(path = "/task/activityDefinition", method = {DWRequestMethod.POST})
    Map<String, Object> postActivityDefinition(String taskId, String activityId, String pageCode, OperationUnit operationUnit) throws Exception;

    /**
     * 根据任务code
     * @param taskId 项目code
     * @param activityId 任务code
     * @param pageCode 页面设计code
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/task/activityStartTargetCode", method = {DWRequestMethod.GET})
    Map<String, Object> getActivityStartTargetCode(String taskId, String activityId, String pageCode) throws Exception;

    /**
     * 根据任务code获取任务，包含任务流程和页面信息
     * @param activityId 任务code
     * @return 任务，包含任务流程和页面信息
     * @throws DWException
     */
    @DWRequestMapping(path = "/task/taskInfoFromDataMap", method = {DWRequestMethod.GET})
    Map<String, Object> getTaskInfoFromDataMap(String activityId) throws DWException;

    /**
     * 根据项目code获取项目
     * @param taskId 项目code
     * @return 项目
     * @throws DWException
     */
    @DWRequestMapping(path = "/task/detail", method = {DWRequestMethod.GET})
    Map<String, Object> getDetail(String taskId) throws DWException;

    /**
     * 根据项目code获取项目输入变量
     * @param taskId 项目code
     * @return 输入变量
     * @throws DWException
     */
    @DWRequestMapping(path = "/task/inputData", method = {DWRequestMethod.GET})
    Map<String, Object> getInputData(String taskId) throws DWException;

    /**
     * 更新项目数据
     * @param data 待更新数据
     * @return null
     * @throws DWException
     */
    @Deprecated
    @DWRequestMapping(path = "/task/updateTaskConfig", method = {DWRequestMethod.POST})
    String postUpdateTaskConfig(Project data) throws DWException;

    /**
     * 根据应用code获取项目
     * @param applicationCode 应用code
     * @param operationUnit 运营单元
     * @return 项目
     * @throws Exception
     */
    @DWRequestMapping(path = "/task/taskByApp", method = {DWRequestMethod.POST})
    List<TaskDTO> postTaskByApp(String applicationCode, OperationUnit operationUnit) throws Exception;

    // TODO liugla 2024/10/29 13:57 注释
    /**
     *
     * @param taskId
     * @param operationUnit
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/task/fixTask", method = {DWRequestMethod.POST})
    Object postFixTask(String taskId, OperationUnit operationUnit) throws Exception;

    /**
     * 查任务卡项目卡页面设定
     * @param code pageUI表的唯一code  原先pageView表的code
     * @param activityId 任务卡code
     * @param pageCode 类型
     * @return UIElement
     * @throws Exception
     */
    @DWRequestMapping(path = "/task/pageUIElement", method = {DWRequestMethod.GET})
    List<Map<String, Object>> getPageUIElement(@DWRequestParam String code, @DWRequestParam String activityId, @DWRequestParam String pageCode) throws Exception;

    /**
     * 查询用户授权的手动发起列表
     * 查询授权的应用列表=》查询应用下的项目=》删除组件列表中禁用的=》删除公共应用项目没有被搭售的
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/task/manualList", method = {DWRequestMethod.GET})
    List<ProjectVo> getManualList() throws Exception;

    /**
     * 查询用户授权的手动发起列表 移动端使用
     * 查询授权的应用列表=》查询应用下的项目=》删除组件列表中禁用的=》删除公共应用项目没有被搭售的
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/task/manualListMobile", method = {DWRequestMethod.GET})
    List<ProjectVo> getManualListMobile() throws Exception;

    /**
     * 查询用户授权的手动发起列表
     * 查询授权的应用列表=》查询应用下的项目=》删除组件列表中禁用的=》删除公共应用项目没有被搭售的
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/task/manualPage", method = {DWRequestMethod.GET})
    Map<String,Object> getManualPage(String code,String pageCode) throws Exception;

    /**
     * 通过项目code获取界面配置code
     * @return
     * @throws Exception
     */
    @DWRequestMapping(path = "/task/manualPageCode", method = {DWRequestMethod.GET})
    PageView getManualPageCode(String code) throws Exception;

    /**
     * 按条件分页查询人工任务类型列表
     * @param findTaskFromUserRequest
     * @return
     * @throws DWException
     */
    @DWRequestMapping(path = "/task/findTaskFromUser", method = {DWRequestMethod.POST})
    Object postFindTaskFromUser(@DWRequestBody FindTaskFromUserRequest findTaskFromUserRequest) throws DWException;

    /**
     * 根据应用code查询可自定义业务流项目
     * @param appCode 应用code
     * @param projectCode 项目code
     * @return 任务
     * @throws DWException
     */
    @DWRequestMapping(path = "/task/getCustBizTaskByProject", method = {DWRequestMethod.GET})
    CustBizTaskConfigDTO getCustBizTaskByProject(String appCode, String projectCode) throws DWException;
}