package com.digiwin.athena.datamap.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.annotation.ScheduledCall;
import com.digiwin.athena.datamap.povo.ViewRequest;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.tenant.TenantEntity;
import com.digiwin.athena.kg.dto.TenantInitParam;


import java.util.List;

/**
 * 租户服务
 * @program: athena2_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-07-15 13:33
 * @javadoc
 **/
@DWRestfulService
public interface ITenantService extends DWService {

    /**
     * 初始化租户信息
     * @param request
     * @return
     * @throws DWException
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/tenant/init", method = {DWRequestMethod.POST})
    Object postInitTenantInfo(ViewRequest request) throws DWException;

    /**
     * 初始化所有租户信息
     * @return
     * @throws DWException
     */
    @AllowAnonymous
    @DWRequestMapping(path = "/tenant/initAllTenantInfo", method = {DWRequestMethod.POST})
    Object postInitAllTenantInfo() throws DWException;

    /*下面是重构新加的代码 */

    /**
     * 获取所有租户
     * @return
     */
    @DWRequestMapping(path = "/tenant/allTenant", method = {DWRequestMethod.GET})
    @AllowAnonymous
    List<TenantEntity> getAllTenant();

    /**
     * 根据租户id获取租户
     * @param tenantId
     * @return
     */
    @AllowAnonymous
    @ScheduledCall
    @DWRequestMapping(path = "/tenant/tenant", method = {DWRequestMethod.GET})
    TenantEntity getTenant(String tenantId);

    /**
     * 根据租户id获取租户版本
     * @param tenantId 租户id
     * @return
     */
    @DWRequestMapping(path = "/tenant/tenantVersion", method = {DWRequestMethod.GET})
    String getTenantVersion(String tenantId);

    /**
     * 清除租户数据
     * @param param 参数
     * @return
     * @throws DWBusinessException
     */
    @DWRequestMapping(path = "/tenant/cleanTenantInfo", method = {DWRequestMethod.POST})
    Object postCleanTenantInfo(TenantInitParam param) throws DWBusinessException;

    /**
     * 根据租户id获取授权的appCode集合
     * @return
     * @throws DWBusinessException
     */
    @DWRequestMapping(path = "/tenant/appCodes", method = {DWRequestMethod.GET})
    List<String> getAppCodes() throws DWBusinessException;

    /**
     * 根据租户id获取授权的应用
     * @return
     * @throws DWBusinessException
     */
    @DWRequestMapping(path = "/tenant/apps", method = {DWRequestMethod.GET})
    Object getApps() throws DWBusinessException;


    /**
     * 语义获取租户购买的应用信息和租户版本信息
     * @return
     * @throws DWBusinessException
     */
    @DWRequestMapping(path = "/tenant/appsInfo", method = {DWRequestMethod.GET})
    Object getAppsInfo() throws DWBusinessException;

    /**
     * 获取用户授权应用
     * @return
     * @throws DWBusinessException
     */
    @DWRequestMapping(path = "/tenant/userAppAuth", method = {DWRequestMethod.GET})
    Object getUserAppAuthByUserId() throws DWBusinessException;

    /**
     * 获取用户授权应用 ,传userId,解决集成token对应userId错误的问题
     * @param userId 用户id
     * @return
     * @throws DWBusinessException
     */
    @DWRequestMapping(path = "/tenant/userAppAuthyUserId", method = {DWRequestMethod.GET})
    Object getUserAppAuthByUserId(String userId) throws DWBusinessException;

    /**
     * 用户粒度查询授权应用
     * @return
     * @throws DWBusinessException
     */
    @DWRequestMapping(path = "/tenant/userMetricApplication", method = {DWRequestMethod.GET})
    List<Application> getUserMetricApplication() throws DWBusinessException;

    /**
     * 用户粒度查询授权应用
     * @param type 类型，类型是1代表查敏捷数据应用
     * @return
     * @throws DWBusinessException
     */
    @DWRequestMapping(path = "/tenant/userMetricApplicationByType", method = {DWRequestMethod.GET})
    List<Application> getUserMetricApplicationByType(String type) throws DWBusinessException;

    /**
     * 用户粒度查询授权应用
     * @param type 类型，类型是1代表查敏捷数据应用
     * @param userId 用户id
     * @return
     * @throws DWBusinessException
     */
    @DWRequestMapping(path = "/tenant/userMetricApplicationByTypeAndUserId", method = {DWRequestMethod.GET})
    List<Application> getUserMetricApplicationByTypeAndUserId(String type, String userId) throws DWBusinessException;

    /**
     * 获取应用对应的产品线
     * @param appCodes  应用编码
     * @return  List
     * @throws DWBusinessException
     */
    @DWRequestMapping(path = "/tenant/queryProductLineByApp", method = {DWRequestMethod.POST})
    Object postQueryProductLineByApp(List<String> appCodes) throws DWBusinessException;
}
