package com.digiwin.athena.datamap.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.enums.SourceType;
import com.digiwin.athena.datamap.enums.WSConfigType;
import com.digiwin.athena.datamap.enums.WSPageCode;
import com.digiwin.athena.datamap.povo.*;
import com.digiwin.athena.datamap.spi.AtmcService;
import com.digiwin.athena.kmservice.service.KmGeneralService;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service
@Slf4j
public class DataMapTaskFieldService {

    @Autowired
    private AtmcService atmcService;

    @Autowired
    private KmGeneralService kmGeneralService;

    public List<CardGroupGroup> sysCardGroups(String tenantId) {
        List<CardGroupGroup> sysCardGroups = null;
        try {
            sysCardGroups = atmcService.getGroupDimension(tenantId);
        } catch (Exception e) {
            log.error("getGroupDimension error", e);
        }
        if (null == sysCardGroups) {
            sysCardGroups = new ArrayList<>();
        }
        sysCardGroups.forEach(s -> {
            s.setEnabled(true);
            s.setCommonEnable(true);
        });
        return sysCardGroups;
    }

    public static List<WSConditionVO> systemCardGroupGroupToCondition(List<CardGroupGroup> cardGroupGroups) {
        List<WSConditionVO> wsConditionVOS = cardGroupGroups.stream().map(v -> {
            WSConditionVO wsConditionVO = JSON.parseObject(JSON.toJSONString(v), WSConditionVO.class);
            wsConditionVO.setAliasName(v.getName());
            wsConditionVO.setAliasCode(v.getCode());
            wsConditionVO.setSourceType(SourceType.system);
            wsConditionVO.setDefaultEffective(v.isDefaultEffective());
            Boolean defaultGroup = v.getDefaultGroup();
            if (defaultGroup == null) {
                defaultGroup = v.isDefaultEffective();
            }
            wsConditionVO.setDefaultGroup(defaultGroup);
            wsConditionVO.setEnable(v.isEnabled());
            wsConditionVO.setCommonEnable(v.getCommonEnable() != null ? v.getCommonEnable() : true);
            return wsConditionVO;
        }).collect(Collectors.toList());
        List<WSConditionVO> taskGroupWSConditionVO = SystemWSConditionVO.taskGroupWSConditionVO;
        WSConditionVO groupByMember = taskGroupWSConditionVO.get(0);
        WSConditionVO groupByDepartment = taskGroupWSConditionVO.get(1);
        if (wsConditionVOS.stream().filter(v -> v.getAliasCode().equals(groupByMember.getAliasCode())).count() <= 0) {
            wsConditionVOS.add(groupByMember);
        }
        if (wsConditionVOS.stream().filter(v -> v.getAliasCode().equals(groupByDepartment.getAliasCode())).count() <= 0) {
            wsConditionVOS.add(groupByDepartment);
        }
        return wsConditionVOS;
    }

    public WorkbenchSettingVO cardGroupToWSConditionVO(CardGroup cardGroup) {
        String tenantId;
        try {
            tenantId = ServiceUtils.getTenantId();
        } catch (DWBusinessException e) {
            throw new RuntimeException(e);
        }
        WorkbenchSettingVO workbenchSettingVO = new WorkbenchSettingVO();
        workbenchSettingVO.setTenantId(tenantId);
        workbenchSettingVO.setPageCode(WSPageCode.task);
        workbenchSettingVO.setConfigType(WSConfigType.groups);
        ArrayList<WSConditionVO> wsConditionVOS = new ArrayList<>();
        if (!Boolean.FALSE.equals(cardGroup.getEnabled())) {
            SystemGroup system = cardGroup.getSystem();
            if (system != null) {
                List<CardGroupGroup> groups = system.getGroups();
                if (CollectionUtil.isNotEmpty(groups)) {
                    List<WSConditionVO> sysConditions = DataMapTaskFieldService.systemCardGroupGroupToCondition(groups);
                    wsConditionVOS.addAll(sysConditions);
                }
            }
            List<CardGroupApplication> applications = cardGroup.getApplications();
            if (CollectionUtils.isNotEmpty(applications)) {
                ArrayList<WSConditionVO> appConditionVOS = new ArrayList<>();
                for (CardGroupApplication application : applications) {
                    List<CardGroupTask> tasks = application.getTasks();
                    if (CollectionUtils.isNotEmpty(tasks)) {
                        for (CardGroupTask task : tasks) {
                            kmGeneralService.handleLang(task);
                            List<CardGroupGroup> groups1 = task.getGroups();
                            if (CollectionUtils.isNotEmpty(groups1)) {
                                for (CardGroupGroup group : groups1) {
                                    WSConditionVO wsConditionVO = JSON.parseObject(JSON.toJSONString(group), WSConditionVO.class);
                                    wsConditionVO.setAppCode(application.getAppCode());
                                    wsConditionVO.setTaskCode(task.getCode());
                                    wsConditionVO.setBusinessMessageSourceMethod(task.getBusinessMessageSourceMethod());
                                    wsConditionVO.setTaskName(task.getName());
                                    wsConditionVO.setTaskLang(task.getLang());
                                    wsConditionVO.setAliasCode(group.getCode());
                                    wsConditionVO.setAliasName(group.getName());
                                    wsConditionVO.setSourceType(SourceType.customer);
                                    wsConditionVO.setDefaultEffective(group.isDefaultEffective());
                                    Boolean defaultGroup = group.getDefaultGroup();
                                    if (defaultGroup == null) {
                                        defaultGroup = group.isDefaultEffective();
                                    }
                                    wsConditionVO.setDefaultGroup(defaultGroup);
                                    wsConditionVO.setEnable(group.isEnabled());
                                    wsConditionVO.setCommonEnable(group.getCommonEnable() != null ? group.getCommonEnable() : true);
                                    ConditionScopeVO conditionScopeVO = new ConditionScopeVO();
                                    conditionScopeVO.setAppCode(application.getAppCode());
                                    conditionScopeVO.setName(task.getName());
                                    conditionScopeVO.setAppName(application.getAppName());
                                    conditionScopeVO.setCode(task.getCode());
                                    conditionScopeVO.setCardGroupTask(JSON.parseObject(JSON.toJSONString(task), ConditionScopeVO.CardGroupTask.class));
                                    conditionScopeVO.setId(task.getTaskId());
                                    conditionScopeVO.setBusinessMessageSourceMethod(task.getBusinessMessageSourceMethod());
                                    wsConditionVO.setConditionScope(Collections.singletonList(conditionScopeVO));
                                    appConditionVOS.add(wsConditionVO);
                                }
                            }
                        }
                    }
                }
                Map<String, List<WSConditionVO>> conditionMap =
                        appConditionVOS.stream().collect(Collectors.groupingBy(WSConditionVO::getAliasCode, LinkedHashMap::new, Collectors.toCollection(ArrayList::new)));
                for (Map.Entry<String, List<WSConditionVO>> entry : conditionMap.entrySet()) {
                    List<WSConditionVO> conditionVOS = entry.getValue();
                    WSConditionVO wsConditionDTO = conditionVOS.get(0);
                    wsConditionDTO.setConditionScope(conditionVOS.stream()
                            .flatMap(v -> v.getConditionScope().stream())
                            .distinct()
                            .sorted(Comparator.comparing(ConditionScopeVO::getAppName, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ConditionScopeVO::getId,
                                    Comparator.nullsLast(Comparator.naturalOrder())))
                            .collect(Collectors.toList()));
                    wsConditionVOS.add(wsConditionDTO);
                }
            }
        } else {
            List<CardGroupGroup> cardGroupGroups = this.sysCardGroups(tenantId);
            if (CollectionUtil.isNotEmpty(cardGroupGroups)) {
                List<WSConditionVO> sysConditions = DataMapTaskFieldService.systemCardGroupGroupToCondition(cardGroupGroups);
                wsConditionVOS.addAll(sysConditions);
            }
        }
        List<WSConditionVO> defaultCondition = wsConditionVOS.stream()
                .filter(v -> Boolean.TRUE.equals(v.getEnable()))
                .map(v -> {
                    WSConditionVO wsConditionVO = JSON.parseObject(JSON.toJSONString(v), WSConditionVO.class);
                    wsConditionVO.setEnable(v.getCommonEnable());
                    return wsConditionVO;
                })
                .collect(Collectors.toList());
        if (defaultCondition.stream().anyMatch(v -> v.getSort() != null)) {
            defaultCondition = defaultCondition.stream().sorted(Comparator.comparing(v -> v.getSort(), Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
        }
        workbenchSettingVO.setCondition(wsConditionVOS);
        workbenchSettingVO.setDefaultCondition(defaultCondition);
        return workbenchSettingVO;
    }
}
