package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.datamap.povo.ViewRequest;
import com.digiwin.athena.datamap.service.ITenantService;
import com.digiwin.athena.datamap.service.inner.KmService;
import com.digiwin.athena.datamap.service.inner.DatamapRedisLock;
import com.digiwin.athena.datamap.spi.DataMapIamService;
import com.digiwin.athena.datamap.kg.DataMapLicenseKeyManager;
import com.digiwin.athena.datamap.utils.AthenaUtils;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.TenantAppRelation;
import com.digiwin.athena.domain.core.tenant.TenantEntity;
import com.digiwin.athena.kg.domain.ProductTemplateTenant;
import com.digiwin.athena.kg.dto.TenantInitParam;
import com.digiwin.athena.kg.dto.TenantInitResp;
import com.digiwin.athena.kmservice.neo4j.Neo4j1Config;
import com.digiwin.athena.kmservice.neo4j.Neo4j2Config;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.kmservice.service.KmGeneralService;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

import static com.digiwin.athena.kg.ComponentConstants.REDIS_KNOWLEDGE_GRAPH;

/**
 * @program: athena2_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-09-03 13:19
 **/
@MyExceptionHandler
@Slf4j
@Service
public class DataMapTenantService implements ITenantService {

    @Autowired
    @Qualifier("kgSystem")
    MongoTemplate mongoTemplate;

    @Autowired
    @Qualifier("kgTenant")
    MongoTemplate mongoTemplateUser;

    @Autowired
    SessionFactory sessionFactory;

    @Autowired(required=false)
    @Qualifier(Neo4j1Config.SESSION_FACTORY)
    SessionFactory sessionFactoryDomain1;

    @Autowired(required=false)
    @Qualifier(Neo4j2Config.SESSION_FACTORY)
    SessionFactory sessionFactoryDomain2;

    @Resource(name="kgDataPickService")
    DataPickService dataPickService;

    @Autowired
    KmService kmService;

    @Autowired
    DatamapAppService datamapAppService;

    @Autowired
    DatamapRedisLock datamapRedisLock;

    @Autowired
    DataMapIamService dataMapIamService;

    @Autowired
    ProductNameResolver productNameResolver;

    @Autowired
    DataMapLicenseKeyManager dataMapLicenseKeyManager;

    @Autowired
    DataMapDutyService dataMapDutyService;
    @Autowired
    DataMapLevelService dataMapLevelService;
    @Autowired
    KmGeneralService kmGeneralService;

    // 同时兼容传入appCode和application的情况，存在一些情况应用没有陪在applicationRelation表里
    @Override
    public Object postInitTenantInfo(ViewRequest request) throws DWException {return null;}
    @Override
    public Object postInitAllTenantInfo() throws DWException {return null;}

    @Override
    public List<TenantEntity> getAllTenant() {
        return mongoTemplate.find(Query.query(Criteria.where("ifCommon").in(null, false)), TenantEntity.class);
    }

    @Override
    public TenantEntity getTenant(String tenantId) {
        return mongoTemplate.findOne(new Query(Criteria.where("tenantId").is(tenantId)), TenantEntity.class);
    }

    @Override
    public String getTenantVersion(String tenantId) {
        String version = "2.0";
        TenantEntity entity = this.getTenant(tenantId);
        if(null!=entity){
            version = entity.getVersion();
        }
        return version;
    }



    private Application getApplication(String appCode) throws DWBusinessException {
        Application application;
        if ("espCommon".equals(appCode)) {
            application = new Application();
            application.setCode("espCommon");
            application.setCommonApp(true);
        } else {
            application = datamapAppService.getApplicationByCode(appCode);
        }
        if (application == null ||  null == application.getCommonApp() || !application.getCommonApp()) {
            log.error("appEntity节点不存在或者appEntity节点中nameSpace为空，或非公共应用，请先创建后再初始化!");
            throw new DWArgumentException("appEntity", I18nUtils.getValue("knowledgegraph.appEntity.notExist"));
        }
        return application;
    }






    private List<String> findTemplateTenant(String product, String appCode){
        log.info("findTemplateTenant appCode:{}, product:{}", appCode, product);
        if(StringUtils.isEmpty(product)){
            return null;
        }
        List<String> resultList = new ArrayList<>();
        Query query = new Query();
        query.addCriteria(Criteria.where("app").is(appCode).and("product").is(product));
        List<ProductTemplateTenant> templateTenants = mongoTemplate.find(query, ProductTemplateTenant.class);
        if(CollectionUtils.isEmpty(templateTenants)){
            return null;
        }
        resultList.add(templateTenants.get(0).getTenantId());
        return resultList;
    }
    private List<String> findTemplateTenant(List<String> products, String appCode){
        log.info("findTemplateTenant appCode:{}, products:{}", appCode, products);
        if(CollectionUtils.isEmpty(products)){
            return null;
        }
        List<String> resultList = new ArrayList<>();
        Set<String> existTenant = new HashSet<>();
        Query query = new Query();
        query.addCriteria(Criteria.where("app").is(appCode));
        List<ProductTemplateTenant> templateTenants = mongoTemplate.find(query, ProductTemplateTenant.class);
        if(CollectionUtils.isEmpty(templateTenants)){
            return null;
        }
        Map<String, String> collect = templateTenants.stream().collect(Collectors.toMap(ProductTemplateTenant::getProduct, ProductTemplateTenant::getTenantId));
        for(String str : products){
            String s = collect.get(str);
            if(StringUtils.isNotEmpty(s) && !existTenant.contains(s)){
                resultList.add(s);
                existTenant.add(s);
            }
        }
        return resultList;
    }

    @Override
    public Object postCleanTenantInfo(TenantInitParam param) throws DWBusinessException {
        System.out.println(param);
        TenantInitResp resp = new TenantInitResp();
        String tenantId = ServiceUtils.getTenantId();
        Session session = sessionFactory.openSession();
        String cleanCypher = "MATCH (n:TenantEntity)  where n.tenantId='"+tenantId+"' detach delete n";
        session.query(cleanCypher,new HashMap<>());
        session.clear();
        Query query = Query.query(Criteria.where("tenantId").is(tenantId));
        mongoTemplate.remove(query,TenantEntity.class);
        mongoTemplate.remove(query,TenantAppRelation.class);
        return resp;
    }

    @Override
    public List<String> getAppCodes() throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        return kmService.tenantApps(tenantId);
    }



    private void deleteTenantAppCodeCache(String tenantId){
        log.info("deleteTenantAppCodeCache tenantId:{}", tenantId);
        String key = REDIS_KNOWLEDGE_GRAPH + ":SYSTEM:SYSTEM:zh_CN:getAppCodes$" + tenantId;
        try {
            Object o = kmGeneralService.deleteKeys(Collections.singletonList(key));
            log.info("deleteTenantAppCodeCache tenantId:{}, result:{}", tenantId, o);
        } catch (Exception e) {
            log.error(e.toString());
        }
    }


    @Override
    public Object getApps() throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        Object res = kmService.authorizationsTenants(tenantId);
        if(ObjectUtils.isEmpty(res)){
            return res;
        }else{
            //Athena相关的应用
//            List<String> allAppCode = this.appService.getAllAppCode();
            List<Object> objectList = new ArrayList<>();
            JSONArray jsonArray = JSONArray.parseArray(JSON.toJSONString(res));
            for(int i=0; i<jsonArray.size(); i++){
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String code = jsonObject.getString("code");
                Application applicationInfo = this.datamapAppService.getApplicationInfo(code);
                if(applicationInfo != null){ //能找到应用的定义，则替换名字（为了语系正确）并返回
                    jsonObject.put("displayName", applicationInfo.getName());
                    objectList.add(jsonObject);
                }
            }
            return objectList;
        }


    }





    // 语义获取租户购买的应用信息和租户版本信息
    @Override
    public Object getAppsInfo() throws DWBusinessException {
        Map<String,Object> appInfo = new HashMap<>();
        String tenantId = ServiceUtils.getTenantId();
        List<TenantAppRelation> tenantAppRelations = kmService.tenantInitializedApps(tenantId);
        appInfo.put("tenantAppInfos", tenantAppRelations);
        appInfo.put("tenantVersion",kmService.tenantVersion());
        return appInfo;
    }

    // 获取用户授权应用
    @Override
    public Object getUserAppAuthByUserId() throws DWBusinessException {
        String userId = ServiceUtils.getUserId();
        String tenantId = ServiceUtils.getTenantId();
        if (StringUtils.isEmpty(userId)) {
            throw new DWBusinessException("userId is empty");
        }

        Map<String,Object> tenantAppInfos = new HashMap<>();
        tenantAppInfos.put("appCodes",kmService.userApps(userId));
        tenantAppInfos.put("tenantVersion",kmService.tenantVersion());
        tenantAppInfos.put("tenantId",tenantId);
        tenantAppInfos.put("userId",userId);
        return tenantAppInfos;
    }

    // 获取用户授权应用 ,传userId,解决集成token对应userId错误的问题
    @Override
    public Object getUserAppAuthByUserId(String userId) throws DWBusinessException {
        if (StringUtils.isEmpty(userId)) {
            userId = AthenaUtils.getUserId();
        }
        String tenantId = ServiceUtils.getTenantId();
        Map<String,Object> tenantAppInfos = new HashMap<>();
        tenantAppInfos.put("appCodes",kmService.userApps(userId));
        tenantAppInfos.put("tenantVersion",kmService.tenantVersion());
        tenantAppInfos.put("tenantId",tenantId);
        tenantAppInfos.put("userId",userId);
        return tenantAppInfos;
    }
    // 用户粒度查询授权应用
    @Override
    public List<Application> getUserMetricApplication() throws DWBusinessException {
        return getUserMetricApplicationByType("1");
    }

    @Override
    public List<Application> getUserMetricApplicationByType(String type) throws DWBusinessException {
        String userId = AthenaUtils.getUserId();
        return getUserMetricApplicationByTypeAndUserId(type,userId);
    }

    @Override
    public List<Application> getUserMetricApplicationByTypeAndUserId(String type, String userId) throws DWBusinessException {
        if (StringUtils.isEmpty(userId)) {
            userId = AthenaUtils.getUserId();
        }

        String tenantVersion = kmService.tenantVersion();
        // 查询租户授权应用，类型是1代表查敏捷数据应用
        List<String> appCodes = kmService.userApps(userId);
        if (StringUtils.equals(type,"1")) {
            // 查询敏捷数据应用
            return mongoTemplate.find(
                    Query.query(Criteria.where("version").is(tenantVersion)
                            .and("code").in(appCodes).and("appType").is(6)),Application.class);
        }

        return mongoTemplate.find(
                Query.query(Criteria.where("version").is(tenantVersion)
                        .and("code").in(appCodes)),Application.class);
    }


    @Override
    public Object postQueryProductLineByApp(List<String> appCodes) throws DWBusinessException {
        if (CollectionUtils.isEmpty(appCodes)) {
            return Collections.emptyMap();
        }

        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = kmService.tenantVersion();
        Query query = Query.query(Criteria.where("code").in(appCodes)
                .and("version").is(tenantVersion));
        List<Application> applications = mongoTemplate.find(query,Application.class);
        return appCodes.stream()
                .collect(Collectors.toMap(
                        appCode -> appCode, // 以 appCode 为 key
                        appCode -> applications.stream()
                                .filter(application -> application.getCode().equals(appCode))
                                .findFirst()
                                .map(Application::getProductLines) // 获取对应的产品线
                                .orElse(Collections.emptyList()) // 如果没有找到，返回空列表
                        ,(existing, replacement) -> existing));
    }

}
