package com.digiwin.athena.datamap.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.service.ITestService;
import com.digiwin.athena.datamap.service.inner.KmService;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.kmservice.analysis.AnalysisComponent;
import com.digiwin.athena.kmservice.analysis.AnalysisTool;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.log4j.LogManager;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-05-12 16:45
 **/
@Service
@Slf4j
public class DataMapTestService implements ITestService {

    {
        System.out.println("TestService..........");
    }

    @Value("${hello1}")
    private String hello1;
    @Autowired
    StringRedisTemplate redisTemplate;

    @Autowired
    SessionFactory sessionFactory;

    @Autowired
    LoggingSystem loggingSystem;

    @Autowired
    @Qualifier("dataMapSystem")
    MongoTemplate mongoTemplate;

    @Autowired
    DataPickService dataPickService;

    @Autowired
    DatamapAppService applicationService;
    @Autowired
    KmService kmService;

    @Autowired
    AnalysisComponent analysisComponent;

    @Override
    public String getTest01(String input) {
        System.out.println("test1.....");
//        List<String> appCodes = new ArrayList<>();
//        appCodes.add("PCC");
//        appCodes.add("PWD");
//        try {
//            ApplicationRelationQueryDTO queryDTO = ApplicationRelationQueryDTO.builder().codes(appCodes).type("task").build();
//            List<ApplicationRelation> relations = applicationService.postApplicationRelationByTypeAndAppCodes(queryDTO);
//            System.out.println(relations);
//        } catch (Exception e) {
//            throw new RuntimeException(e);
//        }

        return "hello ";
    }

    @Override
    public Object postTest02(Map<String, Object> input) {
        System.out.println("test02...............");

        return input;
    }

    @Override
    public Object getTest_neo4j(String input) {
        Session session = sessionFactory.openSession();
        Result r = session.query("match(d:DataMapGraph) where d.key='DTD' return d.version", new HashMap<>());
        Map<String, Object> map = r.iterator().next();
        return map;
    }

    @Override
    public String getLogLevel(String level) {
        log.debug("debug");
        log.info("info");
        log.warn("warn");
        log.error("error");

        org.apache.log4j.Level level1 = org.apache.log4j.Level.toLevel(level);
        LogManager.getRootLogger().setLevel(level1);

        return level;
    }

    @Override
    public Object getTest04(String input) throws DWBusinessException {
        System.out.println("test4.....");


        return "permissions";

    }

    @Override
    public Object getTest05(String input) throws DWBusinessException {
        System.out.println("test5.....");
        Task task = dataPickService.findByCode(input, Task.class);
        return task;
    }

    @Override
    public String getRedisSet(String key, String value) {
        redisTemplate.opsForValue().set(key, value);
        return null;
    }

    @Override
    public String getRedisGet(String key) {
        return redisTemplate.opsForValue().get(key);
    }

    public String tenantId() {
        String tenantId = ServiceUtils.getTenantIdSilent();
        return tenantId;
    }

    @Override
    public Object getStatics(String input) {
        return analysisComponent.allAnalysisInfo();
    }

    @Override
    public Object getStack(String input) {
        return AnalysisTool.threadDump();
    }

    public static void main(String[] args) {

    }
}
