package com.digiwin.athena.datamap.service.impl;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.povo.DataRequest;
import com.digiwin.athena.datamap.service.IFlowProcessService;
import com.digiwin.athena.datamap.supports.EocInfoLocal;
import com.digiwin.athena.domain.core.dtdflow.EventSubcribe;
import com.digiwin.athena.domain.core.dtdflow.EventTemplate;
import com.digiwin.athena.domain.core.dtdflow.FlowProcess;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.service.DataPickService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.List;

@Lang
@Service
public class FlowProcessService implements IFlowProcessService {

    @Autowired
    DataPickService dataPickService;
    @Autowired
    @Qualifier("dataMapSystem")
    MongoTemplate mongoTemplate;

    @Override
    public FlowProcess postProcessByCode(DataRequest req) throws DWException {
        EocInfoLocal.setEocInfo(req.getEocInfo());

        FlowProcess process = dataPickService.findByCode(req.getCode(), FlowProcess.class);

        return process;
    }

    @Override
    public EventTemplate postEventById(DataRequest req) throws DWException {
        String version = dataPickService.tenantVersion();
        EventTemplate template = mongoTemplate.findOne(Query.query(Criteria.where("eventId").is(req.getEventId()).and("version").is(version)), EventTemplate.class);

        if (null != template) {
            List<EventSubcribe> subscribes = mongoTemplate.find(Query.query(Criteria.where("eventId").is(req.getEventId()).and("version").is(version)), EventSubcribe.class);
            template.setSubscribes(subscribes);
        }

        return template;
    }
}
