package com.digiwin.athena.datamap.service.impl;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.constants.ActivityPattern;
import com.digiwin.athena.constants.ActivitySubType;
import com.digiwin.athena.constants.ApplicationRelationType;
import com.digiwin.athena.datamap.dao.DataMapActivityDAO;
import com.digiwin.athena.datamap.kg.DataMapMongoEntityBaseDAO;
import com.digiwin.athena.datamap.kg.dto.ActivityDataEntryVO;
import com.digiwin.athena.datamap.kg.dto.TBBReportReplacer;
import com.digiwin.athena.datamap.kg.dto.valueobject.ActivityDataEntryInfoVO;
import com.digiwin.athena.datamap.povo.ApplicationGroup;
import com.digiwin.athena.datamap.povo.ProjectVo;
import com.digiwin.athena.datamap.povo.rebuild.UserComponentDto;
import com.digiwin.athena.datamap.report.DataMapReportManager;
import com.digiwin.athena.datamap.service.IRecordService;
import com.digiwin.athena.datamap.service.inner.DataMapKgDataPickService;
import com.digiwin.athena.datamap.service.inner.KmService;
import com.digiwin.athena.datamap.spi.DataMapIamService;
import com.digiwin.athena.datamap.utils.AthenaUtils;
import com.digiwin.athena.datamap.utils.ExcelExporter;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.component.bo.ComponentBO;
import com.digiwin.athena.domain.component.bo.TenantAppComponentListBO;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.core.app.FunctionCtrl;
import com.digiwin.athena.dto.BasicQuery;
import com.digiwin.athena.dto.TenantSummaryFieldsDto;
import com.digiwin.athena.kg.ComponentConstants;
import com.digiwin.athena.kg.action.ApiDataFieldLocaleMetadataDTO;
import com.digiwin.athena.kg.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.kg.activity.TenantCardTitleDefinition;
import com.digiwin.athena.kg.domain.TenantSummaryField;
import com.digiwin.athena.kg.domain.TenantSummaryFields;
import com.digiwin.athena.kg.dto.ApplicationRelationQueryDTO;
import com.digiwin.athena.kg.dto.queryCondition.ReportConditionSetting;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.repository.neo4j.ActivityRepository;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@Slf4j
@Service
@Lang
public class RecordService implements IRecordService {

    public static final String SUMMARY = "summary";
    public static final String BUSINESS_INFO = "businessInfo";
    public static final String SEARCH_KEY = "searchKey";
    public static final String PROJECT_INFO = "projectInfo";
    @Autowired
    @Qualifier("kgSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier("kgTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    DataMapReportManager dataMapReportManager;
    @Autowired
    KmService kmService;
    @Autowired
    DataMapActionService dataMapActionService;
    @Autowired
    DataMapTenantService dataMapTenantService;
    @Autowired
    ActivityRepository activityRepository;
    @Autowired
    DataMapKgDataPickService dataPickService;
    @Autowired
    DatamapAppService applicationService;
    @Autowired
    DataMapTaskService dataMapTaskService;

    @Autowired
    DataMapMongoEntityBaseDAO dataMapMongoEntityBaseDAO;
    @Autowired
    ProductNameResolver productNameResolver;

    @Autowired
    DataMapReportConditionService dataMapReportConditionService;

    @Autowired
    DataMapIamService dataMapIamService;

    @Autowired
    DataMapMechanismService dataMapMechanismService;

    @Autowired
    private DataMapActivityDAO dataMapActivityDAO;


    @Override
    public Object postTenantTBBReportsByProductCode(TBBReportReplacer reportReplacer) throws Exception {
        String tenantVersion = kmService.tenantVersion(reportReplacer.getTenantId());
        //step1:根据productCode先将对应应用下所有PCC报表删除,包括activity,applicationRelation,activityConfigs
        clearTenantTBBReportsByProductCode(reportReplacer.getProductCode(), reportReplacer.getTenantId(), tenantVersion);
        //step2:将报表分别写入neo4j的activity,mongo的applicationRelation和activityConfigs
        reportReplacer.setVersion(tenantVersion);
        writeNewReportToDB(reportReplacer);
        return null;
    }

    @Override
    public Object getTBBReports(String mode, String productCode) throws Exception {
        List<ActivityDataEntryVO> activityDataEntryVOS;
        switch (mode) {
            case "pc":
                activityDataEntryVOS = (List<ActivityDataEntryVO>) getActivitiesByPattern("STATEMENT");
                break;
            case "mobile":
                activityDataEntryVOS = (List<ActivityDataEntryVO>) getActivitiesByPattern("MOBI-STATEMENT");
                break;
            default:
                activityDataEntryVOS = (List<ActivityDataEntryVO>) getActivitiesByPattern("STATEMENT");
                break;
        }
        if (CollectionUtils.isEmpty(activityDataEntryVOS)) {
            return Collections.EMPTY_LIST;
        }
        activityDataEntryVOS = activityDataEntryVOS.stream().filter(activity -> activity.getAppCode() != null && activity.getAppCode().equals(productCode)).collect(Collectors.toList());
        return activityDataEntryVOS;
    }

    @Override
    public Object getBaseDataApplication() throws Exception {
        List<Activity> activities = dataMapActivityDAO.getCommonBaseData(ServiceUtils.getTenantId());
        List<String> activityCodes = activities.stream().map(Activity::getCode).collect(Collectors.toList());
        ApplicationRelationQueryDTO queryDTO = ApplicationRelationQueryDTO.builder().codes(activityCodes).tenantVersion("2.0").build();
        List<ApplicationRelation> applicationRelations = applicationService.postApplicationRelationByCodesAndTenantVersion(queryDTO);
        new ExcelExporter().exportToExcel(applicationRelations);
        return applicationRelations;
    }


    @Override
    public Object getStatements(String effect) throws Exception {
        List<ActivityDataEntryVO> infos = getActivitiesByPatternOrSubTypeSort(ActivityPattern.STATEMENT,ActivitySubType.statement);
        setUserPermissionInfo(infos,effect);
        return infos;
    }

    @Override
    public Object getEntries(String effect) throws Exception {
        List<ActivityDataEntryVO> infos= getActivitiesByPatternOrSubTypeSort(ActivityPattern.DATA_ENTRY,ActivitySubType.base_entry);
        setUserPermissionInfo(infos,effect);
        return infos;
    }

    @Override
    public Object getPatterns(String effect,String pattern) throws Exception {
        List<ActivityDataEntryVO> infos= getActivitiesByPatternOrSubTypeSort(pattern,null);
        setUserPermissionInfo(infos,effect);
        return infos;
    }

    @Override
    public List<Activity> postActivityNames(Map<String,Object> query) throws DWBusinessException {
        BasicQuery query1 =BasicQuery.of(query,null);
        query1.setReturnFields(Arrays.asList("code","name","lang"));
        List<Activity> activities = dataPickService.find(query1, Activity.class,"activityConfigsBasic",true);
        return activities;
    }


    public List<ActivityDataEntryVO> getActivitiesByPatternOrSubTypeSort(String pattern,String subType) throws Exception {
        List<ActivityDataEntryVO> activitiesByPattern = getActivitiesByPatternOrSubType(pattern,subType);
        setGroupInfo(activitiesByPattern);
        return activitiesByPattern;
    }



    public List<ActivityDataEntryVO> getActivitiesByPatternOrSubType(String pattern,String subType) throws Exception {
        long start = System.currentTimeMillis();
        log.info("enter getActivitiesByPattern at :{}， pattern：{}， subType：{}", start, pattern, subType);
        List<ActivityDataEntryVO> activityDataEntryVOS = new LinkedList<>();
        String tenantId = kmService.tenantId();
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
        UserComponentDto dto = kmService.userComponents(ApplicationRelationType.activity, subType, localeStr);
        if(null==dto){return activityDataEntryVOS;}
        Set<String> codesFiltered = dto.getCodesFiltered();
        List<String> commonAppCodes = dto.getCommonAppCodes();
        Map<String, ApplicationRelation> codeRelations = dto.getCodeRelations();
        String hasGroundEnd = null;
        Object hasGroundEndObj = null;
        try {
            hasGroundEndObj = this.dataMapMechanismService.getVariable("hasGroundEnd", tenantId);
            if (hasGroundEndObj != null) {
                Map<String, Object> hasGroundEndMap = (Map<String, Object>) hasGroundEndObj;
                hasGroundEnd = String.valueOf(hasGroundEndMap.get("hasGroundEnd"));
            }
        } catch (Exception e) {
            log.error("getActivitiesByPatternOrSubType error tenantId:{}", tenantId, e);
        }
        Map<String, Object> query2 = new HashMap<>();
        query2.put("code",codesFiltered);
        if(null!=pattern){
            query2.put("pattern",pattern);
        }
        List<Activity> activities = dataPickService.find(query2, Activity.class,"activityConfigsBasic");
        if(StringUtils.equals(hasGroundEnd, "N")){
            Iterator<Activity> iterator = activities.iterator();
            while(iterator.hasNext()){
                Activity activity = iterator.next();
                if(Boolean.TRUE.equals(activity.getDependOnGroundEnd())){
                    iterator.remove();
                }
            }
        }
        filterUc(activities,tenantId);


        for(Activity activityItem: activities){
            ActivityDataEntryVO dataEntryVO = new ActivityDataEntryVO();
            ApplicationRelation applicationRelation = codeRelations.get(activityItem.getCode());
            String appCode = applicationRelation.getAppCode();

            dataEntryVO.setCode(activityItem.getCode());
            dataEntryVO.setName(activityItem.getName());
            dataEntryVO.setAuthorityPrefix(activityItem.getAuthorityPrefix());
            dataEntryVO.setIfCommon(false);
            dataEntryVO.setCommonApp(false);
            if (commonAppCodes.contains(appCode)) {
                dataEntryVO.setCommonApp(true);
            }
            dataEntryVO.setResCode(activityItem.getResCode());
            dataEntryVO.setCategory(activityItem.getCategory());
            dataEntryVO.setCategoryAbi(activityItem.getCategoryAbi());
            dataEntryVO.setAppCode(appCode);
            dataEntryVO.setAppName(null == applicationRelation ? "缺少应用关系配置" : applicationRelation.getAppName());
            dataEntryVO.setGroupCode(StringUtils.isEmpty(activityItem.getGroupCode()) ? null : activityItem.getGroupCode());
            dataEntryVO.setSort(null == activityItem.getSequence() ? null : String.valueOf(activityItem.getSequence()));
            dataEntryVO.setSubReport(activityItem.getSubReport());
            dataEntryVO.setLang(activityItem.getLang());
            dataEntryVO.setDisablePrintFlag(activityItem.getDisablePrintFlag());
            dataEntryVO.setDisableExportFlag(activityItem.getDisableExportFlag());
            activityDataEntryVOS.add(dataEntryVO);
        }

        return activityDataEntryVOS;
    }


    @Override
    public Object getActivitiesByPattern(String pattern) throws Exception {

        return getActivitiesByPatternOrSubType(pattern,KmService.patternToSubType.get(pattern));
//        long start = System.currentTimeMillis();
//        log.info("enter getActivitiesByPattern at :{}", start);
//        String tenantId = ServiceUtils.getTenantId();
//        String tenantVersion = kmService.tenantVersion();
//        Locale locale = DWResourceBundleUtils.getCurrentLocale();
//        String localeStr = locale.toString();
//        //add start
//        String hasGroundEnd = null;
//        Object hasGroundEndObj = null;
//        try {
//            hasGroundEndObj = this.mechanismService.getVariable("hasGroundEnd", tenantId);
//            if (hasGroundEndObj != null) {
//                Map<String, Object> hasGroundEndMap = (Map<String, Object>) hasGroundEndObj;
//                hasGroundEnd = String.valueOf(hasGroundEndMap.get("hasGroundEnd"));
//            }
//        } catch (Exception e) {
//
//        }
//        List<String> appCodes = kmService.userAuthApps();
//        List<String> activityCodes = dataPickService.tenantProductCodes("activity",appCodes);
//        //add end
//        List<Activity> activities0= activityRepository.getActivitiesByPattern(tenantId, pattern, tenantVersion,activityCodes);
//        List<Activity> activities = dataPickService.excludeWithSameCode(activities0);
//        filterUc(activities,tenantId);
//
//        //TBB报表租户版特殊处理(租户级配置替换标准配置)
//        //<activityCode,applicationCode>
//        Map<String, String> tbbCodeApplicationMap = new HashMap<>();
//        if (pattern.equals("STATEMENT") || pattern.equals("MOBI-STATEMENT")) {
//            //查询租户级TBB报表配置并合并
//            handleTBBTenantReports(pattern, tenantId, tenantVersion, activities, tbbCodeApplicationMap);
//        }
//
//        Map<String, Boolean> activityHasGroundEndMap = this.getActivityHasGroundEnd(activities);
//
//        final String hasGroundEndTemp = hasGroundEnd;
//        List<ActivityDataEntryVO> activityDataEntryVOS = new LinkedList<>();
//
//        if (CollectionUtils.isEmpty(activities)) {
//            return activityDataEntryVOS;
//        }
//        Map<String, Activity> activityMap = activities.stream()
//                .collect(Collectors.toMap(Activity::getCode, Function.identity(), (a, b) -> b));
//        //区分两种activity
//        //normal Activity(非tbb报表)
//        List<String> normalActivityCodes = activities.stream()
//                .filter(item -> StringUtils.isEmpty(tbbCodeApplicationMap.get(item.getCode()))).map(Activity::getCode)
//                .collect(Collectors.toList());
//        if (!CollectionUtils.isEmpty(normalActivityCodes)) {
//            Map<String, List<ApplicationRelation>> applicationRelationsMap =
//                    applicationService.getApplicationRelationsMapByTypeAndCodesAndLang("activity",
//                            normalActivityCodes, localeStr, activityMap);
//            //通过iam查询应用搭售基础资料
//            Set<String> finalCommonAppsIncludedItems = getCommonAppsIncludedItems(applicationRelationsMap);
//            normalActivityCodes.forEach(item -> {
//                if (!(StringUtils.equals(hasGroundEndTemp, "N") && activityHasGroundEndMap.get(item) != null && activityHasGroundEndMap.get(item))) {
//                    //p3s1新增逻辑,公共基础资料,一笔资料可能对应多个应用
//                    ActivityDataEntryVO activityDataEntryVO = new ActivityDataEntryVO();
//                    List<ApplicationRelation> applicationRelations = applicationRelationsMap.get(item);
//                    if (!CollectionUtils.isEmpty(applicationRelations)) {
//                        applicationRelations.forEach(applicationRelation -> {
//                            //add by srj 20220802 当有应用关系，但租户已经没有这个应用权限的时候，对应的数据不返回
//                            if (appCodes.contains(applicationRelation.getAppCode())) {
//                                Activity activityItem = activityMap.get(item);
//                                ActivityDataEntryVO dataEntryVO = new ActivityDataEntryVO();
//                                BeanUtils.copyProperties(activityDataEntryVO, dataEntryVO);
//                                dataEntryVO.setName(activityItem.getLang().isEmpty() || null == activityItem.getLang().get("name").get(localeStr) ? activityItem.getName()
//                                        : activityItem.getLang().get("name").get(localeStr));
//                                dataEntryVO.setCode(activityItem.getCode());
//                                //是否公共基础资料 2024/1/25 虚拟公共应用移除
//                                dataEntryVO.setIfCommon(false);
//                                dataEntryVO.setCommonApp(null == applicationRelation.getCommonApp() ? false : applicationRelation.getCommonApp());
//                                dataEntryVO.setResCode(activityItem.getResCode());
//                                dataEntryVO.setCategory(activityItem.getCategory());
//                                dataEntryVO.setCategoryAbi(activityItem.getCategoryAbi());
//                                dataEntryVO.setAppCode(null == applicationRelation ? null : applicationRelation.getAppCode());
//                                dataEntryVO.setAppName(null == applicationRelation ? "缺少应用关系配置" : applicationRelation.getAppName());
//                                dataEntryVO.setGroupCode(StringUtils.isEmpty(activityItem.getGroupCode()) ? null : activityItem.getGroupCode());
//                                dataEntryVO.setSort(null == activityItem.getSequence() ? null : String.valueOf(activityItem.getSequence()));
//                                dataEntryVO.setSubReport(activityItem.getSubReport());
//                                if (applicationRelation.getCommonApp()) {
//                                    if (finalCommonAppsIncludedItems.contains(dataEntryVO.getCode())) {
//                                        activityDataEntryVOS.add(dataEntryVO);
//                                    }
//                                } else {
//                                    activityDataEntryVOS.add(dataEntryVO);
//                                }
//                            }
//                        });
//                    }
//                }
//            });
//        }
//        //tbb Activity
//        List<String> tbbActivityCodes = activities.stream()
//                .filter(item -> !StringUtils.isEmpty(tbbCodeApplicationMap.get(item.getCode()))).map(Activity::getCode)
//                .collect(Collectors.toList());
//        if (!CollectionUtils.isEmpty(tbbActivityCodes)) {
//            Map<String, ApplicationRelation> applicationRelationMap =
//                    applicationService.getApplicationRelationsMapByApplicationAndLang(tbbCodeApplicationMap.values(), localeStr);
//            tbbActivityCodes.forEach(item -> {
//                if (!(StringUtils.equals(hasGroundEndTemp, "N") && activityHasGroundEndMap.get(item) != null && activityHasGroundEndMap.get(item))) {
//                    //租户自定义报表:tbb报表application处理,直接根据appcode查app
//                    ApplicationRelation applicationRelation = applicationRelationMap.get(item);
//                    if (appCodes.contains(applicationRelation.getAppCode())) {
//                        //applicationRelations.add(applicationRelation);
//                        ActivityDataEntryVO activityDataEntryVO = new ActivityDataEntryVO();
//                        Activity activityItem = activityMap.get(item);
//                        activityDataEntryVO.setName(activityItem.getLang().isEmpty() || null == activityItem.getLang().get("name").get(localeStr) ? activityItem.getName()
//                                : activityItem.getLang().get("name").get(localeStr));
//                        //是否公共基础资料
//                        activityDataEntryVO.setIfCommon("common".equalsIgnoreCase(activityItem.getNameSpace()) ?
//                                Boolean.TRUE : Boolean.FALSE);
//                        activityDataEntryVO.setCode(activityItem.getCode());
//                        activityDataEntryVO.setResCode(activityItem.getResCode());
//                        activityDataEntryVO.setCategory(activityItem.getCategory());
//                        activityDataEntryVO.setCategoryAbi(activityItem.getCategoryAbi());
//                        activityDataEntryVO.setAppCode(null == applicationRelation ? null : applicationRelation.getAppCode());
//                        activityDataEntryVO.setAppName(null == applicationRelation ? "缺少应用关系配置" : applicationRelation.getAppName());
//                        activityDataEntryVO.setGroupCode(StringUtils.isEmpty(activityItem.getGroupCode()) ? null : activityItem.getGroupCode());
//                        activityDataEntryVO.setSort(null == activityItem.getSequence() ? null : String.valueOf(activityItem.getSequence()));
//                        activityDataEntryVO.setIfCustom(true);
//                        activityDataEntryVO.setSubReport(activityItem.getSubReport());
//                        activityDataEntryVOS.add(activityDataEntryVO);
//                    }
//                }
//            });
//        }
//        log.info("return getActivitiesByPattern run for {}ms", System.currentTimeMillis() - start);
//        return activityDataEntryVOS;
    }

    private Set<String> getCommonAppIds(Map<String, List<ApplicationRelation>> applicationRelationsMap) {
        Set<String> commonAppIds = new HashSet<>();
        applicationRelationsMap.forEach((k, v) -> {
            ApplicationRelation applicationRelation = v.get(0);
            if (applicationRelation.getCommonApp()) {
                commonAppIds.add(applicationRelation.getAppCode());

            }
        });
        return commonAppIds;
    }

    private Set<String> getCommonAppsIncludedItems(Map<String, List<ApplicationRelation>> applicationRelationsMap) {
        Set<String> appIdSet = getCommonAppIds(applicationRelationsMap);
        Set<String> commonAppsIncludedItems = Collections.emptySet();
        if (!CollectionUtils.isEmpty(appIdSet)) {
            commonAppsIncludedItems = new HashSet<>(dataMapIamService.appItems(new ArrayList<>(appIdSet)));
        }
        Set<String> finalCommonAppsIncludedItems = commonAppsIncludedItems;
        return finalCommonAppsIncludedItems;
    }

    private Map<String, Boolean> getActivityHasGroundEnd(List<Activity> activities) {
        if (CollectionUtils.isEmpty(activities)) {
            return new HashMap<>();
        }
        List<Activity> allActivityList = new ArrayList<>();
        Map<String, List<Activity>> groupByVersionActivityMap = activities.stream().collect(Collectors.groupingBy(e -> e.getVersion() == null ? "" : e.getVersion()));
        Set<Map.Entry<String, List<Activity>>> entries = groupByVersionActivityMap.entrySet();
        for (Map.Entry<String, List<Activity>> entry : entries) {
            List<Activity> value = entry.getValue();
            List<String> activityCodeList = value.stream().map(Activity::getCode).collect(Collectors.toList());
            Query query = Query.query(Criteria.where("code").in(activityCodeList)
                    .and("version").is(entry.getKey()));
            query.fields().include("code").include("dependOnGroundEnd");
            List<Activity> activityConfig = mongoTemplate.find(query, Activity.class, "activityConfigs");
            if (!CollectionUtils.isEmpty(activityConfig)) {
                allActivityList.addAll(activityConfig);
            }
        }
        Map<String, Boolean> resultMap = allActivityList.stream().collect(Collectors.toMap(Activity::getCode, e -> BooleanUtils.toBoolean(e.getDependOnGroundEnd()), (a, b) -> a));
        return resultMap;
    }

    private void handleTBBTenantReports(String pattern, String tenantId, String tenantVersion, List<Activity> activities, Map<String, String> tbbCodeApplicationMap) {
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where("tenantId").is(tenantId).and("version").is(tenantVersion);
        queryUser.addCriteria(criteriaUser);
        List<TBBReportReplacer> tbbReportReplacers = mongoTemplateUser.find(queryUser, TBBReportReplacer.class, "tbbReports");
        List<Activity> tbbActivities = new LinkedList<>();
        Set<String> replaceIdSet = new HashSet<>();
        if (!CollectionUtils.isEmpty(tbbReportReplacers)) {
            tbbReportReplacers.forEach(item -> {
                item.getReports().forEach(itemj -> {
                    if ((pattern.equals("STATEMENT") && itemj.getMode().equals("pc")) ||
                            (pattern.equals("MOBI-STATEMENT") && itemj.getMode().equals("mobile"))) {
                        Activity activity = new Activity();
                        //设置为租户覆盖的id
                        activity.setCode(itemj.getId());
                        Map<String, Map<String, String>> langMap = new HashMap<>();
                        langMap.put("name", itemj.getName());
                        activity.setLang(langMap);
                        tbbCodeApplicationMap.put(itemj.getId(), item.getProductCode());
                        if (!StringUtils.isEmpty(itemj.getReplaceId())) {
                            replaceIdSet.add(itemj.getReplaceId());
                        }
                        tbbActivities.add(activity);
                    }
                });
            });
        }
        //过滤掉被替换旧数据数据
        if (!CollectionUtils.isEmpty(activities)) {
            activities = activities.stream().filter(activity -> !replaceIdSet.contains(activity.getCode())).collect(Collectors.toList());
        } else {
            activities = new LinkedList<>();
        }
        if (!CollectionUtils.isEmpty(tbbActivities)) {
            tbbActivities.forEach(tbbActivity -> tbbActivity.setCategory("STATEMENT"));
            activities.addAll(tbbActivities);
        }
    }

    private void filterUc(List<Activity> activities,String tenantId){

        Iterator<Activity> activityIterator = activities.iterator();
        List<String> ucCodes = new ArrayList<>();
        while (activityIterator.hasNext()){
            Activity activity  = activityIterator.next();
            if(null!=activity.getInclusionTenant()){
                if(!activity.getInclusionTenant().contains(tenantId)){
                    activityIterator.remove();
                }else{
                    if(activity.getCode().startsWith("UC_")){
                        ucCodes.add(activity.getCode().replace("UC_",""));
                    }
                }
            }
        }

    }


    @Override
    public Object getActivitiesInfoByPattern() throws Exception {
        List<ActivityDataEntryVO> activityDataEntryVOS = new LinkedList<>();
        List<String> appCodes = kmService.userAuthApps();
        String localeStr = ServiceUtils.getLocale();

        DWServiceContext context = DWServiceContext.getContext();
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        CompletableFuture<List<ActivityDataEntryVO>> service1Future = CompletableFuture.supplyAsync(() -> {

            // 基础资料
            try{
                DWServiceContext.setContext(context);
                RequestContextHolder.setRequestAttributes(requestAttributes);
                List<ActivityDataEntryVO> baseList = (List<ActivityDataEntryVO>) this.getActivitiesByPattern("DATA_ENTRY");
                baseList.forEach(data -> {
                    data.setType("baseDataEntry");
                });
                return baseList;
            }catch (Exception e){
                log.error("getActivitiesInfoByPattern error:{}", e);
            }
            return new ArrayList<>();
        });

        CompletableFuture<List<ActivityDataEntryVO>> service2Future = CompletableFuture.supplyAsync(() -> {
            // 报表
            try{

                DWServiceContext.setContext(context);
                RequestContextHolder.setRequestAttributes(requestAttributes);
                List<ActivityDataEntryVO>  reportList = (List<ActivityDataEntryVO>) this.getActivitiesByPattern("STATEMENT");
                reportList.forEach(data -> {
                    data.setType("statement");
                });
                return reportList;
            }catch (Exception e){
                log.error("getActivitiesInfoByPattern error:{}", e);
            }
            return new ArrayList<>();
        });

        CompletableFuture<List<ProjectVo>> service3Future = CompletableFuture.supplyAsync(() -> {
            try {

                DWServiceContext.setContext(context);
                RequestContextHolder.setRequestAttributes(requestAttributes);
                // 发起项目
                List<ProjectVo> jsonObjectList =  dataMapTaskService.getManualList();
                return jsonObjectList;
            }catch (Exception e){
                log.error("getActivitiesInfoByPattern error:{}", e);
            }
            return new ArrayList<>();
        });

        CompletableFuture<Void> allOf = CompletableFuture.allOf(service1Future, service2Future, service3Future);
        List<ActivityDataEntryInfoVO> resultList = new LinkedList<>();
        allOf.thenRun(() -> {
            try{
                RequestContextHolder.setRequestAttributes(requestAttributes);
                // 三个服务请求完毕后的后续处理
                List<ActivityDataEntryVO> baseList = service1Future.join();

                List<ActivityDataEntryVO> reportList = service2Future.join();

                List<ProjectVo> jsonObjectList = service3Future.join();

                // 进行后续处理
                ApplicationRelationQueryDTO queryDTO = ApplicationRelationQueryDTO.builder().appCodes(appCodes).type("task").build();
                List<ApplicationRelation> applicationRelationList = applicationService.postApplicationRelationByTypeAndAppCodes(queryDTO);
                Map<String, List<ApplicationRelation>> map = applicationRelationList.stream().collect(Collectors.groupingBy(ApplicationRelation::getCode));
                for (ProjectVo jsonObject : jsonObjectList) {
                    List<ApplicationRelation> applicationRelations = map.get(jsonObject.getCode());

                    if (!CollectionUtils.isEmpty(applicationRelations)) {
                        List<ApplicationRelation> handlerList = applicationRelations.stream()
                                .collect(Collectors.collectingAndThen(
                                                Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(
                                                        ApplicationRelation::getCode))), ArrayList::new
                                        )
                                );

                        handlerList.forEach(applicationRelation -> {
                            ActivityDataEntryVO activityDataEntryVO = new ActivityDataEntryVO();
                            activityDataEntryVO.setAppCode(null == applicationRelation ? null : applicationRelation.getAppCode());
                            activityDataEntryVO.setAppName(null == applicationRelation ? "缺少应用关系配置" : applicationRelation.getAppName());

                            activityDataEntryVO.setName(ServiceUtils.localeName(jsonObject, "name", localeStr));
                            activityDataEntryVO.setCode(jsonObject.getCode());
                            activityDataEntryVO.setType("manualStartProject");
                            activityDataEntryVO.setCategory(null);
                            activityDataEntryVO.setIfCustom(null);

                            activityDataEntryVOS.add(activityDataEntryVO);
                        });
                    }
                }

                activityDataEntryVOS.addAll(baseList);
                activityDataEntryVOS.addAll(reportList);

                Map<String, List<ActivityDataEntryVO>> maps = activityDataEntryVOS.stream()
                        .filter(item -> !StringUtils.isEmpty(item.getAppCode()))
                        .collect(Collectors.groupingBy(ActivityDataEntryVO::getAppCode));

                maps.forEach((key, value) -> {

                    List<ActivityDataEntryInfoVO.ActivityDataEntryInnerVO> activityDataEntryInnerVO = new LinkedList<>();

                    ActivityDataEntryInfoVO activityDataEntryVO = new ActivityDataEntryInfoVO();
                    activityDataEntryVO.setAppCode(value.get(0).getAppCode());
                    activityDataEntryVO.setAppName(value.get(0).getAppName());

                    value.forEach(data -> {
                        ActivityDataEntryInfoVO.ActivityDataEntryInnerVO activityDataEntryInner = new ActivityDataEntryInfoVO.ActivityDataEntryInnerVO();
                        activityDataEntryInner.setName(data.getName());
                        activityDataEntryInner.setCode(data.getCode());
                        activityDataEntryInner.setType(data.getType());
                        activityDataEntryInner.setIfCustom(data.getIfCustom());
                        activityDataEntryInner.setCategory(data.getCategory());
                        activityDataEntryInnerVO.add(activityDataEntryInner);
                    });

                    activityDataEntryVO.setData(activityDataEntryInnerVO);

                    resultList.add(activityDataEntryVO);

                });


            }catch(Exception e){
                log.error("getActivitiesInfoByPattern error:{}", e);
            }
        }).join();
        return resultList;


    }

    @Override
    public Object getActivitiesByPatternAndAppCode(String pattern, String appCode) throws Exception {
        List<ActivityDataEntryVO> activitiesByPattern = (List<ActivityDataEntryVO>) this.getActivitiesByPattern(pattern);
        if (!CollectionUtils.isEmpty(activitiesByPattern)) {
            Iterator<ActivityDataEntryVO> iterator = activitiesByPattern.iterator();
            while (iterator.hasNext()) {
                ActivityDataEntryVO next = iterator.next();
                if (!StringUtils.equals(next.getAppCode(), appCode)) {
                    iterator.remove();
                }
            }
        }
        return activitiesByPattern;
    }

    @Override
    public Object getActivitiesAndSortByPattern(String pattern) throws Exception {
//        List<ActivityDataEntryVO> activitiesByPattern = (List<ActivityDataEntryVO>) getActivitiesByPattern(pattern);
//        postActivitiesGroup(activitiesByPattern);
//        filterComponentByCode(activitiesByPattern, pattern);
        return getActivitiesByPatternOrSubTypeSort(pattern, KmService.patternToSubType.get(pattern));
    }

    @Override
    public Object getActivityDefinition(String activityId, String pageCode) throws Exception {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = kmService.tenantVersion();
        Activity activity = dataPickService.chooseOneWithSameCode(dataMapActivityDAO.getActivityByCodeAndVersion(activityId, tenantVersion, tenantId));
        //校验关联的应用是否过期
//        if (null == activity || !activity.getNameSpace().equalsIgnoreCase("common")) {
//            this.applicationService.checkRelatedAppHasExpired("activity", activityId);
//        }
        if (null == activity) {
            Object dm = dataMapTaskService.getActivityDefinition(activityId,pageCode);
            if (null != dm) {
                return dm;
            }
        }
        if(null==activity){
            return null;
        }
        String activityVersion = activity.getVersion();

        Activity activityPageConfig = findBetterActivity(tenantId, activityId, activityVersion);

        if (null != activityPageConfig) {
            if (null != activityPageConfig.getPages()) {
                activityPageConfig.setPages((Map<String, Object>) activityPageConfig.getPages().get(pageCode));
            }
            //处理API信息
            // 原来setMapProductInfo循环调用获取产品名称赋值改为批量处理
            batchSetProductInfo(activityPageConfig.getDataSources(), tenantId);
            batchSetProductInfo(activityPageConfig.getPages(), tenantId);
            //基础资料维护没有审核相关

            AthenaUtils.mergeObject(activityPageConfig, activity);

        }

        //查询是否有设置abi报表查询字段，有就去处理报表查询字段的排序
        try {
            ReportConditionSetting setting = dataMapReportConditionService.findQueryConditionSetting(tenantId,activityId,tenantVersion);
            if (null != setting && org.apache.commons.collections.CollectionUtils.isNotEmpty(setting.getSortData())){
                dealReportSort(activity,setting.getSortData());
            }
        } catch (Exception e) {
            log.warn("activity dealReportSort error:", e);
        }
        //同时返回app信息
        processApplication(activityId, activity);
        try {
            ApplicationRelation applicationRelation = applicationService.getApplicationByTypeAndCode("activity", activity.getCode());
            FunctionCtrl functionCtrl = applicationService.getApplicationFunctionCtrlByAppCode(applicationRelation.getAppCode());
            boolean cardCustomizeFlag = this.isCardCustom(functionCtrl);
            if (cardCustomizeFlag) {
                processSysSummaryFields(activity);
                //获取租户级summaryFields
                processTenantSummaryFields(activity, pageCode);
            }
        } catch (Exception e) {
            log.warn("parse activity error:"+e.getMessage());
            return activity;
        }

        return activity;
    }

    @Override
    public Object getActivityDefinitionBasic(String activityId, String pageCode) throws Exception {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = kmService.tenantVersion();
        Activity activity = dataPickService.chooseOneWithSameCode(dataMapActivityDAO.getActivityByCodeAndVersion(activityId, tenantVersion, tenantId));
        if(null==activity){
            return null;
        }
        String activityVersion = activity.getVersion();

        Activity activityPageConfig = findBetterActivity(tenantId, activityId, activityVersion);

        if (null != activityPageConfig) {
            if (null != activityPageConfig.getPages()) {
                activityPageConfig.setPages((Map<String, Object>) activityPageConfig.getPages().get(pageCode));
            }
            //处理API信息
            // 原来setMapProductInfo循环调用获取产品名称赋值改为批量处理
            batchSetProductInfo(activityPageConfig.getDataSources(), tenantId);
            batchSetProductInfo(activityPageConfig.getPages(), tenantId);
            //基础资料维护没有审核相关
            AthenaUtils.mergeObject(activityPageConfig, activity);
        }
        //同时返回app信息
        processApplication(activityId, activity);

        processSysSummaryFields(activity);

        return activity;
    }


    private void clearTenantTBBReportsByProductCode(String productCode, String tenantId, String tenantVersion) throws DWBusinessException {
        //查找当前应用下所有activity
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where("tenantId").is(tenantId).and("version").is(tenantVersion).and("productCode").is(productCode);
        queryUser.addCriteria(criteriaUser);
        mongoTemplateUser.remove(queryUser, "tbbReports");
    }
    private void writeNewReportToDB(TBBReportReplacer reportReplaceDO) {
        mongoTemplateUser.insert(reportReplaceDO, "tbbReports");
    }


    public List<ActivityDataEntryVO> postActivitiesGroup(List<ActivityDataEntryVO> requestList) throws Exception {
        log.info("start postActivitiesGroup:{}", System.currentTimeMillis());
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = kmService.tenantVersion();
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String lang = locale.toString();
        for (ActivityDataEntryVO vo : requestList) {
            ApplicationGroup applicationGroup;
            if (!StringUtils.isEmpty(vo.getGroupCode())) {
                Criteria criteria = new Criteria();
                criteria.and("appCode").exists(false).and("groupCode").is(vo.getGroupCode()).and("version").is(tenantVersion);
                applicationGroup = mongoTemplate.findOne(new Query(criteria), ApplicationGroup.class);
            } else {
                //公共基础资料的activity groupCode不在本节点定义
                Criteria criteria = new Criteria();
                criteria.and("appCode").is(vo.getAppCode()).and("activityCode").is(vo.getCode()).and("version").is(tenantVersion);
                applicationGroup = mongoTemplate.findOne(new Query(criteria), ApplicationGroup.class);
                if (null != applicationGroup) {
                    vo.setGroupCode(applicationGroup.getGroupCode());
                }
            }
            if (null != applicationGroup && null != applicationGroup.getLang()) {
                vo.setGroupSort(StringUtils.isEmpty(applicationGroup.getGroupSort()) ? null :
                        applicationGroup.getGroupSort());
                //vo.setSort(StringUtils.isEmpty(applicationGroup.getSort()) ? null : applicationGroup.getSort());
                Map nameLangMap = applicationGroup.getLang().get("groupName");
                if (null == nameLangMap) {
                    nameLangMap = applicationGroup.getLang().get("name") == null ? new HashMap<>() :
                            applicationGroup.getLang().get("name");
                }
                String language = (null == nameLangMap.get(lang)) ? applicationGroup.getGroupName() : (String) nameLangMap.get(lang);
                vo.setGroupName(null == language ? applicationGroup.getGroupName() : language);
            }
        }
        log.info("end postActivitiesGroup:{}", System.currentTimeMillis());
        return requestList;
    }


    private void filterComponentByCode(List<ActivityDataEntryVO> activitiesByPattern, String pattern) throws DWBusinessException {
        if (CollectionUtils.isEmpty(activitiesByPattern)) {
            return;
        }
        List<String> appCodeList =
                activitiesByPattern.stream().map(ActivityDataEntryVO::getAppCode).distinct().collect(Collectors.toList());
        Query query = new Query();
        query.addCriteria(Criteria.where(ComponentConstants.APP_CODE).in(appCodeList)
                .and(ComponentConstants.TENANT_ID).is(ServiceUtils.getTenantId()));
        List<TenantAppComponentListBO> tenantAppComponentListBOS = mongoTemplateUser.find(query,
                TenantAppComponentListBO.class);
        if (!CollectionUtils.isEmpty(tenantAppComponentListBOS)) {
            //生成key为应用code value为此租户下允许的codeList的map  过滤条件为type和非禁用
            Map<String, List<String>> map =
                    tenantAppComponentListBOS.stream().collect(Collectors.toMap(TenantAppComponentListBO::getAppCode,
                            vo -> {
                                if (CollectionUtils.isEmpty(vo.getComponents())) {
                                    return new ArrayList<>();
                                } else {
                                    return vo.getComponents().stream().filter(v -> v.getType().equals(transformPattern(pattern)) && !v.isDisabled()).map(ComponentBO::getCode).distinct().collect(Collectors.toList());
                                }
                            }, (a, b) -> a));

            Iterator<ActivityDataEntryVO> iterator = activitiesByPattern.iterator();
            while (iterator.hasNext()) {
                ActivityDataEntryVO next = iterator.next();
                if (map.containsKey(next.getAppCode())) {
                    //权限允许的codeList
                    List<String> codeList = map.get(next.getAppCode());
                    if (!CollectionUtils.isEmpty(codeList)) {
                        if (codeList.contains(next.getCode())) {
                            continue;
                        }
                        iterator.remove();
                    }
                }
            }
        }
    }

    private ComponentTypeEnum transformPattern(String pattern) {
        if ("DATA_ENTRY".equals(pattern)) {
            return ComponentTypeEnum.BaseDataEntry;
        } else if ("STATEMENT".equals(pattern) || "MOBI-STATEMENT".equals(pattern)) {
            return ComponentTypeEnum.Report;
        }
        log.error("not found pattern:{}", pattern);
        return null;
    }


    public Activity findBetterActivity(String tenantId, String activityCode, String activityVersion) throws DWBusinessException {

        Map<String, Object> keyConditions = new HashMap<>();
        keyConditions.put("code", activityCode);

    //    Query query2 = Query.query(Criteria.where("code").is(activityCode).and("version").is(activityVersion).and("tenantId").is(tenantId));
        Activity defaultActivity = dataMapMongoEntityBaseDAO.findOne(keyConditions, activityVersion, Activity.class, "activityConfigs");
//        Activity tenantActivity = mongoTemplateUser.findOne(query2, Activity.class, "activityConfigs");
//        if (null != tenantActivity) {
//            AthenaUtils.mergeObject(tenantActivity, defaultActivity, MergePolicyBuilder.getPolicy(Activity.class.getName()));
//        }

        return defaultActivity;
    }



    private void batchSetProductInfo(Map<String, Object> data, String tenantId) throws Exception {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        // 定义Map类型的data平铺接收容器
        List<Map<String, Object>> actionMap = new ArrayList<>();
        // 递归Map嵌套类型并平铺为actionMap
        batchMapSetActionMap(data, tenantId, actionMap);
        // 批量设置Action产品名称
        batchSetDataActionProductInfo(actionMap, tenantId);
    }

    /**
     * 递归Map嵌套类型并平铺为actionMap
     * @param data      Map数据源
     * @param tenantId  租户ID
     * @param actionMap 目标action集合
     * @throws Exception
     */
    private void batchMapSetActionMap(Map<String, Object> data, String tenantId, List<Map<String, Object>> actionMap) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        // map结构的数据加入actionMap
        actionMap.add(data);
        for (Map.Entry<String, Object> item : data.entrySet()) {
            Object value = item.getValue();
            if (value instanceof Map) {
                batchMapSetActionMap((Map) value, tenantId, actionMap);
            } else if (value instanceof List) {
                batchListSetActionMap((List) value, tenantId, actionMap);
            }
        }
    }

    /**
     * 递归List的Map嵌套类型并平铺为actionMap
     * @param data      List数据源
     * @param tenantId  租户ID
     * @param actionMap 目标action集合
     * @throws Exception
     */
    public void batchListSetActionMap(List data, String tenantId, List<Map<String, Object>> actionMap) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        for (Object item : data) {
            if (item instanceof Map) {
                batchMapSetActionMap((Map) item, tenantId, actionMap);
            } else if (item instanceof List) {
                batchListSetActionMap((List) item, tenantId, actionMap);
            }
        }
    }

    /**
     * 批量设置Action产品名称
     * @param actions   actions
     * @param tenantId  租户ID
     * @throws Exception
     */
    public void batchSetDataActionProductInfo(List<Map<String, Object>> actions, String tenantId) throws Exception {
        if (CollectionUtils.isEmpty(actions)) {
            return;
        }
        // 过滤出产品名称为空且是ESP类型的并且serviceName不为空
        actions = actions.stream()
                .filter(action -> (ObjectUtils.isEmpty(action.get("productName")))
                        && "ESP".equalsIgnoreCase(String.valueOf(action.get("type")))
                        && StringUtils.isNotEmpty(String.valueOf(action.get("serviceName")))
                ).collect(Collectors.toList());
        // 再次判空处理
        if (CollectionUtils.isEmpty(actions)) {
            return;
        }
        // 获取serviceName集合
        List<String> serviceNames = actions.stream().map(action -> String.valueOf(action.get("serviceName"))).distinct().collect(Collectors.toList());
        Map<String, String> serviceNameMap = productNameResolver.getProductNameMap(tenantId, serviceNames);
        // 设置产品名称
        for (Map<String, Object> action : actions) {
            action.put("productName", serviceNameMap.get(String.valueOf(action.get("serviceName"))));
        }
    }
    private void dealReportSort(Activity activity,List<Map<String, Object>> sortData) {
        if(activity != null){
            Map<String, Object> pages = activity.getPages();
            if (null != pages){
                if (!CollectionUtils.isEmpty((List) pages.get("layout"))) {
                    List<Map<String, Object>> layoutList = (List<Map<String, Object>>) pages.get("layout");
                    // 遍历layout集合
                    for (Map<String, Object> layout : layoutList) {
                        if ("FORM_LIST".equals(layout.get("type"))) {
                            // 递归处理group字段
                            processGroup(layout, sortData);
                        }
                    }
                }

            }
        }
    }

    private static void processGroup(Map<String, Object> layout, List<Map<String, Object>> sortData) {
        List<Map<String, Object>> group = (List<Map<String, Object>>) layout.get("group");
        if (group != null) {
            // 找到匹配的sortData对象
            Optional<Map<String, Object>> sortItemOpt = sortData.stream()
                    .filter(item -> ((String) layout.get("id")).equals(item.get("id")))
                    .findFirst();
            if (sortItemOpt.isPresent()) {
                // 如果匹配到sortData对象，根据sortField排序group字段
                Map<String, Integer> sortIndexMap = createSortIndexMap(sortItemOpt.get());
                group.sort(Comparator.comparingInt(item -> {
                    String pathSchema = (String) item.get("path") + ";" + item.get("schema");
                    return sortIndexMap.getOrDefault(pathSchema, 99999); // 不在sortField中的放后面,给与足够大的数值99999，排序时放后面
                }));
            }
            // 递归处理嵌套的FORM_LIST对象
            group.forEach(subItem -> {
                if ("FORM_LIST".equals(subItem.get("type"))) {
                    processGroup(subItem, sortData); // 递归调用
                }
            });
        }
    }

    public static Map<String, Integer> createSortIndexMap(Map<String, Object> sortItem) {
        List<String> sortFields = (List<String>) sortItem.get("sortField");
        if (sortFields == null){
            return new HashMap<>();
        }
        //使用 toMap 的重载版本,如果出现键值冲突，合并函数将选择保留现有的值(即)
        return sortFields.stream()
                .collect(Collectors.toMap(
                        field -> field,
                        field -> sortFields.indexOf(field),
                        (existingValue, newValue) -> existingValue // 合并函数，这里简单地选择保留现有值
                ));
    }
    private void processApplication(String activityId, Activity activity) throws DWBusinessException {
        if (null != activity) {
            ApplicationRelation applicationRelation = applicationService.getApplicationByTypeAndCodeAndLang1("activity", activityId, AthenaUtils.getCurrentLocale());
            if (null != applicationRelation) {
                activity.setApplication(applicationRelation.getAppCode());
                activity.setAppName(applicationRelation.getAppName());
            }
            //dto
            activity.setActivityId(activityId);
            activity.setActivityName(activity.getName());
            if(null!=activity.getLang()){
                activity.getLang().put("activityName", activity.getLang().get("name"));
            }
        }
    }

    private void processSysSummaryFields(Activity activity) {
        if (null != activity) {
            Map<String, Object> pages = activity.getPages();
            if (!CollectionUtils.isEmpty(pages)) {
                List<Map<String, Object>> dataStates = (List<Map<String, Object>>) pages.get("dataStates");

                if (!CollectionUtils.isEmpty(dataStates)) {

                    //新结构处理
                    dataStates.forEach(dataState -> {
                        if(SUMMARY.equals(dataState.get("type"))){
                            activity.setSummary(dataState);
                            activity.setSummaryFields((List<Map<String, Object>>) dataState.get("fieldMappings"));
                        }
                        if(BUSINESS_INFO.equals(dataState.get("type"))){
                            activity.setBusinessInfo(dataState);
                        }
                        if(SEARCH_KEY.equals(dataState.get("type"))){
                            activity.setSearchKey(dataState);
                        }
                        if(PROJECT_INFO.equals(dataState.get("type"))){
                            activity.setProjectInfo(dataState);
                        }
                    });

                    //不存在新结构，按原逻辑处理
                    if(!checkNewSummary(activity)){
                        List<Map<String, Object>> summaryFields = (List<Map<String, Object>>) dataStates.get(0).get("summaryFields");
                        activity.setSummaryFields(summaryFields);
                    }

                } else{
                    List<Map<String, Object>> summaryFieldsCandidate = (List<Map<String, Object>>) pages.get("summaryFields");
                    if (!CollectionUtils.isEmpty(summaryFieldsCandidate)) {
                        activity.setSummaryFields(summaryFieldsCandidate);
                    }
                }
            }
        }
    }

    private void processTenantSummaryFields(Activity activity, String pageCode) throws DWBusinessException {
        if (null != activity) {
            String application = activity.getApplication();
            String code = activity.getCode();
            String type;
            switch (pageCode) {
                case "project-card":
                    type = "project";
                    break;
                case "task-card":
                    type = "task";
                    break;
                default:
                    type = null;
            }
            if(checkNewSummary(activity)){
                //新结构
                newProcessTenantSummaryFields(activity, pageCode);
            }else {
                // 开发平台增加了标识，不是所有字段都能作为摘要字段
                activity.setCanSelectedSummaryFields(ObjectUtil.cloneByStream(activity.getSummaryFields()));
                if (type != null && null != application) {
                    TenantSummaryFields tenantSummaryFields = queryTenantSummaryFields(application, type, code);
                    if (null != tenantSummaryFields) {
                        boolean ifUseTenantSummaryFields = judgeIfUseTenantSummaryFields(tenantSummaryFields, activity.getSummaryFields());
                        boolean ifUseTenantTitle = judgeIfUseTenantTitle(tenantSummaryFields);
                        if (ifUseTenantSummaryFields) {
                            if (!CollectionUtils.isEmpty(tenantSummaryFields.getSummaryFields())) {
                                List<Map<String, Object>> transformedTenantSummaryFields = transformTenantFieldsToSys(tenantSummaryFields, activity.getSummaryFields());
                                List<Map<String, Object>> mergedSummaryFields = mergeSummaryFields(activity.getSummaryFields(), transformedTenantSummaryFields);
                                Map<String, Object> pages = activity.getPages();
                                if (null != pages.get("dataStates") && !CollectionUtils.isEmpty((List) pages.get("dataStates"))) {
                                    List<Map<String, Object>> dataStates = (List<Map<String, Object>>) pages.get("dataStates");
                                    Map<String, Object> dataState = dataStates.get(0);
                                    dataState.put("summaryFields", mergedSummaryFields);
                                } else {
                                    pages.put("summaryFields", mergedSummaryFields);
                                }
                                activity.setSummaryFields(mergedSummaryFields);
                            }
                            activity.setUsedTenantSummaryFields(true);
                        } else {
                            activity.setUsedTenantSummaryFields(false);
                        }
                        //判断是否使用租户自定义标题
                        if (ifUseTenantTitle && activity.getUsedTenantSummaryFields()) {
                            TenantCardTitleDefinition tenantCardTitleDefinition = new TenantCardTitleDefinition();
                            tenantCardTitleDefinition.setFields(tenantSummaryFields.getTitle());
                            tenantCardTitleDefinition.setTitlePrefix(tenantSummaryFields.getTitlePrefix());
                            activity.setTenantCardTitleDefinition(tenantCardTitleDefinition);
                            //activity.setUsedTenantSummaryFields(true);
                        }
                        activity.setTenantSummaryFields(transformToTenantSummaryFieldsDTO(tenantSummaryFields));
                    } else {
                        activity.setUsedTenantSummaryFields(false);
                    }
                } else {
                    activity.setUsedTenantSummaryFields(false);
                }
                filterSummaryFields(activity);
            }
        }
    }
    private TenantSummaryFieldsDto transformToTenantSummaryFieldsDTO(TenantSummaryFields tenantSummaryFields) {
        return JSON.parseObject(JSON.toJSONString(tenantSummaryFields), TenantSummaryFieldsDto.class);
    }

    private void newProcessTenantSummaryFields(Activity activity, String pageCode) throws DWBusinessException {
        if (null != activity) {
            String application = activity.getApplication();
            String code = activity.getCode();
            String type;
            switch (pageCode) {
                case "project-card":
                    type = "project";
                    break;
                case "task-card":
                    type = "task";
                    break;
                default:
                    type = null;
            }
            List<Map<String, Object>> newSummaryFieldes = (List<Map<String, Object>>) activity.getSummary().get("fieldMappings");
            // 开发平台增加了标识，不是所有字段都能作为摘要字段
            activity.setCanSelectedSummaryFields(ObjectUtil.cloneByStream(newSummaryFieldes));
            if (type != null && null != application) {
                TenantSummaryFields tenantSummaryFields = queryTenantSummaryFields(application, type, code);
                if (null != tenantSummaryFields) {
                    boolean ifUseTenantSummaryFields = judgeIfUseTenantSummaryFields(tenantSummaryFields, newSummaryFieldes);
                    boolean ifUseTenantTitle = judgeIfUseTenantTitle(tenantSummaryFields);
                    if (ifUseTenantSummaryFields) {
                        if (!CollectionUtils.isEmpty(tenantSummaryFields.getSummaryFields())) {
                            List<Map<String, Object>> transformedTenantSummaryFields = transformTenantFieldsToSys(tenantSummaryFields, newSummaryFieldes);
                            List<Map<String, Object>> mergedSummaryFields = transformedTenantSummaryFields;
                            Map<String, Object> pages = activity.getPages();
                            if (null != pages.get("dataStates") && !CollectionUtils.isEmpty((List) pages.get("dataStates"))) {
                                for (Map<String,Object> dataState : (List<Map<String,Object>>) pages.get("dataStates")) {
                                    if (SUMMARY.equals(dataState.get("type"))) {
                                        dataState.put("fieldMappings", mergedSummaryFields);
                                    }
                                }
                            }
                            activity.setSummaryFields(mergedSummaryFields);
                        }
                        activity.setUsedTenantSummaryFields(true);
                    } else {
                        activity.setUsedTenantSummaryFields(false);
                    }
                    //判断是否使用租户自定义标题
                    if (ifUseTenantTitle && activity.getUsedTenantSummaryFields()) {
                        TenantCardTitleDefinition tenantCardTitleDefinition = new TenantCardTitleDefinition();
                        tenantCardTitleDefinition.setFields(tenantSummaryFields.getTitle());
                        tenantCardTitleDefinition.setTitlePrefix(tenantSummaryFields.getTitlePrefix());
                        activity.setTenantCardTitleDefinition(tenantCardTitleDefinition);
                    }
                    activity.setTenantSummaryFields(transformToTenantSummaryFieldsDTO(tenantSummaryFields));
                } else {
                    activity.setUsedTenantSummaryFields(false);
                }
            } else {
                activity.setUsedTenantSummaryFields(false);
            }
            newFilterSummaryFields(activity);
        }
    }

    private boolean checkNewSummary(Activity activity) {
        return !(CollectionUtils.isEmpty(activity.getSummary()) && CollectionUtils.isEmpty(activity.getBusinessInfo()) && CollectionUtils.isEmpty(activity.getSearchKey()) && CollectionUtils.isEmpty(activity.getProjectInfo()));
    }

    private boolean isCardCustom(FunctionCtrl functionCtrl) {
        return functionCtrl != null
                && (functionCtrl.isProjectCardCustomizeFlag() || functionCtrl.isTaskCardCustomizeFlag());
    }

    private TenantSummaryFields queryTenantSummaryFields(String application, String type, String code) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where("tenantId").is(tenantId)
                .and("type").is(type)
                .and("code").is(code)
                .and("application").is(application);
        queryUser.addCriteria(criteriaUser);
        TenantSummaryFields result = mongoTemplateUser.findOne(queryUser, TenantSummaryFields.class);
        return result;
    }

    /**
     * 新的过滤摘要字段
     */
    private void newFilterSummaryFields(Activity activity) throws DWBusinessException {
        if (!CollectionUtils.isEmpty(activity.getSummaryFields()) && !activity.getUsedTenantSummaryFields()) {
            // 只有应用级摘要字段需要按照“默认展示”标识过滤
            // 历史数据默认为true
            activity.getSummaryFields().removeIf(map -> !MapUtils.getBoolean(map, "defaultEffective", true));
            Map<String, Object> pages = activity.getPages();
            if (null != pages.get("dataStates") && !CollectionUtils.isEmpty((List) pages.get("dataStates"))) {
                for (Map<String,Object> dataState : (List<Map<String,Object>>) pages.get("dataStates")) {
                    if (SUMMARY.equals(dataState.get("type"))) {
                        dataState.put("fieldMappings", activity.getSummaryFields());
                    }
                }
            }
        }
        if (!CollectionUtils.isEmpty(activity.getCanSelectedSummaryFields())) {
            // 过滤掉不是摘要字段的，历史数据默认为true
            activity.getCanSelectedSummaryFields().removeIf(map -> !MapUtils.getBoolean(map, "summary", true));
        }
        // 如果之前设置过的租户级摘要字段不在本次可选择的字段中，为了兼容历史数据，需要将租户级字段添加到可选择的字段中
        if (!CollectionUtils.isEmpty(activity.getCanSelectedSummaryFields())) {
            List<Map<String, Object>> canSelectedSummaryFields = activity.getCanSelectedSummaryFields();
            List<Map<String, Object>> tenantSummaryFieldList = activity.getSummaryFields();
            String locale = Optional.ofNullable(AthenaUtils.getCurrentLocale()).orElse("zh_CN");
            String actionId = MapUtils.getString(activity.getCanSelectedSummaryFields().get(0), "actionId");
            List<ApiDataFieldLocaleMetadataDTO> fields = null;
            if (StringUtils.isNotEmpty(actionId)) {
                try {
                    GetActionLocaleResponseDTO actionLocaleResponseDTO = (GetActionLocaleResponseDTO) dataMapActionService.getMetadata(actionId);
                    ApiDataFieldLocaleMetadataDTO data = actionLocaleResponseDTO.getResponse().getData();
                    fields = data.getField();
                } catch (Exception e) {
                    throw new DWBusinessException("查询元数据定义出错，actionId：{}", actionId);
                }
            }
            activity.getCanSelectedSummaryFields().forEach(field -> {
                if (StringUtils.isEmpty(MapUtils.getString(field, "description"))) {
                    Object title = JSONPath.eval(field, "$.tags[0].title");
                    Object localeTitle = JSONPath.eval(field, "$.tags[0].lang.title." + locale);
                    field.put("description", localeTitle != null ? localeTitle : title);
                }
                if (StringUtils.isEmpty(MapUtils.getString(field, "data_name"))) {
                    String value = MapUtils.getString(field, "value", "");
                    field.put("data_name", value.contains(".") ? value.split("\\.")[1] : "");
                }
                if (StringUtils.isEmpty(MapUtils.getString(field, "data_type"))) {
                    field.put("data_type", "string");
                }
            });
            for (Map<String, Object> tenantSummaryField : tenantSummaryFieldList) {
                boolean b = canSelectedSummaryFields.stream().noneMatch(map -> MapUtils.getString(map, "value", "").equals(MapUtils.getString(tenantSummaryField, "value", "")));
                if (b && MapUtils.getBoolean(tenantSummaryField, "summary", true)) {
                    if (fields!=null && fields.size()>0) {
                        Optional<ApiDataFieldLocaleMetadataDTO> dataName = fields.stream().filter(f -> f.getData_name().equals(MapUtils.getString(tenantSummaryField, "data_name", ""))).findFirst();
                        dataName.ifPresent(apiDataFieldLocaleMetadataDTO -> tenantSummaryField.put("description", apiDataFieldLocaleMetadataDTO.getDescription()));
                    }
                    canSelectedSummaryFields.add(tenantSummaryField);
                }
            }
        }
    }

    private boolean judgeIfUseTenantSummaryFields(TenantSummaryFields tenantSummaryFields, List<Map<String, Object>> summaryFields) {
        if (null == tenantSummaryFields) {
            return false;
        } else if (CollectionUtils.isEmpty(summaryFields)) {
            return false;
        } else if (!summaryFields.get(0).get("actionId").equals(tenantSummaryFields.getActionId())) {
            return false;
        }
        return true;
    }

    private boolean judgeIfUseTenantTitle(TenantSummaryFields tenantSummaryFields) {
        if (null == tenantSummaryFields) {
            return false;
        } else {
            String titlePrefix = tenantSummaryFields.getTitlePrefix();
            List<String> title = tenantSummaryFields.getTitle();
            return !(CollectionUtils.isEmpty(title) && StringUtils.isEmpty(titlePrefix));
        }
    }

    private List<Map<String, Object>> transformTenantFieldsToSys(TenantSummaryFields tenantSummaryFields, List<Map<String, Object>> summaryFields) {
        List<TenantSummaryField> tenantSummaryFieldList = tenantSummaryFields.getSummaryFields();
        if (!CollectionUtils.isEmpty(tenantSummaryFieldList)) {
            List<Map<String, Object>> sysSummaryFields = new ArrayList<>(6);
            for (int i = 0; i < tenantSummaryFieldList.size(); i++) {
                List<String> values = tenantSummaryFieldList.get(i).getValue();
                for (int j = 0; j < values.size(); j++) {
                    // 通过字段匹配应用级摘要配置；租户级配置覆盖应用级配置
                    String fieldPath = values.get(j);
                    Optional<Map<String, Object>> first = summaryFields.stream()
                            .filter(map -> fieldPath.equals(MapUtil.getStr(map, "value"))).findFirst();
                    Map<String, Object> sysSummaryField = Maps.newHashMap();
                    if (first.isPresent()) {
                        sysSummaryField = first.get();
                    }
                    Map<String, Object> sysSummaryFieldCopy = ObjectUtil.cloneByStream(sysSummaryField);
                    sysSummaryFieldCopy.put("summary", true);
                    sysSummaryFieldCopy.put("actionId", tenantSummaryFields.getActionId());
                    sysSummaryFieldCopy.put("value", fieldPath);
                    List<Map<String, Object>> tagList = new ArrayList<>(1);
                    Map<String, Object> tag = new HashMap<>();
                    tag.put("code", "group_" + i);
                    tag.put("title", tenantSummaryFieldList.get(i).getTitle());
                    tag.put("customTitle", true);
                    if (StringUtils.isEmpty(MapUtils.getString(sysSummaryFieldCopy, "description"))) {
                        sysSummaryFieldCopy.put("description", tenantSummaryFieldList.get(i).getTitle());
                        sysSummaryFieldCopy.put("data_type", "string");
                        sysSummaryFieldCopy.put("data_name", fieldPath.contains(".") ? fieldPath.split("\\.")[1] : fieldPath);

                    }
                    if (!tag.containsKey("lang")) {
                        JSONObject lang = new JSONObject();
                        JSONObject titleLang = new JSONObject();
                        titleLang.fluentPut("zh_CN", tenantSummaryFieldList.get(i).getTitle())
                                .fluentPut("zh_TW", tenantSummaryFieldList.get(i).getTitle())
                                .fluentPut("en_US", tenantSummaryFieldList.get(i).getTitle());
                        lang.put("title", titleLang);
                        tag.put("lang", lang);
                    }
                    tagList.add(tag);
                    sysSummaryFieldCopy.put("tags", tagList);
                    sysSummaryFields.add(sysSummaryFieldCopy);
                }
            }
            return sysSummaryFields;
        }
        return summaryFields;
    }

    /**
     * 合并摘要
     * @param summaryFields 系统级摘要字段
     * @param transformedTenantSummaryFields 租户级摘要字段
     * @return 合并后的摘要字段
     */
    private List<Map<String, Object>> mergeSummaryFields(List<Map<String, Object>> summaryFields, List<Map<String, Object>> transformedTenantSummaryFields) {
        if (CollectionUtils.isEmpty(summaryFields)) {
            return transformedTenantSummaryFields;
        } else {
            List<Map<String, Object>> mergedSummaryFields = new ArrayList<>();
            mergedSummaryFields.addAll(transformedTenantSummaryFields);
            // 非摘要字段，历史资讯或者其他字段
            mergedSummaryFields.addAll(summaryFields.stream().filter(map -> !MapUtils.getBoolean(map, "summary", true)).collect(Collectors.toList()));
            return mergedSummaryFields;
        }
    }

    /**
     * 过滤摘要字段
     * @param activity 任务定义
     */
    private void filterSummaryFields(Activity activity) throws DWBusinessException {
        if (!CollectionUtils.isEmpty(activity.getSummaryFields()) && !activity.getUsedTenantSummaryFields()) {
            // 只有应用级摘要字段需要按照“默认展示”标识过滤
            // 历史数据默认为true
            activity.getSummaryFields().removeIf(map -> !MapUtils.getBoolean(map, "defaultEffective", true) && MapUtils.getBoolean(map, "summary", true));
            Map<String, Object> pages = activity.getPages();
            if (null != pages.get("dataStates") && !CollectionUtils.isEmpty((List) pages.get("dataStates"))) {
                List<Map<String, Object>> dataStates = (List<Map<String, Object>>) pages.get("dataStates");
                Map<String, Object> dataState = dataStates.get(0);
                dataState.put("summaryFields", activity.getSummaryFields());
            } else {
                pages.put("summaryFields", activity.getSummaryFields());
            }
        }
        if (!CollectionUtils.isEmpty(activity.getCanSelectedSummaryFields())) {
            // 过滤掉不是摘要字段的，历史数据默认为true
            activity.getCanSelectedSummaryFields().removeIf(map -> !MapUtils.getBoolean(map, "summary", true));
        }
        // 如果之前设置过的租户级摘要字段不在本次可选择的字段中，为了兼容历史数据，需要将租户级字段添加到可选择的字段中
        if (!CollectionUtils.isEmpty(activity.getCanSelectedSummaryFields())) {
            List<Map<String, Object>> canSelectedSummaryFields = activity.getCanSelectedSummaryFields();
            List<Map<String, Object>> tenantSummaryFieldList = activity.getSummaryFields();
            String locale = Optional.ofNullable(AthenaUtils.getCurrentLocale()).orElse("zh_CN");
            String actionId = MapUtils.getString(activity.getCanSelectedSummaryFields().get(0), "actionId");
            List<ApiDataFieldLocaleMetadataDTO> fields = null;
            if (StringUtils.isNotEmpty(actionId)) {
                try {
                    GetActionLocaleResponseDTO actionLocaleResponseDTO = (GetActionLocaleResponseDTO) dataMapActionService.getMetadata(actionId);
                    ApiDataFieldLocaleMetadataDTO data = actionLocaleResponseDTO.getResponse().getData();
                    fields = data.getField();
                } catch (Exception e) {
                    throw new DWBusinessException("查询元数据定义出错，actionId：{}", actionId);
                }
            }
            activity.getCanSelectedSummaryFields().forEach(field -> {
                if (StringUtils.isEmpty(MapUtils.getString(field, "description"))) {
                    Object title = JSONPath.eval(field, "$.tags[0].title");
                    Object localeTitle = JSONPath.eval(field, "$.tags[0].lang.title." + locale);
                    field.put("description", localeTitle != null ? localeTitle : title);
                }
                if (StringUtils.isEmpty(MapUtils.getString(field, "data_name"))) {
                    String value = MapUtils.getString(field, "value", "");
                    field.put("data_name", value.contains(".") ? value.split("\\.")[1] : "");
                }
                if (StringUtils.isEmpty(MapUtils.getString(field, "data_type"))) {
                    field.put("data_type", "string");
                }
            });
            for (Map<String, Object> tenantSummaryField : tenantSummaryFieldList) {
                //租户级数据不在可选范围中，则将租户级数据加入到可选摘要字段中，主要是为了兼容历史数据
                boolean b = canSelectedSummaryFields.stream().noneMatch(map -> MapUtils.getString(map, "value", "").equals(MapUtils.getString(tenantSummaryField, "value", "")));
                if (b && MapUtils.getBoolean(tenantSummaryField, "summary", true)) {
                    if (null != fields && !fields.isEmpty()) {
                        Optional<ApiDataFieldLocaleMetadataDTO> dataName = fields.stream().filter(f -> f.getData_name().equals(MapUtils.getString(tenantSummaryField, "data_name", ""))).findFirst();
                        //如果
                        dataName.ifPresent(apiDataFieldLocaleMetadataDTO -> tenantSummaryField.put("description", apiDataFieldLocaleMetadataDTO.getDescription()));
                    }
                    canSelectedSummaryFields.add(tenantSummaryField);
                }
            }
        }
    }



    private void setGroupInfo( List<ActivityDataEntryVO> activitiesByPattern) throws DWBusinessException {
        if(CollectionUtils.isEmpty(activitiesByPattern)){return ;}
        Set<String> groupCodes = new HashSet<>();
        Set<String> activityCodes = new HashSet<>();
        for(ActivityDataEntryVO vo :activitiesByPattern){
            if(null!=vo.getGroupCode()){
                groupCodes.add(vo.getGroupCode());
            }
            activityCodes.add(vo.getCode());
        }
        List<ApplicationGroup> applicationGroupsByActivityCode= dataPickService.find(Criteria.where("activityCode").in(activityCodes),ApplicationGroup.class,"applicationGroup");
        List<ApplicationGroup> applicationGroupsByGroupCode= new ArrayList<>();
        if(!groupCodes.isEmpty()){
            applicationGroupsByGroupCode= dataPickService.find(Criteria.where("groupCode").in(groupCodes),ApplicationGroup.class,"applicationGroup");
        }
        Map<String,ApplicationGroup> activityCode2Groups = new HashMap<>();
        Map<String,ApplicationGroup> groupCode2Groups = new HashMap<>();

        for(ApplicationGroup group:applicationGroupsByActivityCode){
            activityCode2Groups.put(group.getActivityCode(),group);
        }
        for(ApplicationGroup group:applicationGroupsByGroupCode){
            groupCode2Groups.put(group.getGroupCode(),group);
        }
        for(ActivityDataEntryVO vo :activitiesByPattern){
            ApplicationGroup group = null;
            if(null!=vo.getGroupCode()){
                group = groupCode2Groups.get(vo.getGroupCode());
            }
            if(null==group){
                group= activityCode2Groups.get(vo.getCode());
            }
            if(null==group){continue;}
            vo.setGroupCode(group.getGroupCode());
            vo.setGroupName(group.getGroupName());
            vo.setGroupSort(group.getGroupSort());
            if(null==vo.getLang()){vo.setLang(new HashMap<>());}
            if(null!=group.getLang() && null!= group.getLang().get("groupName")){
                vo.getLang().put("groupName",group.getLang().get("groupName"));
            }
        }

    }


    private void setUserPermissionInfo(List<ActivityDataEntryVO> activitiesByPattern,String effect) throws DWBusinessException {
        if(CollectionUtils.isEmpty(activitiesByPattern)){return;}
        Set<String> appCodes = new HashSet<>();
        for(ActivityDataEntryVO vo : activitiesByPattern){
            if(null!=vo.getAuthorityPrefix()){
                try {
                    String appCode = vo.getAuthorityPrefix().split(":")[0];
                    if(StringUtils.isNotEmpty(appCode)){
                        appCodes.add(appCode);
                    }
                }catch (Exception e){e.printStackTrace();}
            }
        }
        Map<String,String> userPermissions = kmService.userPermission(appCodes,effect);
        Iterator<ActivityDataEntryVO> iterator2 = activitiesByPattern.iterator();
        while (iterator2.hasNext()) {
            ActivityDataEntryVO project = iterator2.next();
            project.setEffect("allow");
            if(StringUtils.isNotEmpty(project.getAuthorityPrefix()) && !userPermissions.containsKey(project.getCode())){
                iterator2.remove();
                continue;
            }
            if(Boolean.TRUE.equals(project.getCommonApp()) && StringUtils.isEmpty(project.getAuthorityPrefix())){
                iterator2.remove();
                continue;
            }
            String eff = userPermissions.get(project.getCode());
            if(StringUtils.isNotEmpty(eff)){
                project.setEffect(eff);
            }
            //todo 临时
            if(null!=effect && !effect.equals(project.getEffect())){
                iterator2.remove();
            }

        }
    }

}
