package com.digiwin.athena.datamap.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.datamap.service.IRuleService;
import com.digiwin.athena.kg.ComponentConstants;
import com.digiwin.athena.kg.dto.ApplicationRelationQueryDTO;
import com.digiwin.athena.kmservice.cache.old.Cache;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.preset.AppDiff;
import com.digiwin.athena.preset.PresetDomainEnum;
import com.digiwin.athena.preset.PresetFeatureEnum;
import com.digiwin.athena.preset.Rule;
import com.digiwin.athena.preset.dto.PresetDTO;
import com.digiwin.athena.preset.dto.RuleDTO;
import io.seata.common.util.CollectionUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

@Lang
@Slf4j
@Service
@MyExceptionHandler
public class RuleService implements IRuleService {
    protected static final String RULE_COLNAME = "rules";
    protected static final String TENANT_RULE_COLNAME = "tenantRules";

    @Autowired
    DatamapAppService datamapAppService;

    @Autowired
    @Qualifier("presetMongoTemplate")
    MongoTemplate mongoTemplate;

    @Autowired
    GenericService genericService;

    @Autowired
    PresetService presetService;

    @Autowired
    DataMapTenantService dataMapTenantService;

    @Autowired
    PresetCollectionService presetCollectionService;

    //这种数据肯定不会多
    public List disabledDomainIds(String domain,String activityId) throws Exception {
        List ids = new ArrayList<>();
        List<String> apps = dataMapTenantService.getAppCodes();//Arrays.asList("Athena","PCC");
        ApplicationRelationQueryDTO queryDTO = ApplicationRelationQueryDTO.builder().type("activity").codes(Collections.singletonList(activityId)).build();
        List<ApplicationRelation> applicationRelations = datamapAppService.postApplicationByTypeAndCodeList(queryDTO);
        if(CollectionUtils.isEmpty(apps) || CollectionUtils.isEmpty(applicationRelations)){
            return ids;
        }
        List<String> apps2 = applicationRelations.stream().map(ApplicationRelation::getAppCode).collect(Collectors.toList());
        apps.retainAll(apps2);
        //System.out.println(apps);
        if(!apps.isEmpty()){
            Query query = Query.query(Criteria.where("application").in(apps).and("domain").is(domain).and("mode").is("remove"));
            List<AppDiff> appDiffs =  mongoTemplate.find(query, AppDiff.class);
            if(!appDiffs.isEmpty()){
                Map<Object,List> domainMap = new HashMap<>();
                for(AppDiff diff:appDiffs){
                    List appCodes = domainMap.get(diff.getDomainId());
                    if(null==appCodes){
                        appCodes = new ArrayList<>();
                        domainMap.put(diff.getDomainId(),appCodes);
                    }
                    appCodes.add(diff.getApplication());
                }
                List domainIds = new ArrayList<>();
                domainMap.forEach((k,v)->{
                    if(v.containsAll(apps)){
                        domainIds.add(k);
                    }
                });

                return domainIds;

            }


        }

        return ids;
    }


    @Override
    @Cache(namespace = ComponentConstants.REDIS_KNOWLEDGE_GRAPH_PRESET, key = "postQuery2$0$1", language = true,
            tenant = true, ttlSecs = 86400L)
    public Object postQuery(String activityId, int count) throws Exception {
        return postCommonQuery(activityId, count, new HashMap<>());
    }

    @Override
    @Cache(namespace = ComponentConstants.REDIS_KNOWLEDGE_GRAPH_PRESET, key = "postQuery3$0$1$2", language = true,
            tenant = true, ttlSecs = 86400L)
    public Object postQuery(String activityId, int count, Map<PresetFeatureEnum, Object> features) throws Exception {
        return postCommonQuery(activityId, count, features);
    }


    public Object postCommonQuery(String activityId, int count, Map<PresetFeatureEnum, Object> features) throws Exception {
        if (StringUtils.isEmpty(activityId)) {
            throw new DWArgumentException("activityId", I18nUtils.getValue("preset.activityIdEmpty"));
        }
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = dataMapTenantService.getTenantVersion(tenantId);
        Map<String, Object> con = new HashMap<>();
        con.put("domain", PresetDomainEnum.ACTIVITY.toString());
        if (activityId.contains("-")) {//动态任务获取-前面的动态任务模板code
            activityId = activityId.substring(0, activityId.indexOf("-"));
        }
        con.put("domainId", activityId);
        con.put("version", tenantVersion);
        ApplicationRelation applicationRelation = datamapAppService.getApplicationByTypeAndCode("activity", activityId);
        if (applicationRelation != null && tenantId.equals(applicationRelation.getTenantId())) {
            // 个案应用，只查询对应租户数据
            con.put("tenantId", Collections.singletonList(tenantId));
        } else {
            con.put("tenantId", Arrays.asList("SYSTEM",null));
        }
        Map<String, Object>[] re = (Map<String, Object>[]) presetCollectionService.getList(RULE_COLNAME, con, count, "key", "version");
        re =filterIndividual(re);
        //20220505 add by maxl for 组装客户级应用poc，增加租户级别的规则，目前先用复制方式实现，复制代表是个案级别，后续还需要实现基于组件清单不同租户可以引用不同的标准规则

        Map<String, Object> tenantCondition = new HashMap<>();
        tenantCondition.put("domain", PresetDomainEnum.ACTIVITY.toString());
        tenantCondition.put("domainId", activityId);
        tenantCondition.put("version", tenantVersion);
        tenantCondition.put("tenantId", tenantId);
        Map<String, Object>[] tenantLevelResult = (Map<String, Object>[]) presetCollectionService.getList(TENANT_RULE_COLNAME, tenantCondition, count, "key", "version");

       // List keys = disabledDomainIds("rule",activityId);
        List<Map<String, Object>> rules = new ArrayList<>();
        List<Map<String, Object>> systemRules = new ArrayList<>();
        List<Map<String, Object>> tenantRules = new ArrayList<>();
        ArrayList<String> duplicateRemovalKey = new ArrayList<>();
        if (tenantLevelResult.length > 0) {
            for (Map<String, Object> r : tenantLevelResult) {
             //   if(keys.contains(r.get("key"))){continue;}
                Map<String, Object> tmp = new HashMap<>();
                tmp.put("key", r.get("key"));
                tmp.put("name", r.get("name"));
                tmp.put("pluginId", r.get("pluginId"));
                Map obj = (Map)r.get("content");
                duplicateRemovalKey.add(obj.get("key") + "-" + obj.get("schema"));
                tmp.put("content", obj);
                supplementResult(features, r, tmp);
                //暂时不考虑重复的情况
                tenantRules.add(tmp);
            }
        }
        if (re.length > 0) {
            for (Map<String, Object> r : re) {
           //     if(keys.contains(r.get("key"))){continue;}
                Map obj = (Map)r.get("content");
                if ("required".equalsIgnoreCase((String.valueOf(obj.get("key")))) && duplicateRemovalKey.contains(obj.get("key") + "-" + obj.get("schema"))) {
                    continue;
                }
                Map<String, Object> tmp = new HashMap<>();
                tmp.put("key", r.get("key"));
                tmp.put("name", r.get("name"));
                tmp.put("pluginId", r.get("pluginId"));
                tmp.put("content", obj);
                supplementResult(features, r, tmp);
                systemRules.add(tmp);
            }
        }
        rules.addAll(systemRules);
        rules.addAll(tenantRules);
        rules.sort((r1, r2) -> {
            int intR2 = ObjectUtils.isEmpty(r2.get("sequence")) ? 0 :  Integer.parseInt(r2.get("sequence").toString());
            int intR1 = ObjectUtils.isEmpty(r1.get("sequence")) ? 0 :  Integer.parseInt(r1.get("sequence").toString());
            return intR1 - intR2;
        });
        Map<String, List> result = new HashMap<>();
        result.put(RULE_COLNAME, rules);
        return result;
    }


     private Map<String, Object>[] filterIndividual(Map<String, Object>[] re) throws IOException, DWBusinessException {
        boolean suspended = false;
        for(Map<String, Object> rule:re){
            Integer sourceLevel = (Integer) rule.get("sourceLevel");
            if(null==sourceLevel){
                rule.put("sourceLevel",1000);
            }else if (sourceLevel<1000){
                suspended =true;
            }
        }
        Arrays.sort(re, (o1, o2) -> {
            Integer sl1 = (Integer) o1.get("sourceLevel");
            Integer sl2 = (Integer) o2.get("sourceLevel");
            return sl1- sl2;
        });
        ArrayList<Map<String, Object>> list = new ArrayList<>();
        Set<String> keys = new HashSet<>();
        for(Map<String, Object> rule : re){
            String key = (String) rule.get("key");
            Integer sourceLevel = (Integer) rule.get("sourceLevel");
            if(keys.contains(key)){continue;}
            if(suspended && sourceLevel==1000){continue;}
            list.add(rule);
            keys.add(key);
        }

        return list.toArray(new Map[0]);
    }

    private void supplementResult(Map<PresetFeatureEnum, Object> features, Map<String, Object> r, Map<String, Object> tmp) throws Exception {
        for (Map.Entry<PresetFeatureEnum, Object> entry : features.entrySet()) {
            PresetFeatureEnum key = entry.getKey();
            if (key == null) {
                //未约定的类型
                throw new DWException("P.PL.500.0005", "notAgreed key in features");
            }
            switch (key) {
                case include:
                    List<String> value = (List)entry.getValue();
                    for (String s : value) {
                        Object o = r.get(s);
                        tmp.put(s, o);
                    }
                    break;
                default:
                    throw new DWException("P.PL.500.0005", "Unexpected value: " + key);
            }
        }
    }

    @Override
    public Object put(RuleDTO rule) throws Exception {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = dataMapTenantService.getTenantVersion(tenantId);
        String key = rule.getKey();
        if (StringUtils.isEmpty(key)) {
            throw new DWArgumentException("key", I18nUtils.getValue("preset.keyEmpty"));
        }
        String activityId = rule.getActivityId();
        if (StringUtils.isEmpty(activityId)) {
            throw new DWArgumentException("activityId", I18nUtils.getValue("preset.activityIdEmpty"));
        }

        PresetDTO preset = new PresetDTO();
        preset.setKey(key);
        preset.setDomain(PresetDomainEnum.ACTIVITY);
        preset.setDomainId(activityId);
        preset.setContent(rule.getContent());
        preset.setVersion(tenantVersion);
        preset.setName(rule.getName());

        presetService.put(RULE_COLNAME, preset);

        return null;
    }

    @Override
    public Object postSave(Rule rule) throws Exception {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = dataMapTenantService.getTenantVersion(tenantId);
        rule.setTenantId(tenantId);
        rule.setVersion(tenantVersion);
        mongoTemplate.save(rule,TENANT_RULE_COLNAME);
        genericService.delMatch(ComponentConstants.REDIS_KNOWLEDGE_GRAPH_PRESET + ":SYSTEM:" + tenantId + "*");
        return rule;
    }

    @Override
    public Object postBatchSave(List<Rule> rules) throws Exception {
        log.info("批量保存规则，rules：{}", JSON.toJSONString(rules));
        // 保存系统级规则
        mongoTemplate.insert(rules, RULE_COLNAME);
        genericService.delMatch(ComponentConstants.REDIS_KNOWLEDGE_GRAPH_PRESET  + "*");
        return null;
    }

    @Override
    public Object postRemoveByPluginId(Rule rule) throws Exception {
        if(null!=rule.getPluginId()){
            String tenantId = ServiceUtils.getTenantId();
            Query query = Query.query(Criteria.where("pluginId").is(rule.getPluginId()).and("tenantId").is(tenantId));
            mongoTemplate.remove(query,TENANT_RULE_COLNAME);
            genericService.delMatch(ComponentConstants.REDIS_KNOWLEDGE_GRAPH_PRESET + ":SYSTEM:" + tenantId + "*");
        }
        return null;
    }

    @Override
    public Object delete(String key) throws Exception {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = dataMapTenantService.getTenantVersion(tenantId);
        if (StringUtils.isEmpty(key)) {
            throw new DWArgumentException("key", I18nUtils.getValue("preset.keyEmpty"));
        }

        presetService.delete(RULE_COLNAME, key, tenantVersion);

        return null;
    }

    /**
     * 批量保存租户规则
     * @param rules
     * @return
     * @throws Exception
     */
    @Override
    public Object postBatchSaveTanentRule(List<Rule> rules) throws Exception {
        log.info("批量保存规则，Tanent rules：{}", JSON.toJSONString(rules));
        // 保存系统级规则
        mongoTemplate.insert(rules, TENANT_RULE_COLNAME);
        genericService.delMatch(ComponentConstants.REDIS_KNOWLEDGE_GRAPH_PRESET  + "*");
        return null;
    }

    /**
     * 删除租户规则（此方法供删除ABI报表生成的隐藏查询条件规则使用）
     * @param pluginId
     * @return
     * @throws Exception
     */
    @Override
    public Object postRomeveTanentRule(String pluginId) throws Exception {
        String tenantId = ServiceUtils.getTenantId();
        String tenantVersion = dataMapTenantService.getTenantVersion(tenantId);
        if (StringUtils.isEmpty(pluginId)) {
            throw new DWArgumentException("pluginId", I18nUtils.getValue("preset.pluginIdEmpty"));
        }
        presetService.deleteTanentRule(TENANT_RULE_COLNAME, pluginId, tenantVersion);

        return null;
    }

}