package com.digiwin.athena.datamap.service.inner;

import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.core.DataDescription;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.kmservice.neo4j.Neo4j1Config;
import com.digiwin.athena.kmservice.neo4j.Neo4j2Config;
import lombok.extern.slf4j.Slf4j;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @program: athena2_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2022-03-10 13:30
 **/
@Service
@Slf4j
public class DataMapHelpService {


    @Autowired(required = false)
    @Qualifier(Neo4j1Config.SESSION_FACTORY)
    SessionFactory sessionFactory1;

    @Autowired(required = false)
    @Qualifier(Neo4j2Config.SESSION_FACTORY)
    SessionFactory sessionFactory2;

    public static Map<String, Class<? extends BaseEntity>> entityMap = new HashMap();
    {
        entityMap.put("data", DataDescription.class);
        entityMap.put("project", Project.class);
        entityMap.put("task", Task.class);
        entityMap.put("activity", Activity.class);
        entityMap.put("flow", FlowGraph.class);

    }

    public void executeCypher(String cyhper, Map<String, Object> param) {
        if (null != sessionFactory1) {
            Session session1 = sessionFactory1.openSession();
            session1.query(cyhper, param);
        }
        if (null != sessionFactory2) {
            Session session2 = sessionFactory2.openSession();
            session2.query(cyhper, param);
        }
    }

}
