package com.digiwin.athena.datamap.service.inner;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.service.IPluginService;
import com.digiwin.athena.domain.common.Constants;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.core.*;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.plugin.PluginBinding;
import com.digiwin.athena.domain.plugin.PluginBindingPo;
import com.digiwin.athena.dto.BindingResult;
import com.digiwin.athena.dto.TaskPathVo;
import com.digiwin.athena.mechanism.achivebo.MechanismDecision;
import com.digiwin.athena.mechanism.achivebo.MechanismDecisionTarget;
import com.digiwin.athena.mechanism.plugins.PluginRecord;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-05-31 16:04
 **/
@Slf4j
@Service
public class PluginService implements IPluginService {

    @Autowired
    @Qualifier("dataMapSystem")
    protected MongoTemplate mongoTemplate;;
    @Autowired(required = false)
    @Qualifier("mongoTemplateTenant")
    MongoTemplate mongoTemplateTenant;

    @Autowired
    DataMapPickService dataMapPickService;

    @Override
    public BindingResult postMergePlugin(PluginBindingPo binding) throws DWException {

        BindingResult br = new BindingResult();
        if (null == binding.getPluginIds() || null == binding.getTenantId()) {
            br.setSuccess(false);
            br.setMsg("tenantId or pluginIds is null");
            return br;
        }

        Query query = Query.query(Criteria.where("tenantId").is(binding.getTenantId()).and("pluginId").in(binding.getPluginIds()));
        List<PluginBinding> bindings = mongoTemplateTenant.find(query, PluginBinding.class);
        List<String> bindedIds = bindings.stream().map(pb -> pb.getPluginId()).collect(Collectors.toList());
        if (!Boolean.TRUE.equals(binding.getForce())) {
            binding.getPluginIds().removeAll(bindedIds);
        }
        if (0 == binding.getPluginIds().size()) {
            br.setSuccess(false);
            br.setMsg("没有可用的pluginIds，为空或者已绑定");
            return br;
        }

        System.out.println("开始应用插件:" + binding.getPluginIds() + " 到租户:" + binding.getTenantId());

        // 清除上次记录
        postRemovePlugin(binding);

        List<String> pluginId = binding.getPluginIds();
        String tenantId = binding.getTenantId();

        // DataDescription
        List<DataDescription> dataDescs = findPluginConfig(pluginId, DataDescription.class, null);
        if (!dataDescs.isEmpty()) {
            dataDescs.forEach(e -> {
                e.setId(null);
                e.setTenantId(tenantId);
            });
            mongoTemplateTenant.insert(dataDescs, dataMapPickService.tenantCol(DataDescription.class));
        }
        // DataState
        List<DataState> dataStates = findPluginConfig(pluginId, DataState.class, null);
        if (!dataStates.isEmpty()) {
            dataStates.forEach(e -> {
                e.setId(null);
                e.setTenantId(tenantId);
                br.setChangeMap(true);
            });
            mongoTemplateTenant.insert(dataStates, dataMapPickService.tenantCol(DataState.class));
        }

        // task
        List<Task> tasks = findPluginConfig(pluginId, Task.class, null);
        if (!tasks.isEmpty()) {
            tasks.forEach(e -> {
                e.setId(null);
                e.setTenantId(tenantId);
                br.setChangeMap(true);
            });
            mongoTemplateTenant.insert(tasks, dataMapPickService.tenantCol(Task.class));
        }

        // flow
        List<FlowGraph> flows = findPluginConfig(pluginId, FlowGraph.class, null);
        if (!flows.isEmpty()) {
            flows.forEach(e -> {
                e.setId(null);
                e.setTenantId(tenantId);
            });
            mongoTemplateTenant.insert(flows, dataMapPickService.tenantCol(FlowGraph.class));
        }

        // activity
        List<Activity> activities = findPluginConfig(pluginId, Activity.class, null);
        if (!activities.isEmpty()) {
            activities.forEach(e -> {
                e.setId(null);
                e.setTenantId(tenantId);
            });
            mongoTemplateTenant.insert(activities, dataMapPickService.tenantCol(Activity.class));
            // todo 处理活动中产品问题
        }
        // project
        List<Project> projects = findPluginConfig(pluginId, Project.class, null);
        if (!projects.isEmpty()) {
            projects.forEach(e -> {
                e.setId(null);
                e.setTenantId(tenantId);
            });
            mongoTemplateTenant.insert(projects, dataMapPickService.tenantCol(Project.class));
        }

        List<Class> classes = getTenantMechanismClasses();
        for (Class c : classes) {
            List<TenantObject> objects = findPluginConfig(pluginId, c, null);
            if (!objects.isEmpty()) {
                objects.forEach(e -> {
                    e.setId(null);
                    e.setTenantId(tenantId);
                });
                mongoTemplateTenant.insert(objects, dataMapPickService.tenantCol(c));
            }
        }

        binding.getPluginIds().forEach(pid -> {
            if (!bindedIds.contains(pid)) {
                PluginBinding pluginBinding = new PluginBinding();
                pluginBinding.setPluginId(pid);
                pluginBinding.setTenantId(binding.getTenantId());
                mongoTemplateTenant.save(pluginBinding);
            }
        });

        br.setSuccess(true);
        return br;
    }

    @Override
    public List<TaskPathVo> postRemovePlugin(PluginBindingPo binding) throws DWException {
        if (CollectionUtils.isEmpty(binding.getPluginIds())) {
            return null;
        }

        Query queryDelete = Query.query(Criteria.where("tenantId").is(binding.getTenantId()).and("pluginId").in(binding.getPluginIds()));
        mongoTemplateTenant.remove(queryDelete, DataDescription.class, dataMapPickService.tenantCol(DataDescription.class));
        mongoTemplateTenant.remove(queryDelete, DataState.class, dataMapPickService.tenantCol(DataState.class));
        mongoTemplateTenant.remove(queryDelete, Task.class, dataMapPickService.tenantCol(Task.class));
        mongoTemplateTenant.remove(queryDelete, FlowGraph.class, dataMapPickService.tenantCol(FlowGraph.class));
        mongoTemplateTenant.remove(queryDelete, Activity.class, dataMapPickService.tenantCol(Activity.class));
        mongoTemplateTenant.remove(queryDelete, Project.class, dataMapPickService.tenantCol(Project.class));
        mongoTemplateTenant.remove(queryDelete, PageView.class, dataMapPickService.tenantCol(PageView.class));
        // 增量修改
        mongoTemplateTenant.remove(queryDelete, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
        mongoTemplateTenant.remove(queryDelete, DataMapPickService.tableTenantObjectAdaptation(Project.class));
        mongoTemplateTenant.remove(queryDelete, DataMapPickService.tableTenantObjectAdaptation(Task.class));
        mongoTemplateTenant.remove(queryDelete, DataMapPickService.tableTenantObjectAdaptation(Activity.class));

        List<Class> classes = getTenantMechanismClasses();
        for (Class c : classes) {
            mongoTemplateTenant.remove(queryDelete, c, dataMapPickService.tenantCol(c));
        }

        try {
            postRemovePluginSystem(binding);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    // todo 当前存在datamap和datamapTenant都有机制数据的情况，清空时需要把老的机制数据也删掉
    public List<TaskPathVo> postRemovePluginSystem(PluginBindingPo binding) throws DWException {
        if (CollectionUtils.isEmpty(binding.getPluginIds())) {
            return null;
        }

        Query queryDelete = Query.query(Criteria.where("tenantId").is(binding.getTenantId()).and("pluginId").in(binding.getPluginIds()));
        mongoTemplate.remove(queryDelete, DataDescription.class, dataMapPickService.tenantCol(DataDescription.class));
        mongoTemplate.remove(queryDelete, DataState.class, dataMapPickService.tenantCol(DataState.class));
        mongoTemplate.remove(queryDelete, Task.class, dataMapPickService.tenantCol(Task.class));
        mongoTemplate.remove(queryDelete, FlowGraph.class, dataMapPickService.tenantCol(FlowGraph.class));
        mongoTemplate.remove(queryDelete, Activity.class, dataMapPickService.tenantCol(Activity.class));
        mongoTemplate.remove(queryDelete, Project.class, dataMapPickService.tenantCol(Project.class));
        mongoTemplate.remove(queryDelete, PageView.class, dataMapPickService.tenantCol(PageView.class));
        // 增量修改
        mongoTemplate.remove(queryDelete, DataMapPickService.tableTenantObjectAdaptation(PageView.class));
        mongoTemplate.remove(queryDelete, DataMapPickService.tableTenantObjectAdaptation(Project.class));
        mongoTemplate.remove(queryDelete, DataMapPickService.tableTenantObjectAdaptation(Task.class));
        mongoTemplate.remove(queryDelete, DataMapPickService.tableTenantObjectAdaptation(Activity.class));

        List<Class> classes = getTenantMechanismClasses();
        for (Class c : classes) {
            mongoTemplate.remove(queryDelete, c, dataMapPickService.tenantCol(c));
        }
        return null;
    }

    public <T extends TenantObject> List<T> findPluginConfig(List<String> pluginId, Class<T> c, String col) throws DWBusinessException {
        List<T> r = null;
        if (col != null) {
            r = mongoTemplate.find(Query.query(Criteria.where("tenantId").is(Constants.mechanismTenantId).and("pluginId").in(pluginId)), c, col);
        } else {
            r = mongoTemplate.find(Query.query(Criteria.where("tenantId").is(Constants.mechanismTenantId).and("pluginId").in(pluginId)), c);
        }

        return r;
    }

    public void removeTenantPlugin(PluginBindingPo binding, String table) {
        Query queryDelete = Query.query(Criteria.where("tenantId").is(binding.getTenantId()).and("pluginId").in(binding.getPluginIds()));
        mongoTemplateTenant.remove(queryDelete, table);
    }

    public static List<Class> getTenantMechanismClasses() {
        List<Class> classes = new ArrayList<>();
        classes.add(MechanismDecision.class);
        classes.add(MechanismDecisionTarget.class);
        classes.add(PageView.class);
        classes.add(PluginRecord.class);

        return classes;
    }

}
