package com.digiwin.athena.datamap.spi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.datamap.povo.middleware.UserPermission;
import com.digiwin.athena.datamap.supports.TenantApplication;
import com.digiwin.athena.datamap.utils.DataMapUtils;
import com.digiwin.athena.kg.authority.AuthorizedUserResult;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.http.client.utils.DWRequestHeaderUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.*;

@Service
@Slf4j
public class DataMapIamService {
    private final String TENANT_APPLICATION = "/api/iam/v2/user/tenant/application";
    private final String APP_ITEMS = "/api/iam/v2/app/action/ids";
    private final String SEND_MESSAGE = "/api/aim/v2/batch/user/message";
    private final String TENANT_ALL_APPLICATION = "/api/iam/v2/tenant/application";
    private final String LOGIN = "/api/iam/v2/identity/login/internal";
    private final String APP_INFO = "/api/iam/v2/app";
    private final String USER = "/api/iam/v2/user/simple";
    private final String POLICY_ACTION = "/api/iam/v2/policy/action";
    private final String USER_PERMISSION2 = "/api/iam/v2/permission/user";
    private final String USER_PERMISSION2_ALL = "/api/iam/v2/permission/users/apps/all";
    private final String USER_ROLE = "/api/iam/v2/user/role";

    @Autowired
    RestTemplate restTemplate;

    @Value("${iamUrl}")
    private String iamUrl;

    @Value("${iamApToken}")
    private String iamApToken;


    @Value("${integrationInternalPasswordHash:6826CC688C4AF1BD0A8DDA2DBDF8897B}")
    private String integrationInternalPasswordHash;

    public String getAthenaLicenceKey() {
        return this.getLicenceKey("Athena");
    }

    public String getAthenaLicenceKey(String tenantId) throws Exception{
        return this.getLicenceKey("Athena", tenantId);
    }

    private String getLicenceKey(String application) {
        List<TenantApplication> tenantApplications = this.listApplications();
        Optional<TenantApplication> any = tenantApplications.stream().filter(e -> StringUtils.equals(e.getId(), application)).findAny();
        if (any.isPresent()) {
            return any.get().getSecretKey();
        }
        return null;
    }

    private String getLicenceKey(String application, String tenantId) throws Exception{
        Object login = login(tenantId);
        JSONObject loginJsonObject = JSON.parseObject(JSON.toJSONString(login));
        String token = null;
        if(StringUtils.equals(tenantId, loginJsonObject.getString("tenantId"))){
            token = loginJsonObject.getString("token");
        }
        List<TenantApplication> tenantApplications = this.listApplications(token);
        Optional<TenantApplication> any = tenantApplications.stream().filter(e -> StringUtils.equals(e.getId(), application)).findAny();
        if(any.isPresent()){
            return any.get().getSecretKey();
        }
        log.info("getLicenceKey not found application:{} of tenantId:{}", application, tenantId);
        return null;
    }

    private List<TenantApplication> listApplications(String token){
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(iamUrl + TENANT_APPLICATION, HttpMethod.GET, requestEntity, Object.class);
        Object body = resEntity.getBody();
        List<TenantApplication> tenantApplications = JSONObject.parseArray(JSON.toJSONString(body), TenantApplication.class);
        return tenantApplications;
    }


    private List<TenantApplication> listApplications() {
        String token = DWServiceContext.getContext().getToken();
        HttpHeaders headers = new HttpHeaders();
        headers.add(DWRequestHeaderUtils.HEADER_IAM_API_USER_TOKEN, token);
        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(iamUrl + TENANT_APPLICATION, HttpMethod.GET, requestEntity, Object.class);
        Object body = resEntity.getBody();
        List<TenantApplication> tenantApplications = JSONObject.parseArray(JSON.toJSONString(body), TenantApplication.class);
        return tenantApplications;
    }

    public List<String> appItems(List<String> appIds) {
        String token = DWServiceContext.getContext().getToken();
        HttpHeaders headers = new HttpHeaders();
        DataMapUtils.requiredHeaders(headers);
        headers.add("digi-middleware-auth-app", iamApToken);

        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("appIds", appIds);

        HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);
        ResponseEntity<Map> resEntity = restTemplate.exchange(iamUrl + APP_ITEMS, HttpMethod.POST, requestEntity, Map.class);
        Map body = resEntity.getBody();
        log.info("appItems response:{}", body);

        return (List<String>) body.get("data");
    }

    /**
     * 固定获取test区的继集成账号token
     * @param tenantId  租户id
     * @return token
     */
    public String getTestIntegrationToken(String tenantId) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-app", iamApToken);
        Map<String, String> requestBody = new HashMap<>();
        requestBody.put("tenantId", tenantId);
        requestBody.put("userId", "integration");
        requestBody.put("passwordHash", integrationInternalPasswordHash);
        requestBody.put("identityType", "token");
        String url = iamUrl + "/api/iam/v2/identity/login/internal";
        HttpEntity<Map> requestEntity = new HttpEntity<>(requestBody, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, Object.class);
        JSONObject body = JSON.parseObject(JSON.toJSONString(resEntity.getBody()));
        return body.getString("token");
    }

    public Object login(String tenantId) throws Exception{
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");

        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("tenantId", tenantId);
        requestMap.put("userId", "integration");
        requestMap.put("passwordHash", integrationInternalPasswordHash);
        requestMap.put("identityType", "token");
        HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(iamUrl + LOGIN, HttpMethod.POST, requestEntity, Object.class);
        Object body = resEntity.getBody();
        return body;
    }

    public String getTenantToken(String tenantId, Object loginResponse) throws Exception{
        JSONObject loginJsonObject = JSON.parseObject(JSON.toJSONString(loginResponse));
        String token = null;
        if(StringUtils.equals(tenantId, loginJsonObject.getString("tenantId"))){
            token = loginJsonObject.getString("token");
        }
        return token;
    }
    public String getTenantToken(String tenantId) throws Exception{
        Object login = login(tenantId);
        JSONObject loginJsonObject = JSON.parseObject(JSON.toJSONString(login));
        String token = null;
        if(StringUtils.equals(tenantId, loginJsonObject.getString("tenantId"))){
            token = loginJsonObject.getString("token");
        }
        return token;
    }

    /**
     *
     * @return 0 个人， 1 企业， 2 个人开发商， 3 企业开发商
     * @throws Exception
     */
    public String getTenantType(String tenantId, Object loginResponse) throws Exception{
        JSONObject loginJsonObject = JSON.parseObject(JSON.toJSONString(loginResponse));
        String enterpriseTenantType = null;
        if(StringUtils.equals(tenantId, loginJsonObject.getString("tenantId"))){
            enterpriseTenantType = loginJsonObject.getString("enterpriseTenantType");
        }
        return enterpriseTenantType;
    }

    public Integer getTenantType(String token) throws IOException {
        String apiMetadataUrl = iamUrl + "/api/iam/v2/tenant/current";
        try {
            URL restURL = new URL(apiMetadataUrl);

            HttpURLConnection conn = (HttpURLConnection) restURL.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("digi-middleware-auth-user", token);
            conn.setRequestProperty("digi-middleware-auth-app", iamApToken);
            conn.setDoOutput(true);

            JSONObject response = JSON.parseObject(conn.getInputStream(), JSONObject.class);
            Integer type = response.getJSONObject("tenant").getInteger("enterpriseType");
            return type;
        } catch (Exception e) {
            log.error("http get tenant type error:{}",e.getMessage());
            throw e;
        }
    }

    /**
     * 启动企业运营
     * http://172.16.2.141:22694/html/web/controller/share/share.html#62d4f7b46fd0c83dff9c823d
     *
     * @return
     */
    public Object startEnterpriseOperation(String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", iamApToken);
        Map<String, Object> requestMap = new HashMap<>();
        HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(iamUrl + "/api/app/initialize", HttpMethod.POST, requestEntity, Object.class);
        Object body = resEntity.getBody();
        log.info("startEnterpriseOperation response:{}", body);
        return body;
    }

    public String getIntegrationToken(String tenantId, String appToken) {

        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", appToken);
        headers.add("digi-middleware-auth-app", iamApToken);

        Map<String, String> requestBody = new HashMap<>();
        requestBody.put("tenantId", tenantId);
        requestBody.put("userId", "integration");
        requestBody.put("passwordHash", integrationInternalPasswordHash);
        requestBody.put("identityType", "token");
        String url = iamUrl + "/api/iam/v2/identity/login/internal";
        HttpEntity<Map> requestEntity = new HttpEntity<>(requestBody, headers);
        try {
            ResponseEntity<Object> resEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity, Object.class);
            JSONObject body = JSON.parseObject(JSON.toJSONString(resEntity.getBody()));
            return body.getString("token");
        } catch (Exception e) {
            log.info("getUserToken by integration have exception：{}", e.getMessage());
        }
        return null;
    }



    public List<AuthorizedUserResult> getAuthorizedUser(String token, String appCode){
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.set("digi-middleware-auth-app", iamApToken);
        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(iamUrl + "/api/iam/v2/query/" + appCode+ "/authorized/user", HttpMethod.POST, requestEntity, Object.class);
        Object body = resEntity.getBody();
        List<AuthorizedUserResult> authorizedUserResultList = JSONObject.parseArray(JSON.toJSONString(body), AuthorizedUserResult.class);
        return authorizedUserResultList;
    }

    public Object getUserPermission(String appCode, String userId, String token){
        if(appCode == null || StringUtils.isEmpty(userId) || StringUtils.isEmpty(token)){
            throw new RuntimeException(I18nUtils.getValue("knowledgegraph.tokenOrUserMiss"));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", iamApToken);

        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("userId", userId);
        requestMap.put("sysId", appCode);

        HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);
        ResponseEntity<Object> resEntity = restTemplate.exchange(iamUrl + USER_PERMISSION2, HttpMethod.POST, requestEntity, Object.class);
        Object body = resEntity.getBody();
        return body;
    }

    public List<UserPermission> getUserPermission(Set<String> appCodes, String userId, String token,String effect){
        if(CollectionUtils.isEmpty(appCodes) || StringUtils.isEmpty(userId) || StringUtils.isEmpty(token)){
            throw new RuntimeException(I18nUtils.getValue("knowledgegraph.tokenOrUserMiss"));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", iamApToken);
        String securityToken = ServiceUtils.getSecurityToken();
        if(null!=securityToken){
            headers.add("security-token", iamApToken);
        }
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("userIds", Collections.singletonList(userId));
        requestMap.put("sysIds", appCodes);
        if(StringUtils.isNotEmpty(effect)){
            requestMap.put("effect", effect);
        }
        HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);
        ParameterizedTypeReference<List<UserPermission>> typeRef = new ParameterizedTypeReference<List<UserPermission>>() {};

        ResponseEntity<List<UserPermission>> resEntity = restTemplate.exchange(iamUrl + USER_PERMISSION2_ALL, HttpMethod.POST, requestEntity, typeRef);
        List<UserPermission> body = resEntity.getBody();
        return body;

    }

}
