package com.digiwin.athena.datamap.spi;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.povo.DapResponse;
import com.digiwin.athena.datamap.povo.GetActionLocaleResponseDTO;
import com.digiwin.athena.datamap.povo.monitorrule.MonitorRuleDTO;
import com.digiwin.athena.datamap.utils.DataMapUtils;
import com.digiwin.athena.kmservice.service.DataPickService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.assign.AdvancedUserDefinitionWidget;

@Service
@Slf4j
public class DataMapKgService {

    @Value("${tmHost}")
    private String tmHost;

    @Autowired
    private DataPickService dataPickService;

    public Object getParadigm(String code) {
        Map<String, Object> params = new HashMap<>();
        params.put("mechanismCode", code);
        DapResponse resp = DataMapUtils.request(tmHost + "/restful/service/knowledgegraph/paradigm/ParadigmConditionByMechanismCode", "get", params);
        return resp.getResponse();
    }

    public Object getVariableListSimple(List<String> code, Boolean needGetDefault) {
        Map<String, Object> req = new HashMap<>();
        req.put("variableIds", code);
        req.put("needGetDefault", needGetDefault);
        Map<String, Object> params = new HashMap<>();
        params.put("map", req);
        DapResponse resp = DataMapUtils.request(tmHost + "/restful/service/knowledgegraph/mechanism/variableListSimple", "post", params);
        return resp.getResponse();
    }

//    public Object appRelationUpdate(List<AppRelation2> list) {
//        Map<String, Object> req = new HashMap<>();
//        req.put("list", list);
//        Map<String, Object> params = new HashMap<>();
//        params.put("request", req);
//        DapResponse resp = Utils.request(tmHost + "/restful/service/knowledgegraph/app/appRelationUpdate", "post", params);
//        return resp.getResponse();
//    }

//    public List<AppRelation2> getApplicationRelationByTypeAndAppCode(String type, Object appCode) {
//        Map<String, Object> params = new HashMap<>();
//        params.put("type", type);
//        if (appCode instanceof String) {
//            params.put("appCode", appCode);
//        } else {
//            params.put("appCodes", appCode);
//        }
//
//        String resp = Utils.requestString(tmHost + "/restful/service/knowledgegraph/app/applicationRelationByTypeAndAppCode", "get", params);
//        DapResponse1 resp1 = JSON.parseObject(resp, DapResponse1.class);
//        return resp1.getResponse();
//    }

    /*
     * 项目 task 任务 activity
     */
    // @Cacheable(value = "datamap",key = "'SYSTEM:getCodeByTypeAndAppCode_'+#type+'_'+#appCode")
//    public List<String> getCodeByTypeAndAppCode(String type, Object appCode) {
//        List<String> list = new ArrayList<>();
//        if (null == type || null == appCode) {
//            return list;
//        }
//        List<AppRelation2> appRelation2s = getApplicationRelationByTypeAndAppCode(type, appCode);
//        if (null != appRelation2s) {
//            for (AppRelation2 appRelation2 : appRelation2s) {
//                if (null == appRelation2) {
//                    continue;
//                }
//                list.add(appRelation2.getCode());
//            }
//        }
//
//        return list;
//    }

//    public Object appRelationAddByDDSM(List<AppRelation2> list) {
//        Map<String, Object> req = new HashMap<>();
//        req.put("list", list);
//        Map<String, Object> params = new HashMap<>();
//        params.put("request", req);
//        DapResponse resp = Utils.request(tmHost + "/restful/service/knowledgegraph/app/ApplicationRelationByDDSM", "post", params);
//        return resp.getResponse();
//    }

    public List<ActivityWidget> generatePreActivities(AdvancedUserDefinitionWidget advancedUserDefinitionWidget, String capacityCode) {
        Map<String, Object> params = new HashMap<>();
        params.put("advancedUserDefinitionWidget", advancedUserDefinitionWidget);
        params.put("capacityCode", capacityCode);
        DapResponse resp = DataMapUtils.request(tmHost + "/restful/service/knowledgegraph/mechanism/generatePreActivities", "post", params);
        List<ActivityWidget> result = new ArrayList<>();
        if (resp.getResponse() instanceof JSONArray) {
            ((JSONArray) resp.getResponse()).forEach(item -> {
                result.add(dataPickService.convert(item, ActivityWidget.class));
            });
        }
        return result;
    }

    public Object getVariable(String variableName, String tenantId) {
        Map<String, Object> params = new HashMap<>();
        params.put("variableName", variableName);
        params.put("tenantId", tenantId);
        DapResponse response = DataMapUtils.request(tmHost + "/restful/service/knowledgegraph/mechanism/variable", "get", params);
        return response.getResponse();
    }

    public GetActionLocaleResponseDTO getActionMetaData(String actionId) {
        Map<String, Object> params = new HashMap<>();
        params.put("actionId", actionId);
        DapResponse response = DataMapUtils.request(tmHost + "/restful/service/knowledgegraph/action/metadata", "get", params);
        return JSONObject.parseObject(JSONObject.toJSONString(response.getResponse()), GetActionLocaleResponseDTO.class);
    }

    public MonitorRuleDTO queryMonitorRule(String ruleId, String tenantId) throws DWBusinessException {
        Map<String, Object> config = new HashMap<>();
        Map<String, Object> params = new HashMap<>();
        params.put("ruleId", ruleId);
        params.put("tenantId", tenantId);
        config.put("config", params);
        DapResponse resp = DataMapUtils.request(tmHost + "/restful/service/knowledgegraph/monitorRule/query", "post", config);
        if (resp.getStatus() != 200) {
            log.error("queryMonitorRule error, ruleId: {}, tenantId: {}, errorMsg: {}", ruleId, tenantId, resp.getErrorMessage());
            throw new DWBusinessException(resp.getErrorMessage());
        }
        return dataPickService.convert(resp.getResponse(), MonitorRuleDTO.class);
    }


}
