package com.digiwin.athena.datamap.spi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.utils.DataMapUtils;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
@Slf4j
public class DatamapCacService {

    @Autowired
    RestTemplate restTemplate;

    @Value("${cacUrl}")
    private String cacUrl;

    @Value("${iamApToken}")
    private String iamApToken;
    private final String AUTHORIZATIONS_TENANTS = "/api/cac/v4/authorizations/tenants/";
    private static final String CAC_TENANT_USER = "/api/cac/v4/authorizations/current/user/apps";

    public Object authorizationsTenants(String tenantId) {
        String requestUrl = cacUrl + AUTHORIZATIONS_TENANTS + tenantId;
        HttpHeaders headers = new HttpHeaders();
        DataMapUtils.requiredHeaders(headers);
        HttpEntity<JSONObject> httpEntity = new HttpEntity<>(headers);
        ResponseEntity<Object> exchange = restTemplate.exchange(requestUrl, HttpMethod.GET, httpEntity, Object.class);
        Object forObject = exchange.getBody();
        return forObject;
    }

    public List<String> getAuthorizationsApplication(String tenantId) {
        List<String> appLists = new ArrayList<>();
        Object obj = this.authorizationsTenants(tenantId);
        if (obj == null) {
            return appLists;
        }
        JSONArray jsonArray = JSON.parseArray(JSONObject.toJSONString(obj));
        for (int i = 0; i < jsonArray.size(); i++) {
            String code = jsonArray.getJSONObject(i).getString("code");
            String expiredTime = jsonArray.getJSONObject(i).getString("expiredTime");
            DateTimeFormatter dtf2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime expiredLocalDateTime = LocalDateTime.parse(expiredTime, dtf2);
            if (expiredLocalDateTime.isBefore(LocalDateTime.now())) {
             //   log.info("app:{} 已经过期了， expiredTime：{}", code, expiredTime);
                continue;
            }
            appLists.add(code);
        }
        return new ArrayList<>(appLists);
    }

    public List<String> getAppAuth(String userId) throws DWBusinessException {
        HttpHeaders headers = new HttpHeaders();
        DataMapUtils.requiredHeaders(headers);
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        // headers.set("digi-middleware-auth-user", DWServiceContext.getContext().getToken());
        headers.set("digi-middleware-auth-app", iamApToken);
        String url = cacUrl + CAC_TENANT_USER;
        if (StringUtils.isNotEmpty(userId)) {
            url = url + "?userId=" + userId;
        }

        ResponseEntity<Map<String, Object>> response = restTemplate.exchange(url, HttpMethod.GET,
                new HttpEntity<>(headers), new ParameterizedTypeReference<Map<String, Object>>() {
                });

        if (response.getStatusCode() == HttpStatus.OK) {
            Map<String, Object> body = response.getBody();
            List<Map<String, Object>> dataList = (List<Map<String, Object>>) body.get("data");

            if (dataList != null) {
                return dataList.stream().filter(e -> this.isEffective(e)).map(data -> data.get("id").toString()).collect(Collectors.toList());
            } else {
                return Collections.emptyList();
            }
        }

        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getAuthError"));
    }

    private boolean isEffective(Map<String, Object> map) {
        Object expiredTimeObj = map.get("expiredTime");
        if (expiredTimeObj != null) {
            String expiredTime = String.valueOf(expiredTimeObj);
            DateTimeFormatter dtf2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            LocalDateTime expiredLocalDateTime = LocalDateTime.parse(expiredTime, dtf2);
            return LocalDateTime.now().isBefore(expiredLocalDateTime);
        }
        return false;
    }

}
