package com.digiwin.athena.datamap.spi;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import org.bson.Document;
import org.bson.conversions.Bson;

import java.util.List;

public interface IDbPresetService {

    <T> T findOne(Bson filter, Class<T> entityClass, String collectionName);

    <T> T findOne(Bson filter, Bson projection, Class<T> entityClass, String collectionName);

    <T> List<T> find(Bson filter, Class<T> entityClass, String collectionName);

    <T> List<T> find(Bson filter, Bson projection, Class<T> entityClass, String collectionName);

    MongoCollection<Document> getCollection(String name, String... indexes);

    UpdateResult upsert(Bson filter, Bson update, String collectionName);

    DeleteResult remove(Bson filter, String collectionName);
}
