package com.digiwin.athena.datamap.spi;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.constants.KnowledgeGraphDb;
import com.digiwin.athena.domain.common.ITenantObject;
import com.digiwin.athena.dto.BasicQuery;
import com.mongodb.client.result.DeleteResult;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.mongodb.client.result.UpdateResult;
import org.bson.conversions.Bson;

import java.util.List;

public interface IKnowledgeGraphService {

    <T> T findOne(Bson filter, Class<T> entityClass, String collectionName, KnowledgeGraphDb db);

    <T> T findOne(Bson filter, Bson projection, Class<T> entityClass, String collectionName, KnowledgeGraphDb db);

    <T extends ITenantObject> T findOneWithTenant(Bson filter, Class<T> entityClass, String collectionName, KnowledgeGraphDb db) throws DWBusinessException;

    <T> List<T> find(Bson filter, Class<T> entityClass, String collectionName, KnowledgeGraphDb db);

    <T> List<T> find(Bson filter, Bson projection, Class<T> entityClass, String collectionName, KnowledgeGraphDb db);

    UpdateResult upsert(Bson filter, Bson update, String collectionName, KnowledgeGraphDb db);

    DeleteResult remove(Bson filter, String collectionName, KnowledgeGraphDb db);

    List<ApplicationRelation> relations(String app, String type) throws DWBusinessException;

    List<ApplicationRelation> relations(List<String> apps, String type) throws DWBusinessException;
    List<ApplicationRelation> applicationRelations(List<String> appCodes,String type,String subType) throws DWBusinessException;

    List<Application> applications(List<String> appCodes) throws DWBusinessException;

    Application application(String app) throws DWBusinessException;

    /**
     * 根据组件code从应用组件关系表获取应用数据
     * @param code 组件code
     * @param type 类型
     * @return
     * @throws DWBusinessException
     */
    ApplicationRelation relation(String code, String type) throws DWBusinessException;

    <T> List<T> find(BasicQuery basicQuery, Class<T> c, KnowledgeGraphDb db, String col);
    <T> T findOne(BasicQuery basicQuery, Class<T> c, KnowledgeGraphDb db, String col);
}
