package com.digiwin.athena.datamap.spi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.athena.datamap.utils.DataMapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
@Slf4j
public class MdcService {

    @Value("${mdcUrl}")
    private String mdcUrl;

    public String getErp(String tenantId) {
        Map<String, Object> params = new HashMap<>();
        params.put("tenant_id", tenantId);
        params.put("prod_type", "ERP");
        String resp = DataMapUtils.requestString(mdcUrl + "/restful/standard/mdc/TenantProductType/Get", "post", params);
        Object respObj = JSON.parseObject(resp);
        System.out.println(respObj);
        try {
            Object erp = JSONPath.eval(respObj, "$.data.gateway[0].product[0].name");
            return (String) erp;
        } catch (Exception e) {
            log.error("获取erp信息失败", e);
        }
        return null;
    }

}
