package com.digiwin.athena.datamap.utils;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.service.DWServiceContext;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.util.ResourceUtils;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2020-06-29 17:52
 **/
@Slf4j
public class CommonUtils {

    private static ThreadLocal<String> currentLocale = new ThreadLocal<>();

    public static boolean isPrimitive(Class<?> c) {
        if (c != null) {

            if (c.isPrimitive() || Number.class.isAssignableFrom(c) || Boolean.class.equals(c)
                    || Character.class.isAssignableFrom(c) || CharSequence.class.isAssignableFrom(c)) {
                return true;
            }

        }

        return false;
    }

    public static Method getSetMethod(Class objectClass, String fieldName) {
        try {
            Class[] parameterTypes = new Class[1];
            Field field = objectClass.getDeclaredField(fieldName);
            parameterTypes[0] = field.getType();
            StringBuffer sb = new StringBuffer();
            sb.append("set");
            sb.append(fieldName.substring(0, 1).toUpperCase());
            sb.append(fieldName.substring(1));
            Method method = objectClass.getMethod(sb.toString(), parameterTypes);
            // System.out.println(method +"==="+objectClass.getSuperclass());
            return method;
        } catch (NoSuchFieldException e0) {
            if (objectClass.getSuperclass() != null && !objectClass.getSuperclass().equals(Object.class)) {
                return getSetMethod(objectClass.getSuperclass(), fieldName);
            }
        } catch (Exception e) {
            log.error(e.toString());
        }
        return null;
    }

    public static Method getGetMethod(Class objectClass, String fieldName) {
        if (null == objectClass || null == fieldName) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("get");
        sb.append(fieldName.substring(0, 1).toUpperCase());
        sb.append(fieldName.substring(1));
        Method method = null;
        try {
            method = objectClass.getMethod(sb.toString(), null);
        } catch (NoSuchMethodException e) {
            log.error(e.toString());
        }

        return method;
    }

    public static List<Field> getFields(Class<?> clazz) {

        Class<?> c = clazz;
        List<Field> fields = new ArrayList<>();

        do {
            Field[] fs = c.getDeclaredFields();
            for (Field f : fs) {
                int mod = f.getModifiers();
                if (!Modifier.isStatic(mod) && !Modifier.isFinal(mod) && !isContain(fields, f)) {
                    fields.add(f);
                }
            }
            c = c.getSuperclass();
        } while (c != null);

        return fields;
    }

    public static Field getField(Class<?> clazz, String name) {
        Class<?> c = clazz;
        do {
            Field[] fs = c.getDeclaredFields();
            for (Field f : fs) {
                int mod = f.getModifiers();
                if (!Modifier.isStatic(mod) && !Modifier.isFinal(mod) && name.equals(f.getName())) {
                    return f;
                }
            }
            c = c.getSuperclass();
        } while (c != null);
        return null;
    }

    public static boolean isContain(List<Field> fieldList, Field field) {
        for (Field temp : fieldList) {
            if (temp.getName().equals(field.getName())) {
                return true;
            }
        }
        return false;
    }

    public static String getCurrentLocale() {
        String localeString = null;
        Map<String, Object> headers = DWServiceContext.getContext().getRequestHeader();
        if (headers != null && headers.containsKey("locale")) {
            localeString = (String) headers.get("locale");
        }

        return localeString;
    }

    public static void setLocale(String locale) {
        currentLocale.set(locale);
    }

    public static String getLocale() {
        return currentLocale.get();
    }

    public static String loadFile(String fileName) {
        try {
            String text = FileUtils.readFileToString(ResourceUtils.getFile(CommonUtils.class.getResource("/files/" + fileName)), "utf-8");
            return text;
        } catch (IOException e) {
            log.error(e.toString());
        }
        return null;
    }

    public static String loadStream(String fileName) {
        try {
            String text = IOUtils.toString(CommonUtils.class.getResource("/files/" + fileName), "utf-8");
            return text;
        } catch (IOException e) {
            log.error(e.toString());
        }
        return null;
    }

    public static String content(String name, Map<String, String> param) {
        String file = CommonUtils.loadStream(name);
        String replaced = file;
        for (Map.Entry<String, String> entry : param.entrySet()) {
            String pattern = "#" + entry.getKey() + "#";
            String value = entry.getValue();
            if (value.startsWith("$")) {
                value = "\\" + value;
            }
            replaced = replaced.replaceAll(pattern, value);
        }
        return replaced;
    }

    public static Object entity(String name, Map<String, String> param) {
        String replaced = content(name, param);
        Object entities = JSON.parseObject(replaced);
        return entities;
    }

    public static <T> T entity(String name, Map<String, String> param, Class<T> c) {
        String replaced = content(name, param);
        T entities = JSON.parseObject(replaced, c);
        return entities;
    }

    public static List entities(String name, Map<String, String> param) {
        String replaced = content(name, param);
        List entities = JSON.parseArray(replaced);
        return entities;
    }

    public static <T> List<T> entities(String name, Map<String, String> param, Class c) {
        String replaced = content(name, param);
        List<T> entities = JSON.parseArray(replaced, c);
        return entities;
    }

    public static <T> List<List<T>> spliceArrays(List<T> datas, int splitSize) {
        if (datas == null || splitSize < 1) {
            return null;
        }
        int totalSize = datas.size();
        int count = (totalSize % splitSize == 0) ? (totalSize / splitSize) : (totalSize / splitSize + 1);
        List<List<T>> rows = new ArrayList<>(splitSize);
        for (int i = 0; i < count; i++) {
            List<T> cols = datas.subList(i * splitSize,
                    (i == count - 1) ? totalSize : splitSize * (i + 1));
            rows.add(cols);
        }
        return rows;
    }

    public static void main(String[] args) {

        String content = loadStream("DDSM/Activity.json");
        System.out.println(content);

    }

}
