package com.digiwin.athena.repository.neo4j;

import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.datamap.povo.ActivityInputData;
import com.digiwin.athena.kg.action.Action;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.Neo4jRepository;

import java.util.List;
import java.util.Optional;

public interface ActivityRepository extends Neo4jRepository<Action, Long> {

    @Query(value = "MATCH (task:Task{code:$1,version:$3})-[:Contains]->(t:Activity {code:$2})-[:InputData]->(entity:DataEntity)-[:Contains]->(field:DataField) " +
            "where (task.tenantId in ['SYSTEM',$0] or task.tenantId is null) RETURN t.code as activityId, COLLECT(field) as fields, entity as inputData")
    Optional<ActivityInputData> getActivityInputData(String tenantId, String code, String activityId, String tenantVersion);


    @Query("match(a:Activity) where a.category = 'ABI-STATEMENT' return distinct  a.code as code")
    List<String> getAllABiReportCodes();

    @Query("MATCH (activity:Activity) where activity.code = $0 and activity.version = $1 and (activity.tenantId in ['SYSTEM',$2] or activity.tenantId is null or $2 in activity.inclusionTenant)" +
            "return activity")
    List<Activity> getActivityByCodeAndVersion(String activityCode, String tenantVersion, String tenantId);

    @Query("match (a:Activity{code:$1,version:$2}) " +
            "where (a.tenantId in ['SYSTEM',$0] or a.tenantId is null or $0 in a.inclusionTenant) return a")
    List<Activity> getActivityByCode(String tenantId, String activityCode, String tenantVersion);

    @Query("match (a:Activity{nameSpace:'common'}) where a.tenantId in ['SYSTEM',$0] or a.tenantId is null or $0 in a.inclusionTenant return a")
    List<Activity> getCommonBaseData(String tenantId);

    @Query("match (a:Activity{pattern:$1,version:$2}) where (a.tenantId in ['SYSTEM',$0] or a.tenantId is null or $0 in a.inclusionTenant) and a.code in $3  return a")
    List<Activity> getActivitiesByPattern(String tenantId, String pattern, String tenantVersion,List<String> codes);
}
