/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.actions.adapters;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.actions.ActionReq;
import com.digiwin.athena.datamap.actions.ActionResp;
import com.digiwin.athena.datamap.actions.adapters.AbstractErpAdapter;
import com.digiwin.athena.datamap.service.impl.DataMapActionService;
import com.digiwin.athena.domain.erp.Erp2DataDTO;
import com.digiwin.athena.domain.erp.Erp2FormDTO;
import com.digiwin.athena.domain.erp.Erp2FormField;
import com.digiwin.athena.domain.erp.Erp2FormInfo;
import com.digiwin.athena.domain.erp.ErpSyncBill;
import com.digiwin.athena.domain.erp.ErpSyncRecord;
import com.digiwin.athena.domain.erp.NameValue;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class E10Adapter
extends AbstractErpAdapter {
    @Autowired
    DataMapActionService dataMapActionService;

    @Override
    public boolean support(String erp) {
        return "E10".equalsIgnoreCase(erp);
    }

    @Override
    public String erpTemplate(Erp2FormDTO dto) throws DWBusinessException {
        return "Do";
    }

    @Override
    public ErpSyncBill getMeta(Erp2FormDTO dto) throws DWException {
        ActionReq req = new ActionReq();
        req.setActionId("e10.oapi.schema.data.get");
        req.getParams().put("program_id", ((NameValue)dto.getData().get("program_id")).getValue());
        ActionResp actionResp = this.dataMapActionService.postProcess(req);
        ErpSyncBill bill = (ErpSyncBill)JSON.parseObject((String)JSON.toJSONString((Object)actionResp.getData()), ErpSyncBill.class);
        this.multilingualSettings(bill);
        return bill;
    }

    @Override
    protected void subFillData(Erp2DataDTO dto, List<ErpSyncRecord> records, Erp2FormInfo erp2FormInfo, Map<String, Object> current) throws DWBusinessException {
        for (Erp2FormField field : erp2FormInfo.getFields()) {
            if (!Boolean.TRUE.equals(field.getAsUniKey()) || !"op_org_no".equals(field.getKey())) continue;
            String orgType = (String)current.get("source_doc_type");
            if (StringUtils.isEmpty((CharSequence)orgType)) {
                return;
            }
            Object orgNo = null;
            switch (orgType) {
                case "COMPANY": {
                    orgNo = this.getValue(dto.getData(), "$.data.om_company_id");
                    break;
                }
                case "PLANT": {
                    orgNo = this.getValue(dto.getData(), "$.data.om_site_id");
                    break;
                }
                case "SALES_CENTER": {
                    orgNo = this.getValue(dto.getData(), "$.data.om_region_id");
                    break;
                }
                case "SUPPLY_CENTER": {
                    orgNo = this.getValue(dto.getData(), "$.data.om_region_id");
                    break;
                }
            }
            current.put(field.getKey(), orgNo);
        }
    }
}

