/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.actions.handlers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.digiwin.athena.datamap.actions.ActionHandler;
import com.digiwin.athena.datamap.actions.ActionReq;
import com.digiwin.athena.datamap.actions.ActionResp;
import com.digiwin.athena.datamap.spi.EspService;
import com.digiwin.athena.datamap.supports.EspBody;
import com.digiwin.athena.datamap.supports.EspRequest;
import com.digiwin.athena.datamap.utils.CommonUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractActionHandler
implements ActionHandler {
    @Autowired
    EspService espService;

    protected ActionResp callEsp(EspRequest request) {
        ActionResp resp = new ActionResp();
        EspBody body = this.espService.invokeSync(request);
        resp.setSuccess(body.getSuccess());
        if (body.getSuccess().booleanValue() && null != body.getStd_data() && null != body.getStd_data().getParameter()) {
            resp.setData(body.getStd_data().getParameter());
        } else {
            resp.setMsg(body.getMsg());
            HashMap<String, JSONArray[]> rows = new HashMap<String, JSONArray[]>();
            rows.put("rows", new JSONArray[0]);
            resp.setData(rows);
            resp.setSuccess(Boolean.FALSE);
        }
        return resp;
    }

    protected Map<String, String> E10headers() {
        HashMap<String, String> headers = new HashMap<String, String>();
        return headers;
    }

    private void callTestEsp(String serviceName) {
        ActionResp resp = new ActionResp();
        String fileName = Objects.equals(serviceName, "e10.oapi.schema.data.get") ? "ysj.json" : (Objects.equals(serviceName, "e10.oapi.easyflow.object.list.data.query.get") ? "jczy.json" : (Objects.equals(serviceName, "e10.oapi.doc.list.data.query.get") ? "djxz.json" : (Objects.equals(serviceName, "e10.oapi.company.list.data.query.get") ? "company.json" : (Objects.equals(serviceName, "e10.oapi.plant.list.data.query.get") ? "plant.json" : (Objects.equals(serviceName, "e10.oapi.sales.center.list.data.query.get") ? "sales.json" : (Objects.equals(serviceName, "e10.oapi.supply.center.list.data.query.get") ? "supply.json" : "ysj.json"))))));
        String files = CommonUtils.loadStream("test/" + fileName);
        EspBody body = (EspBody)JSON.parseObject((String)files, EspBody.class);
        body.setSuccess(Boolean.TRUE);
        resp.setSuccess(Boolean.TRUE);
    }

    @Override
    public boolean accept(ActionReq actionReq) {
        if (null != this.actionId() && null != actionReq.getActionId()) {
            return this.actionId().equals(actionReq.getActionId());
        }
        return false;
    }

    protected abstract String actionId();
}

