/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.configuration;

import com.digiwin.athena.kmservice.constants.DataMapDb;
import com.digiwin.athena.kmservice.constants.KnowledgeGraphDb;
import com.mongodb.MongoClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.core.convert.MongoConverter;

@Configuration
public class MultiMongoSourceConfiguration {
    @Autowired
    MongoClient mongo;
    @Autowired
    MongoConverter converter;

    @Bean(value={"dataMapSystem"})
    public MongoTemplate dataMapSystem(MongoClient mongo) throws Exception {
        SimpleMongoDbFactory mongoDbFactory = new SimpleMongoDbFactory(mongo, DataMapDb.DATAMAP.getValue());
        System.out.println("systemdb...." + mongoDbFactory.getDb().getName());
        return new MongoTemplate((MongoDbFactory)mongoDbFactory, this.converter);
    }

    @Bean(value={"dataMapTenant"})
    public MongoTemplate dataMapTenant(MongoClient mongo) throws Exception {
        SimpleMongoDbFactory mongoDbFactory = new SimpleMongoDbFactory(mongo, DataMapDb.DATAMAPTENANT.getValue());
        System.out.println("tenantdb...." + mongoDbFactory.getDb().getName());
        return new MongoTemplate((MongoDbFactory)mongoDbFactory, this.converter);
    }

    @Bean(value={"kgSystem"})
    public MongoTemplate kgSystem() {
        SimpleMongoDbFactory mongoDbFactorySys = new SimpleMongoDbFactory(this.mongo, KnowledgeGraphDb.SYSTEM.getValue());
        MongoTemplate mongoTemplateSys = new MongoTemplate((MongoDbFactory)mongoDbFactorySys, this.converter);
        return mongoTemplateSys;
    }

    @Bean(value={"kgTenant"})
    public MongoTemplate kgTenant() {
        SimpleMongoDbFactory mongoDbFactorySys = new SimpleMongoDbFactory(this.mongo, KnowledgeGraphDb.TENANT.getValue());
        MongoTemplate mongoTemplateSys = new MongoTemplate((MongoDbFactory)mongoDbFactorySys, this.converter);
        return mongoTemplateSys;
    }

    @Bean(value={"presetMongoTemplate"})
    public MongoTemplate presetMongoTemplate() {
        SimpleMongoDbFactory mongoDbFactory = new SimpleMongoDbFactory(this.mongo, "preset");
        MongoTemplate presetMongoTemplate = new MongoTemplate((MongoDbFactory)mongoDbFactory, this.converter);
        return presetMongoTemplate;
    }
}

