/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/datamap/javadoc"})
public class DocController {
    private static final Logger log = LoggerFactory.getLogger(DocController.class);
    @Resource
    private ObjectMapper objectMapper;

    @GetMapping(value={"/"})
    public String getDoc() {
        return "datamap/javadoc/".concat(this.getAllInOneDocFileName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getAllInOneDocFileName() {
        try (InputStream inputStream = new ClassPathResource("smart-doc.json").getInputStream();){
            JsonNode rootNode = this.objectMapper.readTree(inputStream);
            String string = rootNode.path("allInOneDocFileName").asText();
            return string;
        }
        catch (Exception e) {
            log.error("Route==>DocController method=getAllInOneDocFileName error:", (Throwable)e);
            return null;
        }
    }
}

