/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.dao;

import com.digiwin.athena.datamap.service.inner.DataMapKgDataPickService;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.kg.activity.Activity;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DataMapActivityDAO {
    @Autowired
    @Qualifier(value="kgSystem")
    private MongoTemplate mongoTemplateSystem;
    @Autowired
    @Qualifier(value="kgDataPickService")
    DataMapKgDataPickService dataPickService;

    public List<String> getAllABiReportCodes() {
        Criteria criteria = Criteria.where((String)"category").is((Object)"ABI-STATEMENT");
        List result = this.mongoTemplateSystem.find(Query.query((CriteriaDefinition)criteria), Activity.class, "activityConfigsBasic");
        return result.stream().map(BaseEntity::getCode).distinct().collect(Collectors.toList());
    }

    public List<Activity> getActivityByCodeAndVersion(String activityCode, String tenantVersion, String tenantId) {
        Criteria criteria = Criteria.where((String)"code").is((Object)activityCode).and("version").is((Object)tenantVersion).andOperator(new Criteria[]{this.getCriteriaByTenantId(tenantId, true)});
        return this.mongoTemplateSystem.find(Query.query((CriteriaDefinition)criteria), Activity.class, "activityConfigsBasic");
    }

    public List<Activity> getCommonBaseData(String tenantId) {
        Criteria criteria = Criteria.where((String)"nameSpace").is((Object)"common").andOperator(new Criteria[]{this.getCriteriaByTenantId(tenantId, true)});
        return this.mongoTemplateSystem.find(Query.query((CriteriaDefinition)criteria), Activity.class, "activityConfigsBasic");
    }

    public Criteria getCriteriaByTenantId(String tenantId, boolean inclusionTenant) {
        Criteria criteria = Criteria.where((String)"tenantId").in(new Object[]{tenantId, "SYSTEM", null});
        if (inclusionTenant) {
            criteria = new Criteria().orOperator(new Criteria[]{criteria, Criteria.where((String)"inclusionTenant").is((Object)tenantId)});
        }
        return criteria;
    }
}

