/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.dao;

import com.alibaba.druid.util.StringUtils;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.service.inner.DataMapKgDataPickService;
import com.digiwin.athena.domain.component.ComponentStructuredList;
import com.digiwin.athena.domain.component.bo.ComponentStructuredListType;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DatamapComponentStructuredListDAO {
    @Autowired
    @Qualifier(value="kgSystem")
    private MongoTemplate mongoTemplateSystem;
    @Autowired
    @Qualifier(value="kgDataPickService")
    DataMapKgDataPickService dataPickService;

    public ComponentStructuredList findBaseFunctionComponentStructuredList(String appCode, String paradigm, String version, String tenantId) throws DWBusinessException {
        Criteria criteria = Criteria.where((String)"appCode").is((Object)appCode).and("paradigm").is((Object)paradigm).and("type").is((Object)ComponentStructuredListType.BaseFunction).and("version").is((Object)version).and("tenantId").is((Object)tenantId);
        ComponentStructuredList result = (ComponentStructuredList)this.mongoTemplateSystem.findOne(Query.query((CriteriaDefinition)criteria), ComponentStructuredList.class, "componentStructuredList");
        if (result != null) {
            return result;
        }
        throw new DWBusinessException(I18nUtils.getValue((String)"knowledgegraph.noAvailableComponent", (Object[])new Object[]{paradigm, appCode}));
    }

    public List<ComponentStructuredList> findBaseFunctionComponentStructuredList(String appCode, List<String> paradigms, String version, String tenantId) throws DWBusinessException {
        Criteria criteria = Criteria.where((String)"appCode").is((Object)appCode).and("paradigm").in(paradigms).and("version").is((Object)version).and("type").is((Object)ComponentStructuredListType.BaseFunction).and("tenantId").is((Object)tenantId);
        List result = this.mongoTemplateSystem.find(Query.query((CriteriaDefinition)criteria), ComponentStructuredList.class, "componentStructuredList");
        if (result != null) {
            return result;
        }
        throw new DWBusinessException(I18nUtils.getValue((String)"knowledgegraph.noAvailableComponent", (Object[])new Object[]{paradigms, appCode}));
    }

    public List<ComponentStructuredList> findBaseFunctionComponentStructuredList(String appCode, String version, String tenantId) throws DWBusinessException {
        Criteria criteria = Criteria.where((String)"appCode").is((Object)appCode).and("version").is((Object)version).and("type").is((Object)ComponentStructuredListType.BaseFunction).and("tenantId").is((Object)tenantId);
        List result = this.mongoTemplateSystem.find(Query.query((CriteriaDefinition)criteria), ComponentStructuredList.class, "componentStructuredList");
        return result;
    }

    public ComponentStructuredList findMechanismComponentStructuredList(String mechanismCode, String version, String tenantId) throws DWBusinessException {
        Criteria criteria = Criteria.where((String)"mechanismCode").is((Object)mechanismCode).and("version").is((Object)version).and("type").is((Object)ComponentStructuredListType.Mechanism);
        ComponentStructuredList result = this.dataPickService.findOneByCondition(criteria, tenantId, ComponentStructuredList.class, "componentStructuredList");
        if (result != null) {
            return result;
        }
        throw new DWBusinessException(I18nUtils.getValue((String)"knowledgegraph.noAvailableComponent3", (Object[])new Object[]{mechanismCode}));
    }

    public List<ComponentStructuredList> findMechanismComponentStructuredList(List<String> mechanismCode, String version, String tenantId) throws DWBusinessException {
        Criteria criteria = Criteria.where((String)"mechanismCode").in(mechanismCode).and("version").is((Object)version).and("type").is((Object)ComponentStructuredListType.Mechanism);
        List<ComponentStructuredList> result = this.dataPickService.find(criteria, tenantId, ComponentStructuredList.class, "componentStructuredList");
        if (CollectionUtils.isNotEmpty(result)) {
            return result;
        }
        return new ArrayList<ComponentStructuredList>();
    }

    public List<String> findAllMechanismCodes(String appCode, String version, String tenantId) throws DWBusinessException {
        Criteria criteria = Criteria.where((String)"appCode").is((Object)appCode).and("version").is((Object)version);
        ArrayList<String> mechanismCodes = new ArrayList<String>();
        List<ComponentStructuredList> result = this.dataPickService.find(criteria, tenantId, ComponentStructuredList.class, "componentStructuredList");
        if ((result = this.dataPickService.excludeWithSameCode(result)) != null && !result.isEmpty()) {
            result.forEach(list -> {
                String mechanismCode = list.getMechanismCode();
                if (!StringUtils.isEmpty((String)mechanismCode)) {
                    mechanismCodes.add(mechanismCode);
                }
            });
        }
        return mechanismCodes;
    }

    private void addTenantCondition(Criteria criteria, String appCode, String tenantId) throws DWBusinessException {
        Application application = this.dataPickService.tenantAppRelation(appCode, tenantId);
        boolean individualAll = Optional.ofNullable(application).map(Application::getIndividualAll).orElse(false);
        criteria.and("tenantId").is((Object)(individualAll ? tenantId : "SYSTEM"));
    }
}

