/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.engine.service.processor;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.engine.constants.MechDatasourceType;
import com.digiwin.athena.datamap.engine.service.inner.MechHelpService;
import com.digiwin.athena.datamap.engine.service.processor.MechDatasourceProcessor;
import com.digiwin.athena.datamap.engine.service.utils.Mutil;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.mechanism.achivebo.MechanismDecision;
import com.digiwin.athena.mechanism.achivebo.MechanismDecisionTarget;
import com.digiwin.athena.mechanism.dto.SourceDataDTO;
import com.digiwin.athena.mechanism.vo.DecisionRespItem;
import com.digiwin.athena.mechanism.widgets.CheckWidget;
import com.digiwin.athena.mechanism.widgets.choose.MultiStrategyWidget;
import com.digiwin.athena.mechanism.widgets.plan.RefPlanWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DecisionMechDatasourceProcessor
implements MechDatasourceProcessor {
    public static final String dataKey = "__DATA_KEY";
    @Autowired
    MechHelpService helpService;

    @Override
    public boolean accept(SourceDataDTO datasource) {
        return MechDatasourceType.decision.name().equals(datasource.getType());
    }

    @Override
    public Object process(SourceDataDTO sourceData) throws DWBusinessException {
        System.out.println("\u673a\u5236\u5f00\u59cb\u51b3\u7b56:");
        System.out.println(JSON.toJSONString((Object)sourceData, (boolean)true));
        HashMap result = new HashMap();
        String tenantId = ServiceUtils.getTenantId();
        MechanismDecision decision = this.helpService.getMechDecisionByDataSourceCode(sourceData.getCode());
        if (null != decision && null != decision.getConditions()) {
            String paradigmExpression = this.helpService.paradigmExpression(decision.getMechanismCode(), decision.getDataCode());
            System.out.println("\u51b3\u7b56\u83b7\u53d6\u8303\u5f0f\u8868\u8fbe\u5f0f\uff1a" + paradigmExpression + " by mechanismCode:" + decision.getMechanismCode() + " dataCode:" + decision.getDataCode());
            CheckWidget paracondition = null;
            if (null != paradigmExpression) {
                paracondition.setType("expression");
                paracondition.setExpression(paradigmExpression);
            }
            ArrayList<DecisionRespItem> items = new ArrayList<DecisionRespItem>();
            ArrayList<String> ids = new ArrayList<String>();
            List unikeys = sourceData.getUnikeys();
            if (null == unikeys) {
                unikeys = decision.getDataSource().getUnikeys();
            }
            HashMap variable = new HashMap();
            variable.put("data", sourceData.getDatas());
            for (Object data : sourceData.getDatas()) {
                DecisionRespItem item = new DecisionRespItem();
                String keyvalue = Mutil.uniKey(data, dataKey);
                if (null != keyvalue) {
                    item.setKey(keyvalue);
                } else {
                    item.setKey(Mutil.uniKey(data, unikeys));
                }
                variable.put("item", data);
                if (null != paradigmExpression) {
                    boolean check0 = this.helpService.check(paracondition, variable);
                    System.out.print("\u6570\u636e" + JSON.toJSONString(data));
                    System.out.println(" \u8303\u5f0f\u68c0\u67e5\u7ed3\u679c\u4e3a:" + check0);
                    if (!check0) continue;
                }
                for (MultiStrategyWidget condition : decision.getConditions()) {
                    boolean check = this.helpService.check(condition.getCondition(), variable);
                    if (!check) continue;
                    ArrayList targetIds = new ArrayList();
                    if (null != condition.getPositiveTargets()) {
                        condition.getPositiveTargets().forEach(tt -> {
                            RefPlanWidget planWidget = (RefPlanWidget)ServiceUtils.cast((Object)tt, RefPlanWidget.class);
                            if (null != planWidget.getRefId()) {
                                targetIds.add(planWidget.getRefId());
                            }
                        });
                    }
                    item.setTargetIds(targetIds);
                    ids.addAll(item.getTargetIds());
                    break;
                }
                items.add(item);
            }
            if (ids.size() > 0) {
                List<MechanismDecisionTarget> targets = this.helpService.getSuggestTargetsByIds(ids);
                HashMap mm = new HashMap();
                targets.forEach(t -> mm.put(t.getTargetId(), t));
                for (DecisionRespItem item : items) {
                    if (null == item.getTargetIds()) continue;
                    item.setTargets(new ArrayList());
                    for (String id : item.getTargetIds()) {
                        MechanismDecisionTarget mo = (MechanismDecisionTarget)mm.get(id);
                        if (null == mo) continue;
                        item.getTargets().add(mo.getTarget());
                    }
                }
            }
            result.put("suggest", items);
        }
        System.out.println("\u51b3\u7b56\u8fd4\u56de:");
        System.out.println(JSON.toJSONString(result, (boolean)true));
        return result;
    }
}

