/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.engine.service.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class ProjectVariableUtil {
    private static final String _REGEX = "\\$\\(\\w+((\\[[0-9]+\\]|[\\.]|\\w+)+)+\\)";

    private static void appendLog(String logStr) {
    }

    private static boolean isJSONString(String str, String start, String end) {
        if (Objects.isNull(str)) {
            return false;
        }
        String _v = str.trim();
        return _v.startsWith(start) && _v.endsWith(end);
    }

    public static boolean isJSONObject(String str) {
        return ProjectVariableUtil.isJSONString(str, "{", "}");
    }

    public static boolean isJSONArray(String str) {
        return ProjectVariableUtil.isJSONString(str, "[", "]");
    }

    public static boolean isProcessVariableKey(String key) {
        if (Objects.isNull(key)) {
            return false;
        }
        String _key = key.trim();
        return _key.startsWith("$(") && _key.endsWith(")");
    }

    public static String getValueString(String key, Map<String, Object> variables) {
        if (!ProjectVariableUtil.isProcessVariableKey(key)) {
            return null;
        }
        String _key = key.substring(2, key.length() - 1);
        String returnValue = ProjectVariableUtil.getValueQuery(_key, variables);
        if (Objects.isNull(returnValue)) {
            if (variables.containsKey(_key)) {
                if (variables.get(_key) instanceof Map) {
                    Map tTmpValue = (Map)variables.get(_key);
                    returnValue = new JSONObject(tTmpValue).toString();
                } else if (variables.get(_key) instanceof List) {
                    List tTmpValue = (List)variables.get(_key);
                    returnValue = new JSONArray((Collection)tTmpValue).toString();
                } else {
                    returnValue = variables.get(_key) + "";
                }
            } else {
                ProjectVariableUtil.appendLog(String.format("the  key[%s] is not found", key));
            }
        }
        return returnValue;
    }

    private static String getValueQuery(String key, Map<String, Object> variables) {
        if (!(key.contains(".") || key.contains("[") && key.contains("]"))) {
            return null;
        }
        int dotIndex = key.indexOf(46);
        int bracketIndex = key.indexOf(91);
        boolean isArray = dotIndex > 0 && bracketIndex > 0 ? dotIndex >= bracketIndex : dotIndex <= 0;
        String rKey = isArray ? key.substring(0, bracketIndex) : key.substring(0, dotIndex);
        String nextValue = ProjectVariableUtil.getValueString(String.format("$(%s)", rKey), variables);
        if (Objects.isNull(nextValue)) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        if (isArray) {
            jsonObject.put(rKey, (Object)new JSONArray(nextValue));
        } else {
            jsonObject.put(rKey, (Object)new JSONObject(nextValue));
        }
        String path = "/" + key.replace('.', '/').replace('[', '/').replace("]", "").trim();
        Object val = jsonObject.query(path);
        if (Objects.isNull(val)) {
            return null;
        }
        return val.toString();
    }

    public static Object getValueObject(String key, Map<String, Object> variables) {
        String returnValue = ProjectVariableUtil.getValueString(key, variables);
        if (ProjectVariableUtil.isJSONObject(returnValue)) {
            return new JSONObject(returnValue);
        }
        if (ProjectVariableUtil.isJSONArray(returnValue)) {
            return new JSONArray(returnValue);
        }
        return returnValue;
    }

    public static Map<String, String> geValueToMap(String key, Map<String, Object> variables) {
        HashMap<String, String> result = new HashMap<String, String>();
        String value = ProjectVariableUtil.getValueString(key, variables);
        if (ProjectVariableUtil.isJSONObject(value)) {
            JSONObject jsonObject = new JSONObject(value);
            jsonObject.keySet().forEach(s -> result.put((String)s, jsonObject.get(s).toString()));
        } else {
            ProjectVariableUtil.appendLog(String.format("the value[%s] of key[%s] is not JSONObject String", value, key));
        }
        return result;
    }

    public static String parseContext(String context, Map<String, Object> variables) {
        if (null == variables || variables.isEmpty()) {
            return context;
        }
        if (Objects.isNull(context) || "".equals(context)) {
            return context;
        }
        String returnValue = context;
        Pattern pattern = Pattern.compile(_REGEX);
        Matcher matcher = pattern.matcher(context);
        while (matcher.find()) {
            String variablePlaceholder = matcher.group();
            String variableValue = ProjectVariableUtil.getValueString(variablePlaceholder, variables);
            if (Objects.isNull(variableValue)) continue;
            returnValue = returnValue.replace(variablePlaceholder, variableValue);
        }
        return returnValue;
    }

    public static Map<String, String> parseContextToMap(String context, Map<String, Object> variables) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (Objects.isNull(context) || "".equals(context)) {
            return result;
        }
        String _context = ProjectVariableUtil.parseContext(context, variables);
        if (ProjectVariableUtil.isJSONObject(_context)) {
            JSONObject jsonObject = new JSONObject(_context);
            jsonObject.keySet().forEach(s -> result.put((String)s, jsonObject.get(s).toString()));
        }
        return result;
    }

    public static Map<String, String> JSONToMapString(JSONObject jsonObject) {
        HashMap<String, String> result = new HashMap<String, String>();
        jsonObject.keySet().forEach(s -> result.put((String)s, jsonObject.get(s).toString()));
        return result;
    }

    public static Map<String, Object> JSONToMapObject(JSONObject jsonObject) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        jsonObject.keySet().forEach(s -> result.put((String)s, jsonObject.get(s)));
        return result;
    }

    public static String ConvertToJsonString(Map<String, String> variables) {
        return ProjectVariableUtil.ConvertToJSONObject(variables).toString();
    }

    public static JSONObject ConvertToJSONObject(Map<String, String> variables) {
        JSONObject jsonObject = new JSONObject();
        variables.forEach((k, v) -> {
            if (ProjectVariableUtil.isJSONObject(v)) {
                jsonObject.put(k, (Object)new JSONObject(v));
            } else if (ProjectVariableUtil.isJSONArray(v)) {
                jsonObject.put(k, (Object)new JSONArray(v));
            } else {
                jsonObject.put(k, v);
            }
        });
        return jsonObject;
    }

    public static Map<String, Object> keepVariables(Map<String, Object> pVariables, List<String> pKeepedVarKeys) {
        HashMap<String, Object> tRtn = new HashMap();
        if (Objects.isNull(pKeepedVarKeys)) {
            tRtn = pVariables;
        } else {
            for (String tTmpVarKey : pKeepedVarKeys) {
                if (!pVariables.containsKey(tTmpVarKey)) continue;
                tRtn.put(tTmpVarKey, pVariables.get(tTmpVarKey));
            }
        }
        return tRtn;
    }
}

