/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.engine.service.utils;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.engine.service.utils.ProjectVariableUtil;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

public class ScriptEngineUtil {
    private ScriptEngineManager factory = new ScriptEngineManager();
    private ScriptEngine engine = this.factory.getEngineByName("nashorn");

    private ScriptEngineUtil() {
    }

    public static ScriptEngineUtil getInstance() {
        return ScriptEngineHolder.INSTANCE;
    }

    public ScriptContext execute(String scriptString) throws DWBusinessException {
        SimpleScriptContext ctx = new SimpleScriptContext();
        ctx.setBindings(this.engine.createBindings(), 100);
        try {
            this.engine.eval(scriptString, (ScriptContext)ctx);
        }
        catch (ScriptException e) {
            throw new DWBusinessException(I18nUtils.getValue((String)"datamap.scriptError", (Object[])new Object[0]) + "\n" + scriptString + "\n", (Throwable)e);
        }
        return ctx;
    }

    public Object executeScript(String scriptString, String resultName) throws DWBusinessException {
        return ScriptEngineUtil.convert(this.execute(scriptString).getAttribute(resultName));
    }

    public Object executeScript(String scriptString) throws DWBusinessException {
        String exeScriptString = String.format("function execute(){ \n %s\n }; \nvar __executeResult = execute();", scriptString);
        return this.executeScript(exeScriptString, "__executeResult");
    }

    public String executeStringify(String scriptString) throws DWBusinessException {
        String exeScriptString = String.format("function execute(){ \n %s\n }; \nvar __executeResult= JSON.stringify(execute());", scriptString);
        return (String)this.execute(exeScriptString).getAttribute("__executeResult");
    }

    public Object executeScript(String scriptString, Map<String, Object> pMergedVariables) throws DWBusinessException {
        String script = ProjectVariableUtil.parseContext(scriptString, pMergedVariables);
        return this.executeScript(script);
    }

    public String executeStringify(String scriptString, Map<String, Object> pMergedVariables) throws DWBusinessException {
        String script = ProjectVariableUtil.parseContext(scriptString, pMergedVariables);
        return this.executeStringify(script);
    }

    public boolean executeConditionEvaluator(String conditionScript, Map<String, Object> pMergedVariables) throws DWBusinessException {
        String script = "";
        script = script + " if(" + conditionScript + "){  \n";
        script = script + "  return true;\n";
        script = script + " }else {  \n";
        script = script + "  return false;  \n";
        script = script + " } \n";
        return (Boolean)this.executeScript(script, pMergedVariables);
    }

    public static Object convert(Object original) {
        if (original == null) {
            return null;
        }
        if (original instanceof String || original instanceof Integer || original instanceof Long || original instanceof Boolean || original instanceof Double) {
            return original;
        }
        if (original instanceof ScriptObjectMirror) {
            ScriptObjectMirror jsOriginal = (ScriptObjectMirror)original;
            if (jsOriginal.isArray()) {
                ArrayList<Object> listResult = new ArrayList<Object>();
                Integer length = (Integer)jsOriginal.get((Object)"length");
                for (int i = 0; i < length; ++i) {
                    listResult.add(ScriptEngineUtil.convert(jsOriginal.get((Object)("" + i))));
                }
                return listResult;
            }
            if (jsOriginal.isFunction()) {
                return null;
            }
            LinkedHashMap mapResult = new LinkedHashMap();
            for (Map.Entry entry : jsOriginal.entrySet()) {
                mapResult.put(entry.getKey(), ScriptEngineUtil.convert(entry.getValue()));
            }
            return mapResult;
        }
        return original;
    }

    public static void main(String[] args) throws DWBusinessException {
        HashMap<String, Object> data1 = new HashMap<String, Object>();
        data1.put("doc_no", "doc01");
        data1.put("slow_down_days", "1");
        data1.put("doc_name", "\u8bf7\u8d2d\u53551");
        data1.put("type", 0);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("item", data1);
        boolean res = ScriptEngineUtil.getInstance().executeConditionEvaluator("(($(item).type==0)  && ($(item).doc_no=='doc01')) ", param);
        System.out.println(res);
        boolean res2 = ScriptEngineUtil.getInstance().executeConditionEvaluator("$(item).slow_down_days == '1'", param);
        System.out.println(res2);
    }

    private static class ScriptEngineHolder {
        private static final ScriptEngineUtil INSTANCE = new ScriptEngineUtil();

        private ScriptEngineHolder() {
        }
    }
}

