/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.kg;

import com.digiwin.athena.kg.action.ActionMetadata;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;

@Repository
public class DataMapActionMetadataDAO {
    @Autowired
    @Qualifier(value="kgSystem")
    private MongoTemplate mongoTemplate;

    public ActionMetadata getActionMetadata(String actionId, String tenantId) {
        if (StringUtils.startsWith((String)actionId, (String)"esp_")) {
            String version = "";
            return this.getActionMetadataByActionId(actionId, version);
        }
        return this.getActionMetadataByActionId(actionId);
    }

    public ActionMetadata getActionMetadataByActionId(String actionId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"actionId").is((Object)actionId));
        return (ActionMetadata)this.mongoTemplate.findOne(query, ActionMetadata.class);
    }

    public ActionMetadata getActionMetadataByActionId(String actionId, String version) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"actionId").is((Object)actionId).and("serviceVersion").is((Object)version));
        return (ActionMetadata)this.mongoTemplate.findOne(query, ActionMetadata.class);
    }

    public void upsertActionMetadata(String actionId, String serviceVersion, Object request, Object response, String serviceName) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"actionId").is((Object)actionId));
        Update update = new Update();
        update.set("requestParameters", request).set("responseObject", response).set("serviceName", (Object)serviceName).set("serviceVersion", (Object)serviceVersion);
        this.mongoTemplate.upsert(query, update, "actionMetadata");
    }
}

