/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.kg;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.kg.AppCons;
import com.digiwin.athena.datamap.spi.DataMapIamService;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
public class DataMapLicenseKeyManager {
    private static final Logger log = LoggerFactory.getLogger(DataMapLicenseKeyManager.class);
    private static final String APP_LICENSE_KEY_COLLECTION_NAME = "appLicenseKey";
    private static final String TENANT_ID_KEY_NAME = "tenantId";
    private static final String LICENSE_KEY_FIELD_NAME = "licenseKey";
    private static final String AES_KEY_HEX = "C40605DBA4C2D6D3FA353C7CA35752B9";
    @Autowired
    @Qualifier(value="kgTenant")
    MongoTemplate mongoTemplate;
    @Autowired
    private DataMapIamService dataMapIamService;

    public void setLicenseKey(String tenantId, String licenseKey) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)TENANT_ID_KEY_NAME).is((Object)tenantId));
        Update update = new Update();
        update.set(LICENSE_KEY_FIELD_NAME, (Object)licenseKey);
        this.mongoTemplate.upsert(query, update, APP_LICENSE_KEY_COLLECTION_NAME);
    }

    public String getDirectLicenseKey(String tenantId) throws DWBusinessException {
        MongoCollection col = this.mongoTemplate.getCollection(APP_LICENSE_KEY_COLLECTION_NAME);
        Document doc = (Document)col.find(Filters.eq((String)TENANT_ID_KEY_NAME, (Object)tenantId)).first();
        if (doc != null) {
            return doc.getString((Object)LICENSE_KEY_FIELD_NAME);
        }
        throw new DWBusinessException(I18nUtils.getValue((String)"knowledgegraph.licenseKeyNotFound", (Object[])new Object[]{tenantId}));
    }

    public String getDirectLicenseKeyCanNull(String tenantId) throws DWBusinessException {
        MongoCollection col = this.mongoTemplate.getCollection(APP_LICENSE_KEY_COLLECTION_NAME);
        Document doc = (Document)col.find(Filters.eq((String)TENANT_ID_KEY_NAME, (Object)tenantId)).first();
        if (doc != null) {
            return doc.getString((Object)LICENSE_KEY_FIELD_NAME);
        }
        return null;
    }

    public String getLicenseKey(String tenantId) throws Exception {
        MongoCollection col = this.mongoTemplate.getCollection(APP_LICENSE_KEY_COLLECTION_NAME);
        Document doc = (Document)col.find(Filters.eq((String)TENANT_ID_KEY_NAME, (Object)tenantId)).first();
        String licenseKey = null;
        if (doc != null) {
            licenseKey = doc.getString((Object)LICENSE_KEY_FIELD_NAME);
            if (StringUtils.isEmpty((CharSequence)licenseKey)) {
                licenseKey = this.dataMapIamService.getAthenaLicenceKey(tenantId);
                if (StringUtils.isEmpty((CharSequence)licenseKey)) {
                    throw new DWBusinessException(I18nUtils.getValue((String)"knowledgegraph.licenseKeyNotFound", (Object[])new Object[]{tenantId}));
                }
                this.setLicenseKey(tenantId, licenseKey);
            }
        } else {
            licenseKey = this.dataMapIamService.getAthenaLicenceKey(tenantId);
            if (StringUtils.isEmpty((CharSequence)licenseKey)) {
                throw new DWBusinessException(I18nUtils.getValue((String)"knowledgegraph.licenseKeyNotFound", (Object[])new Object[]{tenantId}));
            }
            this.setLicenseKey(tenantId, licenseKey);
        }
        byte[] byteKey = DatatypeConverter.parseHexBinary((String)AES_KEY_HEX);
        SecretKeySpec key = new SecretKeySpec(byteKey, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(1, key);
        byte[] result = cipher.doFinal(licenseKey.getBytes());
        return DatatypeConverter.printHexBinary((byte[])result);
    }

    public String getLicenseKey(String tenantId, String requestFrom, String md5Str, long timestamp) throws Exception {
        this.checkIsLegal(tenantId, requestFrom, md5Str, timestamp);
        return this.getLicenseKey(tenantId);
    }

    public Boolean checkIsLegal(String tenantId, String requestFrom, String md5Str, long timestamp) throws DWBusinessException {
        if (!AppCons.SysEnum.sysExists(requestFrom).booleanValue()) {
            throw new DWBusinessException(I18nUtils.getValue((String)"knowledgegraph.requestFromError", (Object[])new Object[]{requestFrom}));
        }
        long now = new Date().getTime();
        if (now > timestamp && now - timestamp > 300000L) {
            throw new DWBusinessException(I18nUtils.getValue((String)"knowledgegraph.timeExpire", (Object[])new Object[]{now, timestamp}));
        }
        String key = DigestUtils.md5Hex((String)(tenantId + requestFrom + timestamp + AppCons.SysEnum.getKey(requestFrom)));
        if (!StringUtils.equals((CharSequence)md5Str, (CharSequence)key)) {
            throw new DWBusinessException(I18nUtils.getValue((String)"knowledgegraph.keyIncorrect", (Object[])new Object[]{md5Str}));
        }
        return true;
    }
}

