/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.activitybuilder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.config.ActivityType;
import com.digiwin.athena.config.ScriptMode;
import com.digiwin.athena.config.StandardMode;
import com.digiwin.athena.datamap.mechanism.activitybuilder.ActivityBuildService;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.activity.HttpActivityWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=1)
public class HttpActivityBuildService
implements ActivityBuildService {
    @Autowired
    DataMapPickService dataPickService;

    @Override
    public boolean accept(ActivityWidget ma) {
        return ActivityType.http.name().equals(ma.getType());
    }

    @Override
    public List<Activity> build(ActivityWidget ma, MechanismParseContext context) {
        ArrayList<Activity> result = new ArrayList<Activity>();
        HttpActivityWidget http = (HttpActivityWidget)this.dataPickService.convert(ma, HttpActivityWidget.class);
        Activity activity = new Activity();
        activity.setType("http");
        activity.setName(http.getName());
        activity.setMilestone(Boolean.valueOf(false));
        if (null != http.getHttpConfig() && "standard".equalsIgnoreCase(http.getHttpConfig().getExecutionMode())) {
            http.getHttpConfig().setExecutionMode("script");
            StandardMode standardMode = http.getHttpConfig().getStandardMode();
            ScriptMode scriptMode = new ScriptMode();
            if ("json".equalsIgnoreCase(http.getHttpConfig().getContentType())) {
                scriptMode.setRequestScript(this.requestScript(standardMode.getJson()));
            } else {
                scriptMode.setRequestScript(this.requestScript(standardMode.getParams()));
            }
            scriptMode.setResponseScript(this.responseScript(standardMode));
            http.getHttpConfig().setScriptMode(scriptMode);
            JSONObject config = JSON.parseObject((String)JSON.toJSONString((Object)http.getHttpConfig()));
            activity.setConfig((Map)config);
            if (null != http.getHttpConfig().getProduct()) {
                config.put("product", null);
            } else {
                config.put("product", context.getBindingContext().getParam().get("product"));
            }
        } else {
            activity.setConfig(http.getConfig());
        }
        result.add(activity);
        return result;
    }

    protected String requestScript(Map<String, Object> request) {
        StringBuilder sb = new StringBuilder();
        sb.append("var request = ").append(JSON.toJSONString(request)).append(";return request;");
        return sb.toString();
    }

    protected String requestScript(String json) {
        StringBuilder sb = new StringBuilder();
        sb.append("var request = ").append(json).append(";return request;");
        return sb.toString();
    }

    protected String responseScript(StandardMode standardMode) {
        StringBuilder sb = new StringBuilder();
        sb.append("var response = $(response);");
        if (null != standardMode.getRespVariables()) {
            standardMode.getRespVariables().forEach((k, v) -> sb.append("var ").append((String)k).append("=").append((String)v).append(";"));
        }
        sb.append("return {");
        if (null != standardMode.getRespVariables()) {
            standardMode.getRespVariables().forEach((k, v) -> sb.append("\"").append((String)k).append("\":").append((String)k).append(","));
            sb.append("\"").append("__innerMechanism").append("\":").append(1).append("");
        }
        sb.append("};");
        return sb.toString();
    }

    public static void main(String[] args) {
    }
}

