/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.activitybuilder;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.datamap.enums.NoticeLinkEnum;
import com.digiwin.athena.datamap.mechanism.activitybuilder.AbstractActivityBuildService;
import com.digiwin.athena.datamap.mechanism.convert.parsers.IMContentParser;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.definition.Identity;
import com.digiwin.athena.domain.definition.UserDefinition;
import com.digiwin.athena.mechanism.dto.ImLinkDTO;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.activity.IMActivityWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=1)
public class IMActivityBuildService
extends AbstractActivityBuildService {
    private static final Logger log = LoggerFactory.getLogger(IMActivityBuildService.class);
    @Value(value="${athenaUrl}")
    private String athenaUrl;

    @Override
    public boolean accept(ActivityWidget ma) {
        return "im".equalsIgnoreCase(ma.getType());
    }

    @Override
    public void build(ActivityWidget ma, MechanismParseContext context, List<Activity> list) {
        IMActivityWidget imActivityWidget = super.convert(ma, IMActivityWidget.class);
        Activity activity = list.get(0);
        String message = imActivityWidget.getMessage();
        if (StringUtils.isNotBlank((CharSequence)message) && message.contains("\n")) {
            String replaceMessage;
            message = replaceMessage = imActivityWidget.getMessage().replace("\n", "\\n");
            imActivityWidget.setMessage(replaceMessage);
        }
        log.info("imActivityWidget.getSendType:{}", (Object)imActivityWidget.getSendType());
        log.info("imActivityWidget.getObjectType:{}", (Object)imActivityWidget.getObjectType());
        log.info("imActivityWidget.getUserId():{}", (Object)imActivityWidget.getUserId());
        String objectType = Optional.ofNullable(imActivityWidget.getObjectType()).orElse("1");
        if (StringUtils.isEmpty((CharSequence)imActivityWidget.getUserId())) {
            if (!message.isEmpty() && "2".equals(objectType) || "3".equals(objectType)) {
                Map<String, Object> config = this.transToIMConfigsApi(imActivityWidget);
                activity.setConfig(config);
                activity.setType("http");
            } else if (imActivityWidget.getPerformerType().equalsIgnoreCase("businessField")) {
                Map<String, Object> config = this.transToIMConfigsApi(imActivityWidget);
                activity.setConfig(config);
                activity.setType("http");
            } else {
                Map<String, Object> config = this.transToIMTemplateConfig(imActivityWidget);
                activity.setConfig(config);
                activity.setType("im");
                activity.setExecutor(this.getActivityExecutor(imActivityWidget));
            }
        } else if (!message.isEmpty() && "1".equals(objectType)) {
            if (imActivityWidget.getPerformerType().equalsIgnoreCase("businessField")) {
                Map<String, Object> config = this.transToIMConfigsApi(imActivityWidget);
                activity.setConfig(config);
                activity.setType("http");
            } else {
                Map<String, Object> config = this.transToIMConfig(imActivityWidget);
                activity.setConfig(config);
                activity.setType("http");
            }
        } else if (!message.isEmpty() && ("2".equals(objectType) || "3".equals(objectType))) {
            Map<String, Object> config = this.transToIMConfigsApi(imActivityWidget);
            activity.setConfig(config);
            activity.setType("http");
        }
    }

    private Map<String, Object> transToIMConfig(IMActivityWidget convert) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("url", "/api/aim/v2/batch/user/message");
        config.put("contentType", "json");
        config.put("executionMode", "script");
        config.put("domain", "aim");
        config.put("method", "post");
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("security-token", "$(_ActLatelySecurityToken)");
        config.put("headers", headerMap);
        HashMap<String, String> scriptModeMap = new HashMap<String, String>();
        scriptModeMap.put("responseScript", "var response = $(response);\nvar tSuccess = true;\nvar tErrorMessage = '';\nif (response['status'] == 200) {\n    tErrorMessage = 'Success';\n} else {\n    tSuccess = false;\n    tErrorMessage = response['statusDescription'];\n}\nreturn {\n    'success': tSuccess,\n    'errorMessage': tErrorMessage\n};\n");
        scriptModeMap.put("requestScript", this.getRequestScript(convert));
        config.put("scriptMode", scriptModeMap);
        return config;
    }

    private Map<String, Object> transToIMConfigsApi(IMActivityWidget convert) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("url", "/restful/service/knowledgegraph/mechanismEnhancement/sendNotice");
        config.put("contentType", "json");
        config.put("executionMode", "script");
        config.put("domain", "thememap");
        config.put("method", "post");
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("security-token", "$(_ActLatelySecurityToken)");
        config.put("headers", headerMap);
        HashMap<String, Object> scriptModeMap = new HashMap<String, Object>();
        scriptModeMap.put("responseScript", "var response = $(response);\nvar tSuccess = true;\nvar tErrorMessage = '';\nif (response['status'] == 200) {\n    tErrorMessage = 'Success';\n} else {\n    tSuccess = false;\n    tErrorMessage = response['statusDescription'];\n}\nreturn {\n    'success': tSuccess,\n    'errorMessage': tErrorMessage\n};\n");
        if (CollectionUtils.isNotEmpty((Collection)convert.getGroupFields())) {
            scriptModeMap.put("requestScript", this.getGroupedIMHandRequestScriptApi(convert));
        } else {
            scriptModeMap.put("requestScript", this.getIMHandRequestScriptApi(convert));
        }
        config.put("scriptMode", scriptModeMap);
        return config;
    }

    private Object getGroupedIMHandRequestScriptApi(IMActivityWidget convert) {
        String message = convert.getMessage();
        if (message.contains("\n")) {
            message = message.replaceAll("\n", "");
        }
        Map<String, String> msgLangMap = this.processLangAndLinks(convert, message);
        StringBuilder requestScriptSb = new StringBuilder();
        requestScriptSb.append("var tenantId = '$(tenantId)';\n").append("var taskBizDataList = $(taskBizData);\n").append("var processLocale = '$(processLocale)';\n").append("var msg = processLocale === 'zh_TW' ? '" + msgLangMap.get("zh_TW") + "': processLocale === 'en_US' ? '" + msgLangMap.get("en_US") + "':'" + msgLangMap.get("zh_CN") + "';\n").append("var noticeVO = {\n").append("'taskBizData': taskBizDataList,\n").append("'tenantId': tenantId,\n ").append("'message': msg,\n").append("'groupFields': ").append(JSON.toJSONString((Object)convert.getGroupFields())).append(",\n ").append("'userIds': " + convert.getUserId() + ",\n ").append("'businessFields': '" + convert.getPerformerValue() + "'\n ").append("}\n").append("var request = {\n ").append("'noticeVO': noticeVO\n").append("};\n").append("return request;");
        return requestScriptSb.toString();
    }

    private Map<String, Object> transToIMConfigs(IMActivityWidget convert) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("url", "/restful/service/knowledgegraph/mechanismEnhancement/messageHand");
        config.put("contentType", "json");
        config.put("executionMode", "script");
        config.put("domain", "thememap");
        config.put("method", "post");
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("security-token", "$(_ActLatelySecurityToken)");
        config.put("headers", headerMap);
        HashMap<String, String> scriptModeMap = new HashMap<String, String>();
        scriptModeMap.put("responseScript", "var response = $(response);\nvar tSuccess = true;\nvar tErrorMessage = '';\nif (response['status'] == 200) {\n    tErrorMessage = 'Success';\n} else {\n    tSuccess = false;\n    tErrorMessage = response['statusDescription'];\n}\nreturn {\n    'success': tSuccess,\n    'errorMessage': tErrorMessage\n};\n");
        scriptModeMap.put("requestScript", this.getIMHandRequestScript(convert));
        config.put("scriptMode", scriptModeMap);
        return config;
    }

    private Map<String, Object> transToIMTemplateConfig(IMActivityWidget convert) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        HashMap<String, String> scriptModeMap = new HashMap<String, String>();
        scriptModeMap.put("responseScript", "var response = $(response);\nvar tSuccess = true;\nvar tErrorMessage = '';\nif (response['status'] == 200) {\n    tErrorMessage = 'Success';\n} else {\n    tSuccess = false;\n    tErrorMessage = response['statusDescription'];\n}\nreturn {\n    'success': tSuccess,\n    'errorMessage': tErrorMessage\n};\n");
        scriptModeMap.put("requestScript", this.getIMTemplateRequestScript(convert));
        config.put("scriptMode", scriptModeMap);
        return config;
    }

    private UserDefinition getActivityExecutor(IMActivityWidget imActivityWidget) {
        UserDefinition executor = new UserDefinition();
        executor.setChoosePolicy("all");
        ArrayList<Identity> identities = new ArrayList<Identity>();
        Identity identity = new Identity();
        if ("taskExecutor".equalsIgnoreCase(imActivityWidget.getPerformerType())) {
            imActivityWidget.setPerformerType("user");
        }
        identity.setPerformerType(imActivityWidget.getPerformerType());
        identity.setPerformerValue((Object)imActivityWidget.getPerformerValue());
        identities.add(identity);
        executor.setIdentities(identities);
        return executor;
    }

    private String getRequestScript(IMActivityWidget convert) {
        boolean jumpTaskDetail;
        Map langTitle;
        String title;
        String message = convert.getMessage();
        if (message.contains("\n")) {
            message = message.replaceAll("\n", "");
        }
        message = message.replaceAll("\\$(\\w+)\\$", "\\$\\($1\\)");
        message = message.replaceAll("\\$\\{(.+?)}", "\\$($1)");
        String titleEn = title = convert.getTitle();
        String titleTW = title;
        Map lang = convert.getLang();
        if (lang != null && (langTitle = (Map)lang.get("title")) != null) {
            titleTW = langTitle.getOrDefault("zh_TW", titleTW);
            titleEn = langTitle.getOrDefault("en_US", titleEn);
        }
        StringBuilder requestScriptSb = new StringBuilder();
        String userId = convert.getUserId();
        Map<String, String> msgLangMap = this.processLangAndLinks(convert, message);
        boolean bl = jumpTaskDetail = CollectionUtils.isNotEmpty((Collection)convert.getLinks()) && convert.getLinks().stream().anyMatch(link -> NoticeLinkEnum.TASK_DETAIL.getType().equals(link.getType()));
        if (StringUtils.isNotEmpty((CharSequence)userId) && (userId.contains("[*]") || jumpTaskDetail)) {
            String userArrayObject = "MECHANISM_PARAMETER".equals(convert.getPerformerType()) ? "$(list)" : userId.substring(0, userId.indexOf("[*]"));
            String userKey = "MECHANISM_PARAMETER".equals(convert.getPerformerType()) ? "" : userId.substring(userId.indexOf("[*]") + 4);
            requestScriptSb.append("var tenantId = '$(tenantId)';\n").append("var processLocale = '$(processLocale)';\n").append("var userArrayObject = " + userArrayObject + ";\n").append("var curDate = new Date();\n").append("var title = '" + title + "';\n").append("var msg = '" + msgLangMap.get("zh_CN") + "';\n").append("if (processLocale === 'zh_TW') {\n").append("title = '" + titleTW + "';\n").append("msg = '" + msgLangMap.get("zh_TW") + "';\n}").append("else if (processLocale === 'en_US') {\n ").append("title = '" + titleEn + "';\n").append("msg = '" + msgLangMap.get("en_US") + "';\n}\n").append("var userIdArray = [];\n").append(" var request = userArrayObject.map(function (info) {").append("    var userId = ").append("MECHANISM_PARAMETER".equals(convert.getPerformerType()) ? userId : "[info." + userKey + "]").append(";\n ").append("    if (!").append(jumpTaskDetail).append(") {\n").append("        if (userIdArray.indexOf(JSON.stringify(userId))>-1) {\n").append("            return null;\n").append("        }\n").append("        userIdArray.push(JSON.stringify(userId));\n").append("    }\n").append(" return {\n").append("        'userIdList': userId,\n").append("'tenantId': tenantId,\n").append("'message': {\n").append("'sendDate': curDate,\n").append("'importance': 0,\n").append("'source': 'athena',\n").append("'type': 'activity',\n").append("'title': title,\n").append("'content': {\n").append("'msg': msg,\n ").append("'name': '',\n").append("'startTime': curDate,\n").append("'id': ").append(jumpTaskDetail ? "info.backlogId" : "null").append(",\n").append("'endTime': curDate,\n").append("'title': title,\n").append("'status': 0\n").append("},\n").append("'subTypeCategory': 'ATHENA_REMIND',\n").append("'subType': '',\n").append("'startTime': curDate,\n").append("'state': 0,\n").append("'endTime': curDate,\n").append("'category': ").append(jumpTaskDetail ? "'OTHER'" : "'NOTICE'").append(",\n").append("'hasReadDetail': false\n").append("    \n").append("}}}).filter(Boolean);\n").append("return request;");
        } else {
            requestScriptSb.append("var list = $(list);\n").append("var userId = list && list.length > 0 ? " + userId + " : [];\n");
            requestScriptSb.append("var tenantId = '$(tenantId)';\n").append("var processLocale = '$(processLocale)';\n").append("var curDate = new Date();\n").append("var title = '" + title + "';\n").append("var msg = '" + msgLangMap.get("zh_CN") + "';\n").append("if (processLocale === 'zh_TW') {\n").append("title = '" + titleTW + "';\n").append("msg = '" + msgLangMap.get("zh_TW") + "';\n}").append("else if (processLocale === 'en_US') {\n ").append("title = '" + titleEn + "';\n").append("msg = '" + msgLangMap.get("en_US") + "';\n}\n").append("var request = [{\n ").append("'userIdList': typeof userId === 'string' ? [userId]:userId,\n ").append("'tenantId': tenantId,\n").append("'message': {\n").append("'sendDate': curDate,\n").append("'importance': 0,\n").append("'source': 'athena',\n").append("'type': 'activity',\n").append("'title': title,\n").append("'content': {\n").append("'msg': msg,\n ").append("'name': '',\n").append("'startTime': curDate,\n").append("'id': null,\n").append("'endTime': curDate,\n").append("'title': title,\n").append("'status': 0\n").append("},\n").append("'subTypeCategory': 'ATHENA_REMIND',\n").append("'subType': '',\n").append("'startTime': curDate,\n").append("'state': 0,\n").append("'endTime': curDate,\n").append("'category': 'NOTICE',\n").append("'hasReadDetail': false\n").append("}\n}];\n").append("return request;");
        }
        return requestScriptSb.toString();
    }

    private Map<String, String> processLangAndLinks(IMActivityWidget convert, String message) {
        Map langMessage;
        HashMap<String, String> result = new HashMap<String, String>();
        String messageEN = message;
        String messageTW = message;
        Map lang = convert.getLang();
        if (lang != null && (langMessage = (Map)lang.get("message")) != null) {
            messageTW = langMessage.getOrDefault("zh_TW", messageTW);
            messageEN = langMessage.getOrDefault("en_US", messageEN);
        }
        message = this.replaceSpecialCharacters(message);
        messageEN = this.replaceSpecialCharacters(messageEN);
        messageTW = this.replaceSpecialCharacters(messageTW);
        if (CollectionUtils.isNotEmpty((Collection)convert.getLinks())) {
            for (ImLinkDTO link : convert.getLinks()) {
                NoticeLinkEnum noticeLinkEnum = NoticeLinkEnum.getByType(link.getType());
                if (noticeLinkEnum == null || noticeLinkEnum.equals((Object)NoticeLinkEnum.TASK_DETAIL)) continue;
                String urlCn = noticeLinkEnum.getUrlCn().replaceAll("#atheanaDomain#", this.athenaUrl);
                String urlTw = noticeLinkEnum.getUrlTw().replaceAll("#atheanaDomain#", this.athenaUrl);
                String urlUs = noticeLinkEnum.getUrlUs().replaceAll("#atheanaDomain#", this.athenaUrl);
                String placeHolder = link.getPlaceHolder();
                if (StringUtils.isNotBlank((CharSequence)placeHolder)) {
                    if (StringUtils.isNotEmpty((CharSequence)message)) {
                        message = message.replaceAll(placeHolder, urlCn);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)messageEN)) {
                        messageEN = messageEN.replaceAll(placeHolder, urlUs);
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)messageTW)) continue;
                    messageTW = messageTW.replaceAll(placeHolder, urlTw);
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)message)) {
                    message = message + urlCn;
                }
                if (StringUtils.isNotEmpty((CharSequence)messageEN)) {
                    messageEN = messageEN + urlUs;
                }
                if (!StringUtils.isNotEmpty((CharSequence)messageTW)) continue;
                messageTW = messageTW + urlTw;
            }
        }
        result.put("zh_CN", message);
        result.put("zh_TW", messageTW);
        result.put("en_US", messageEN);
        return result;
    }

    private String replaceSpecialCharacters(String s) {
        return Optional.ofNullable(s).filter(str -> str.contains("'")).map(str -> str.replaceAll("'", "\\\\'")).orElse(s);
    }

    private String getIMHandRequestScript(IMActivityWidget convert) {
        String message = convert.getMessage();
        if (message.contains("\n")) {
            message = message.replaceAll("\n", "");
        }
        StringBuilder requestScriptSb = new StringBuilder();
        requestScriptSb.append("var tenantId = '$(tenantId)';\n").append("var taskList = '$(bizData)';\n").append("var msg = '" + message + "';\n").append("var request = {\n ").append("'tenantId': tenantId,\n ").append("'taskList': taskList,\n").append("'msg': msg\n").append("};\n").append("return request;");
        return requestScriptSb.toString();
    }

    private String getIMHandRequestScriptApi(IMActivityWidget convert) {
        String message = convert.getMessage();
        if (message.contains("\n")) {
            message = message.replaceAll("\n", "");
        }
        Map<String, String> msgLangMap = this.processLangAndLinks(convert, message);
        StringBuilder requestScriptSb = new StringBuilder();
        requestScriptSb.append("var tenantId = '$(tenantId)';\n").append("var taskBizDataList = '$(taskBizData)';\n").append("var processLocale = '$(processLocale)';\n").append("var msg = processLocale === 'zh_TW' ? '" + msgLangMap.get("zh_TW") + "': processLocale === 'en_US' ? '" + msgLangMap.get("en_US") + "':'" + msgLangMap.get("zh_CN") + "';\n").append("var request = {\n ").append("'taskBizData': taskBizDataList,\n").append("'tenantId': tenantId,\n ").append("'message': msg,\n");
        if (StringUtils.isNotEmpty((CharSequence)convert.getUserId())) {
            requestScriptSb.append("'userIds': ").append(convert.getUserId()).append(",\n ");
        }
        requestScriptSb.append("'businessFields': '" + convert.getPerformerValue() + "'\n ").append("};\n").append("return request;");
        return requestScriptSb.toString();
    }

    private String getIMTemplateRequestScript(IMActivityWidget convert) {
        boolean jumpTaskDetail;
        Map langTitle;
        String title;
        String message = convert.getMessage();
        String titleEn = title = convert.getTitle();
        String titleTW = title;
        Map lang = convert.getLang();
        if (lang != null && (langTitle = (Map)lang.get("title")) != null) {
            titleTW = langTitle.getOrDefault("zh_TW", titleTW);
            titleEn = langTitle.getOrDefault("en_US", titleEn);
        }
        Map<String, String> msgLangMap = this.processLangAndLinks(convert, message);
        StringBuilder requestScriptSb = new StringBuilder();
        String template = StringUtils.isNotEmpty((CharSequence)convert.getMsgCode()) ? IMContentParser.parseVariables(convert.getMsgCode(), message) : "";
        boolean bl = jumpTaskDetail = CollectionUtils.isNotEmpty((Collection)convert.getLinks()) && convert.getLinks().stream().anyMatch(link -> NoticeLinkEnum.TASK_DETAIL.getType().equals(link.getType()));
        if (jumpTaskDetail) {
            requestScriptSb.append("var tenantId = '$(tenantId)';\n").append("var processLocale = '$(processLocale)';\n").append("var userArrayObject = $(list);\n").append("var curDate = new Date();\n").append("var userId = [$(_imUserList)];\n").append("var title = '" + title + "';\n").append("var msg = '" + msgLangMap.get("zh_CN") + "';\n");
            if (StringUtils.isNotEmpty((CharSequence)convert.getMsgCode())) {
                requestScriptSb.append("var template = " + template + ";\n");
            }
            requestScriptSb.append("if (processLocale === 'zh_TW') {\n").append("title = '" + titleTW + "';\n").append("msg = '" + msgLangMap.get("zh_TW") + "';\n}").append("else if (processLocale === 'en_US') {\n ").append("title = '" + titleEn + "';\n").append("msg = '" + msgLangMap.get("en_US") + "';\n}\n").append(" var request = userArrayObject.map(function (info) {").append(" return {\n").append("'userIdList': userId,\n").append("'tenantId': tenantId,\n").append("'message': {\n");
            if (StringUtils.isNotEmpty((CharSequence)convert.getMsgCode())) {
                requestScriptSb.append("'template': template,\n ");
            }
            requestScriptSb.append("'sendDate': curDate,\n").append("'importance': 0,\n").append("'source': 'athena',\n").append("'type': 'activity',\n").append("'title': title,\n").append("'content': {\n").append("'msg': msg,\n ").append("'name': '',\n").append("'startTime': curDate,\n").append("'id': ").append("info.backlogId").append(",\n").append("'endTime': curDate,\n").append("'title': title,\n").append("'status': 0\n").append("},\n").append("'subTypeCategory': 'ATHENA_REMIND',\n").append("'subType': '',\n").append("'startTime': curDate,\n").append("'state': 0,\n").append("'endTime': curDate,\n").append("'category': ").append("'OTHER'").append(",\n").append("'hasReadDetail': false\n").append("}\n}});\n").append("return request;");
        } else {
            requestScriptSb.append("var tenantId = '$(tenantId)';\n").append("var processLocale = '$(processLocale)';\n").append("var list = $(list);\n").append("var curDate = new Date();\n").append("var userId = [$(_imUserList)];\n").append("var title = '" + title + "';\n").append("var msg = '" + msgLangMap.get("zh_CN") + "';\n");
            if (StringUtils.isNotEmpty((CharSequence)convert.getMsgCode())) {
                requestScriptSb.append("var template = " + template + ";\n");
            }
            requestScriptSb.append("if (processLocale === 'zh_TW') {\n").append("title = '" + titleTW + "';\n").append("msg = '" + msgLangMap.get("zh_TW") + "';\n}").append("else if (processLocale === 'en_US') {\n ").append("title = '" + titleEn + "';\n").append("msg = '" + msgLangMap.get("en_US") + "';\n}\n").append("if (list.length > 0) {\n").append("var request = [{\n ").append("'userIdList': userId,\n ").append("'tenantId': tenantId,\n").append("'message': {\n").append("'sendDate': curDate,\n");
            if (StringUtils.isNotEmpty((CharSequence)convert.getMsgCode())) {
                requestScriptSb.append("'template': template,\n ");
            }
            requestScriptSb.append("'locale': processLocale,\n ");
            requestScriptSb.append("'importance': 0,\n").append("'source': 'athena',\n").append("'type': 'activity',\n").append("'title': title,\n").append("'content': {\n").append("'msg': msg,\n ").append("'name': '',\n").append("'startTime': curDate,\n").append("'id': null,\n").append("'endTime': curDate,\n").append("'title': title,\n").append("'status': 0\n").append("},\n").append("'subTypeCategory': 'ATHENA_REMIND',\n").append("'subType': '',\n").append("'startTime': curDate,\n").append("'state': 0,\n").append("'endTime': curDate,\n").append("'category': 'NOTICE',\n").append("'hasReadDetail': false\n").append("}\n}];\n").append("return request;\n").append("} else {\n").append("return;\n").append("}");
        }
        return requestScriptSb.toString();
    }
}

