/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.component;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.component.ComponentHandler;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.mechanism.dto.MechanismComponentDTO;

public abstract class AbstractComponentHandler
implements ComponentHandler {
    @Override
    public Object handlerApply(MechanismComponentDTO dto) throws Exception {
        BindingContext context = this.buildContext(dto);
        Object obj = this.doHandlerApply(dto, context);
        return obj;
    }

    @Override
    public Object handlerUnApply(MechanismComponentDTO dto) throws Exception {
        BindingContext context = this.buildContext(dto);
        Object obj = this.doHandlerUnApply(dto, context);
        return obj;
    }

    public abstract Object doHandlerApply(MechanismComponentDTO var1, BindingContext var2) throws Exception;

    public abstract Object doHandlerUnApply(MechanismComponentDTO var1, BindingContext var2) throws Exception;

    private BindingContext buildContext(MechanismComponentDTO dto) throws DWBusinessException {
        BindingContext context = new BindingContext();
        context.setTenantId(ServiceUtils.getTenantId());
        context.setMechanismCode(dto.getMechanismCode());
        context.setMechanismVersion(dto.getMechanismVersion());
        context.setPluginId(dto.getPluginId());
        context.setParam(dto.getParam());
        context.setMechanismVariables(dto.getMechanismVariables());
        return context;
    }
}

