/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.mechanism.component.AbstractAbilityComponentHandler;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.service.impl.DataMapTaskService;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.datamap.spi.DataMapKgService;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.TenantObjectAdaptation;
import com.digiwin.athena.domain.core.process.Process;
import com.digiwin.athena.domain.core.process.ProcessConfigLink;
import com.digiwin.athena.domain.core.process.ProcessConfigNode;
import com.digiwin.athena.domain.definition.Identity;
import com.digiwin.athena.domain.definition.UserDefinition;
import com.digiwin.athena.domain.plugin.PluginBindingPo;
import com.digiwin.athena.dto.MultiLanguageDTO;
import com.digiwin.athena.dto.TaskAndActivity;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.mechanism.bo.AssignAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.dto.MechanismComponentDTO;
import com.digiwin.athena.mechanism.vo.SourceFieldVO;
import com.digiwin.athena.mechanism.vo.TargetFieldVO;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.assign.AdvancedUserDefinitionWidget;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class AssignAbilityHandler
extends AbstractAbilityComponentHandler {
    private static final String MECHANISM_TASK_DATA = "_mechanism_taskData_";
    private static final String MECHANISM_BASIC_DATA = "_mechanism_basicData_";
    private static final String MECHANISM_EXECUTOR = "_executorByMechanism_";
    @Autowired
    DataMapTaskService dataMapTaskService;
    @Autowired
    private DataMapKgService dataMapKgService;
    @Autowired
    DataPickService dataPickService;

    @Override
    public void apply(MechanismAbility ability, BindingContext context) throws Exception {
        AssignAbilityBo source = (AssignAbilityBo)ability;
        this.unapply((MechanismAbility)source, context);
        Task task = (Task)this.dataPickService.findByCode(source.getCheckSource().getTarget(), Task.class);
        Preconditions.checkNotNull((Object)task);
        Process process = null;
        if (task.getProcessId() != null) {
            process = (Process)this.dataPickService.systemTemplate().findOne(Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)task.getProcessId())), Process.class);
        }
        if (process != null && source.getAdvancedUserDefinitionWidget() != null) {
            this.applyForTwoPointZeroApp(process, source, context);
            return;
        }
        if (process != null) {
            this.applyAssignWithoutPreActivityForTwoPointZeroApp(process, source, context);
            return;
        }
        List<ActivityWidget> activityWidgets = this.generatePreActivities(source, context);
        source.setPreActivities(activityWidgets);
        if (CollectionUtils.isNotEmpty((Collection)source.getPreActivities())) {
            MechanismParseContext parseContext = this.buildTaskFlow((MechanismAbility)source, context);
            this.applyMechanismTask(source, context);
            this.endTaskFlow(parseContext.getLastLink(), parseContext);
        } else {
            this.applyMechanismTask(source, context);
        }
    }

    private void applyAssignWithoutPreActivityForTwoPointZeroApp(Process process, AssignAbilityBo source, BindingContext context) throws Exception {
        Preconditions.checkNotNull((Object)process.getProcessConfig(), (Object)"ProcessConfig is null");
        String sonTaskCode = source.getCheckSource().getTarget();
        List nodes = process.getProcessConfig().getNodes();
        ProcessConfigNode targetNode = nodes.stream().filter(each -> each.getId().equals(sonTaskCode)).findAny().orElseThrow(() -> new DWException("Target Task not found"));
        this.replaceExecutorUser(targetNode, source.getAssignTo());
        process.setPluginId(context.getPluginId());
        process.setTenantId(ServiceUtils.getTenantId());
        process.setVersion(null);
        process.setId(null);
        this.dataPickService.tenantTemplate().insert((Object)process);
    }

    private void replaceExecutorUser(ProcessConfigNode targetNode, UserDefinition assignTo) {
        if (targetNode.getExecutor() != null && "personnel".equals(targetNode.getExecutor().get("type")) && assignTo.getChoosePolicy().equals("single") && ((Identity)assignTo.getIdentities().iterator().next()).getPerformerType().equals("user")) {
            targetNode.getExecutor().put("source", "personnel");
            targetNode.getExecutor().put("type", "personnel");
            HashMap<String, String> user = new HashMap<String, String>();
            user.put("userId", ((Identity)assignTo.getIdentities().iterator().next()).getPerformerValue().toString());
            ArrayList<HashMap<String, String>> users = new ArrayList<HashMap<String, String>>();
            users.add(user);
            targetNode.getExecutor().put("personnel", users);
        }
    }

    public void applyForTwoPointZeroApp(Process process, AssignAbilityBo source, BindingContext context) throws Exception {
        Preconditions.checkNotNull((Object)process, (Object)"Process is null");
        Preconditions.checkNotNull((Object)process.getProcessConfig(), (Object)"ProcessConfig is null");
        List nodes = process.getProcessConfig().getNodes();
        String sonTaskCode = source.getCheckSource().getTarget();
        ProcessConfigNode targetNode = nodes.stream().filter(each -> each.getId().equals(sonTaskCode)).findAny().orElseThrow(() -> new DWException("Target Task not found"));
        List<ProcessConfigNode> assignNodes = this.generateAssignNodes(source, context);
        Preconditions.checkArgument((!assignNodes.isEmpty() ? 1 : 0) != 0);
        this.replaceExecutorForTargetNodeExecutorUser(targetNode, context.getPluginId(), assignNodes.get(assignNodes.size() - 1).getId());
        this.generateNewGraph(process, context, sonTaskCode, assignNodes);
        this.dataPickService.tenantTemplate().insert((Object)process);
    }

    public void generateNewGraph(Process process, BindingContext context, String sonTaskCode, List<ProcessConfigNode> assignNodes) throws DWException {
        List links = process.getProcessConfig().getLinks();
        ProcessConfigLink toTargetLink = links.stream().filter(each -> each.getToId().equals(sonTaskCode)).findAny().orElseThrow(() -> new DWException("Target Task not found in links to"));
        links.remove(toTargetLink);
        ArrayList<ProcessConfigLink> newLinks = new ArrayList<ProcessConfigLink>(links);
        List nodes = process.getProcessConfig().getNodes();
        ArrayList<ProcessConfigNode> newNodes = new ArrayList<ProcessConfigNode>(nodes);
        int i = 0;
        ProcessConfigNode lastNode = nodes.stream().filter(each -> each.getId().equals(toTargetLink.getFromId())).findAny().orElseThrow(() -> new DWException("Target Task not found in links from"));
        for (ProcessConfigNode each2 : assignNodes) {
            newNodes.add(each2);
            ProcessConfigLink link = new ProcessConfigLink();
            link.setFromId(lastNode.getId());
            link.setToId(each2.getId());
            link.setId(this.mechanismHelpService.uid());
            newLinks.add(link);
            lastNode = each2;
            if (i++ != assignNodes.size() - 1) continue;
            ProcessConfigLink linkToTarget = new ProcessConfigLink();
            linkToTarget.setFromId(each2.getId());
            linkToTarget.setToId(sonTaskCode);
            linkToTarget.setId(this.mechanismHelpService.uid());
            newLinks.add(linkToTarget);
        }
        process.getProcessConfig().setNodes(newNodes);
        process.getProcessConfig().setLinks(newLinks);
        process.setPluginId(context.getPluginId());
        process.setTenantId(ServiceUtils.getTenantId());
        process.setVersion(null);
        process.setId(null);
    }

    public void replaceExecutorForTargetNodeExecutorUser(ProcessConfigNode targetNode, String pluginId, String id) {
        if (targetNode.getExecutor() != null && "personnel".equals(targetNode.getExecutor().get("type"))) {
            targetNode.getExecutor().put("source", "variable");
            HashMap<String, String> user = new HashMap<String, String>();
            user.put("userId", "return [$variables['" + id + "']['" + MECHANISM_EXECUTOR + pluginId + "']];");
            targetNode.getExecutor().put("variable", user);
        }
    }

    public List<ProcessConfigNode> generateAssignNodes(AssignAbilityBo source, BindingContext context) throws Exception {
        ArrayList<ProcessConfigNode> nodes = new ArrayList<ProcessConfigNode>();
        nodes.add(this.generateEspNode(source.getCheckSource().getTarget(), "task-detail", context.getPluginId()));
        nodes.add(this.generateEspNode(source.getAdvancedUserDefinitionWidget().getSourceField().getBasicDataCode(), "basic-data", context.getPluginId()));
        nodes.add(this.generateScriptNode(source.getAdvancedUserDefinitionWidget(), context.getPluginId(), nodes));
        return nodes;
    }

    private ProcessConfigNode generateEspNode(String code, String type, String capacityCode) throws Exception {
        Map<String, Object> task = "task-detail".equals(type) ? this.dataMapTaskService.getActivityDefinition(code, type) : this.dataMapTaskService.getActivityDefinition(code, type);
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(task));
        JSONObject dataSources = jsonObject.getJSONObject("dataSources");
        JSONObject pages = jsonObject.getJSONObject("pages");
        JSONArray dataStates = pages == null ? null : pages.getJSONArray("dataStates");
        String schema = null;
        if (dataStates != null) {
            JSONObject submitType = dataStates.getJSONObject(0).getJSONObject("submitType");
            schema = submitType == null ? null : submitType.getString("schema");
        }
        JSONObject dataSourceJson = null;
        if (schema != null) {
            dataSourceJson = dataSources.getJSONObject(schema);
        }
        if (dataSourceJson == null) {
            schema = String.valueOf(dataSources.keySet().toArray()[0]);
            dataSourceJson = dataSources.getJSONObject(schema);
        }
        StringBuilder request = new StringBuilder();
        request.append("return {\n std_data: {\n parameter: {\n").append("\n} \n} \n};");
        StringBuilder response = new StringBuilder();
        response.append("var response = $(response);\n").append("var tSuccess = true;\n").append("var tErrorMessage = '';\n").append("if (Object.keys(response).length===0){tErrorMessage='Success';var ").append(schema).append("=''}\n").append("else if (response['std_data']['execution']['code'] == '0') { \n").append("tErrorMessage = 'Success';\n").append("var ").append(schema).append("= response['std_data']['parameter']['").append(schema).append("'];\n").append("} else {\n").append("tSuccess = false;\n").append("tErrorMessage = response['std_data']['execution']['description'];}\n").append("return {\n").append("'").append(this.getProcessVariableKey(type, capacityCode)).append("': ").append(schema).append("\n").append("};");
        ProcessConfigNode node = new ProcessConfigNode();
        node.setTransfer(Boolean.valueOf(true));
        node.setName("ESP");
        HashMap<String, Boolean> returnMap = new HashMap<String, Boolean>();
        returnMap.put("base", true);
        returnMap.put("dataMapping", true);
        node.set_isValidPassed(returnMap);
        node.setSubType("ESP");
        String nodeId = this.mechanismHelpService.uid();
        node.setId("ServiceTask_" + nodeId);
        node.setType("ServiceTask");
        node.set_nodeId(nodeId);
        MultiLanguageDTO multiLanguageDTO = new MultiLanguageDTO().setZh_CN("ESP").setZh_TW("ESP").setEn_US("ESP");
        HashMap<String, MultiLanguageDTO> multiLanguageMap = new HashMap<String, MultiLanguageDTO>();
        multiLanguageMap.put("name", multiLanguageDTO);
        node.setLang(multiLanguageMap);
        node.set_nodeType("AutoEsp");
        HashMap<String, Object> executor = new HashMap<String, Object>();
        executor.put("performer", "Athena");
        executor.put("variable", new HashMap());
        executor.put("source", "NONE");
        executor.put("type", "robot");
        node.setExecutor(executor);
        HashMap<String, Object> serviceConfig = new HashMap<String, Object>();
        serviceConfig.put("method", "");
        serviceConfig.put("isAsync", false);
        HashMap<String, String> scheduleRule = new HashMap<String, String>();
        scheduleRule.put("schedule_type", "");
        serviceConfig.put("scheduleRule", scheduleRule);
        serviceConfig.put("type", "ESP");
        serviceConfig.put("serviceName", dataSourceJson.getString("serviceName"));
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("security-token", "$(_ActLatelySecurityToken)");
        serviceConfig.put("header", headerMap);
        serviceConfig.put("requestScript", request.toString());
        serviceConfig.put("responseScript", response.toString());
        node.setServiceConfig(serviceConfig);
        return node;
    }

    private String getProcessVariableKey(String type, String capacityCode) {
        if ("task-detail".equals(type)) {
            return MECHANISM_TASK_DATA + capacityCode;
        }
        return MECHANISM_BASIC_DATA + capacityCode;
    }

    private ProcessConfigNode generateScriptNode(AdvancedUserDefinitionWidget advancedUserDefinitionWidget, String capacityCode, List<ProcessConfigNode> nodes) {
        ProcessConfigNode node = new ProcessConfigNode();
        node.setTransfer(Boolean.valueOf(true));
        node.setName("\u811a\u672c");
        HashMap<String, Boolean> returnMap = new HashMap<String, Boolean>();
        returnMap.put("base", true);
        node.set_isValidPassed(returnMap);
        node.setSubType("SCRIPT");
        String nodeId = this.mechanismHelpService.uid();
        node.setId("ServiceTask_" + nodeId);
        node.setType("ServiceTask");
        node.set_nodeId(nodeId);
        MultiLanguageDTO multiLanguageDTO = new MultiLanguageDTO().setZh_CN("\u811a\u672c").setZh_TW("\u811a\u672c").setEn_US("\u811a\u672c");
        HashMap<String, MultiLanguageDTO> multiLanguageMap = new HashMap<String, MultiLanguageDTO>();
        multiLanguageMap.put("name", multiLanguageDTO);
        node.setLang(multiLanguageMap);
        node.set_nodeType("AutoScript");
        HashMap<String, Object> executor = new HashMap<String, Object>();
        executor.put("performer", "Athena");
        executor.put("variable", new HashMap());
        executor.put("source", "NONE");
        executor.put("type", "robot");
        node.setExecutor(executor);
        HashMap<String, Object> serviceConfig = new HashMap<String, Object>();
        HashMap<String, String> scheduleRule = new HashMap<String, String>();
        scheduleRule.put("schedule_type", "");
        serviceConfig.put("scheduleRule", scheduleRule);
        SourceFieldVO sourceField = advancedUserDefinitionWidget.getSourceField();
        TargetFieldVO targetField = advancedUserDefinitionWidget.getTargetField();
        String taskDataVariableKey = MECHANISM_TASK_DATA + capacityCode;
        String basicDataVariableKey = MECHANISM_BASIC_DATA + capacityCode;
        StringBuilder response = new StringBuilder();
        response.append("var taskData = $variables['" + nodes.get(0).getId() + "']['" + taskDataVariableKey + "'];\n").append("var basicData = $variables['" + nodes.get(1).getId() + "']['" + basicDataVariableKey + "'];\n").append("var sourceTaskFieldVal = taskData ? taskData[0]." + sourceField.getTaskField().getData_name() + ":'_';\n").append("var executorByMechanism; \n").append("for(var i = 0; i < basicData.length; i++) {\n").append(" var sourceBasicFieldVal = basicData[i]." + sourceField.getBasicDataField().getData_name() + ";\n").append(" if(sourceBasicFieldVal === sourceTaskFieldVal){\n").append(" executorByMechanism = basicData[i]." + targetField.getBasicDataField().getData_name() + ";\n").append(" break; \n").append(" } \n").append("} \n").append("return {\n").append("'").append(MECHANISM_EXECUTOR + capacityCode).append("': executorByMechanism \n").append("};");
        serviceConfig.put("responseScript", response.toString());
        serviceConfig.put("id", "ServiceTask_" + nodeId);
        serviceConfig.put("type", "SCRIPT");
        node.setServiceConfig(serviceConfig);
        return node;
    }

    private List<ActivityWidget> generatePreActivities(AssignAbilityBo source, BindingContext context) throws DWException {
        if (null == source.getAdvancedUserDefinitionWidget()) {
            return Collections.emptyList();
        }
        return this.dataMapKgService.generatePreActivities(source.getAdvancedUserDefinitionWidget(), context.getPluginId());
    }

    @Override
    public void unapply(MechanismAbility ability, BindingContext context) throws DWException {
        PluginBindingPo binding = PluginBindingPo.of((String)context.getTenantId(), (String)context.getPluginId());
        this.pluginService.postRemovePlugin(binding);
        this.pluginService.removeTenantPlugin(binding, DataMapPickService.tableTenantObjectAdaptation(Activity.class));
        this.dataPickService.tenantTemplate().remove(Query.query((CriteriaDefinition)Criteria.where((String)"pluginId").is((Object)context.getPluginId()).and("tenantId").is((Object)ServiceUtils.getTenantId())), Process.class);
    }

    public void applyMechanismTask(AssignAbilityBo mtask, BindingContext bindingContext) throws DWException {
        String taskCode;
        TaskAndActivity taskAndActivity;
        if (mtask.getAssignTo() != null && null != mtask.getCheckSource() && null != mtask.getCheckSource().getTarget() && null != (taskAndActivity = this.dataMapTaskService.getTaskAndMilestoneActivity(taskCode = mtask.getCheckSource().getTarget())).getActivity()) {
            TenantObjectAdaptation tenantObjectAdaptation = new TenantObjectAdaptation();
            tenantObjectAdaptation.setTenantId(bindingContext.getTenantId());
            tenantObjectAdaptation.setPluginId(bindingContext.getPluginId());
            tenantObjectAdaptation.setCode(taskAndActivity.getActivity().getCode());
            tenantObjectAdaptation.setDateType("object");
            tenantObjectAdaptation.setPath("$.executor");
            tenantObjectAdaptation.setValue((Object)mtask.getAssignTo());
            this.dataPickService.tenantTemplate().save((Object)tenantObjectAdaptation, DataMapPickService.tableTenantObjectAdaptation(Activity.class));
        }
    }

    @Override
    public boolean accept(MechanismComponentDTO dto) {
        return ComponentTypeEnum.MechanismAssign.name().equalsIgnoreCase(dto.getType());
    }

    @Override
    public Object parseScene(MechanismApiInfoDTO apiInfoDTO) {
        return null;
    }
}

