/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.component;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.component.AbstractAbilityComponentHandler;
import com.digiwin.athena.datamap.mechanism.convert.HooksConverter;
import com.digiwin.athena.datamap.mechanism.convert.HooksInfo;
import com.digiwin.athena.datamap.mechanism.convert.MechanismParserFactory;
import com.digiwin.athena.datamap.mechanism.convert.parsers.judgeBasis.ConditionParser;
import com.digiwin.athena.datamap.mechanism.convert.parsers.judgeBasis.JudgeBasisParser;
import com.digiwin.athena.datamap.mechanism.decisionHandler.DecisionCommonUtil;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.mechanism.bo.DecisionAbilityBO;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.dto.MechanismApiInfoDTO;
import com.digiwin.athena.mechanism.dto.MechanismComponentDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DecisionAbilityHandler
extends AbstractAbilityComponentHandler {
    private static final Logger log = LoggerFactory.getLogger(DecisionAbilityHandler.class);
    @Autowired
    HooksConverter hooksConverter;
    @Autowired
    MechanismHelpService mechanismHelpService;
    @Autowired
    DecisionCommonUtil decisionCommonUtil;
    @Autowired
    MechanismParserFactory mechanismParserFactory;
    @Autowired
    ConditionParser conditionParser;

    @Override
    public void apply(MechanismAbility ability, BindingContext context) throws DWException {
        this.unapply(ability, context);
        DecisionAbilityBO bo = (DecisionAbilityBO)ability;
        String taskCode = bo.getCheckSource().getTarget();
        Task task = (Task)this.dataPickService.findBetter(taskCode, Task.class);
        if (null != task && null != task.getPageCode()) {
            PageView pageView = (PageView)this.dataPickService.findByCode(task.getPageCode(), PageView.class);
            HooksInfo hooksInfoAll = new HooksInfo();
            if (null != pageView) {
                JudgeBasisParser judgeBasisParser = this.mechanismParserFactory.getJudgeParserByType(bo.getSubType());
                if (null != judgeBasisParser) {
                    judgeBasisParser.parse(ability, pageView, context, hooksInfoAll);
                } else {
                    log.error("DecisionAbilityHandler.apply \u83b7\u53d6JudgeParser\u5931\u8d25\uff0c\u5165\u53c2{}", (Object)context);
                }
                MechanismParseContext parseContext = this.buildContext(ability, context);
                this.decisionCommonUtil.postRemovePlugin(parseContext.getBindingContext().getTenantId(), parseContext.getBindingContext().getPluginId());
                this.decisionCommonUtil.addMechanismParameter(parseContext, hooksInfoAll, pageView);
            }
        }
    }

    @Override
    public void unapply(MechanismAbility ability, BindingContext context) throws DWException {
        this.mechanismHelpService.unapplyCommon(context);
    }

    @Override
    public boolean accept(MechanismComponentDTO dto) {
        return ComponentTypeEnum.MechanismDecision.name().equalsIgnoreCase(dto.getType());
    }

    @Override
    public Object parseScene(MechanismApiInfoDTO apiInfoDTO) {
        return this.conditionParser.parseScene(apiInfoDTO);
    }
}

