/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.controlSourcehandlers;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.MechanismHelpService;
import com.digiwin.athena.datamap.mechanism.controlSourcehandlers.AbstractControlSourceHandler;
import com.digiwin.athena.datamap.mechanism.support.MechanismParseContext;
import com.digiwin.athena.datamap.service.inner.DataMapPickService;
import com.digiwin.athena.datamap.service.inner.PluginService;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.common.MechanismCheckSourceType;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.source.TaskSourceWidget;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class ControlTaskSourceHandler
extends AbstractControlSourceHandler {
    @Autowired
    DataMapPickService dataPickService;
    @Autowired
    PluginService pluginService;
    @Autowired
    @Qualifier(value="dataMapSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    MechanismHelpService mechanismHelpService;

    @Override
    public boolean accept(SourceWidget source) {
        return MechanismCheckSourceType.taskSource.name().equals(source.getType());
    }

    @Override
    public void parse(SourceWidget source, MechanismParseContext context) throws DWBusinessException {
        Task task1 = context.getTask();
        MechanismAbility mtask = context.getBo();
        TaskSourceWidget taskSource = (TaskSourceWidget)this.dataPickService.convert(source, TaskSourceWidget.class);
        context.setSourceWidget((SourceWidget)taskSource);
        task1.setScheduleRule(mtask.getCheckSource().getScheduleRule());
        mtask.setCheckSource((SourceWidget)taskSource);
        task1.setMasterCode(taskSource.getTarget());
        task1.setAssistantExecuteTime(taskSource.getExecuteTime());
    }
}

