/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.convert;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.datamap.mechanism.convert.HookDynamicFunction;
import com.digiwin.athena.datamap.mechanism.convert.HooksInfo;
import com.digiwin.athena.datamap.mechanism.convert.JSFunctions;
import com.digiwin.athena.datamap.utils.DataMapUtils;
import com.digiwin.athena.mechanism.bo.HookBO;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class HooksConverter {
    private static final Logger log = LoggerFactory.getLogger(HooksConverter.class);
    @Autowired
    JSFunctions jsFunctions;

    public HookBO hookDynamicFunctionExpression(HookDynamicFunction function) {
        StringBuilder sb = new StringBuilder();
        String name = function.getFunctionName();
        String fun = this.jsFunctions.function(name);
        if (null != fun) {
            Map<String, Object> parameter = function.getParameter();
            if (!ObjectUtils.isEmpty(parameter)) {
                for (Map.Entry<String, Object> entry : parameter.entrySet()) {
                    String key = entry.getKey();
                    if (entry.getValue() instanceof String) {
                        fun = fun.replaceAll(key, entry.getValue().toString());
                        continue;
                    }
                    fun = fun.replaceAll(key, JSON.toJSONString((Object)entry.getValue()));
                }
            }
            sb.append(fun).append(";");
        }
        HookBO hookBO = new HookBO().setEventSource(function.getSourceId());
        String hookName = function.getHookName();
        try {
            Field field = HookBO.class.getDeclaredField(hookName);
            field.setAccessible(true);
            field.set(hookBO, fun);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return hookBO;
    }

    public List<HookBO> buildHooks(HooksInfo hooksInfo) {
        ArrayList<HookBO> hookBOs = new ArrayList<HookBO>();
        if (!ObjectUtils.isEmpty((Object)hooksInfo.getHook())) {
            hookBOs.add(hooksInfo.getHook());
        }
        if (!ObjectUtils.isEmpty(hooksInfo.getDynamicFunctions())) {
            hooksInfo.getDynamicFunctions().stream().forEach(v -> hookBOs.add(this.hookDynamicFunctionExpression((HookDynamicFunction)v)));
        }
        ArrayList<HookBO> mergeHooks = new ArrayList<HookBO>();
        hookBOs.stream().forEach(v -> this.mergeHook((List<HookBO>)mergeHooks, (HookBO)v));
        return mergeHooks;
    }

    public List<HookBO> mergeHook(List<HookBO> mergeHooks, HookBO hookBO) {
        if (ObjectUtils.isEmpty(mergeHooks)) {
            mergeHooks.add(hookBO);
            return mergeHooks;
        }
        Optional<HookBO> oldEventHookOptional = mergeHooks.stream().filter(v -> hookBO.getEventSource().equals(v.getEventSource())).findFirst();
        if (!oldEventHookOptional.isPresent()) {
            mergeHooks.add(hookBO);
            return mergeHooks;
        }
        DataMapUtils.mergeObject(oldEventHookOptional.get(), hookBO, HookBO.class, "^.*Hook", Boolean.TRUE);
        return mergeHooks;
    }
}

