/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.convert;

import com.digiwin.athena.datamap.mechanism.component.AbstractAbilityComponentHandler;
import com.digiwin.athena.datamap.mechanism.convert.parsers.customFunction.CustomFuncParser;
import com.digiwin.athena.datamap.mechanism.convert.parsers.fieldValueType.FieldValueTypeParser;
import com.digiwin.athena.datamap.mechanism.convert.parsers.hooks.HooksParser;
import com.digiwin.athena.datamap.mechanism.convert.parsers.judgeBasis.JudgeBasisParser;
import com.digiwin.athena.datamap.mechanism.convert.parsers.rightCond.RightCondTypeParser;
import com.digiwin.athena.datamap.mechanism.limithandler.parsers.limitAction.LimitActionParser;
import com.digiwin.athena.datamap.mechanism.limithandler.parsers.limitCondition.LimitConditionParser;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.mechanism.dto.MechanismComponentDTO;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class MechanismParserFactory {
    private static final Logger log = LoggerFactory.getLogger(MechanismParserFactory.class);
    @Autowired
    List<JudgeBasisParser> judgeBasisParserList;
    @Autowired
    List<HooksParser> hooksParserList;
    @Autowired
    List<FieldValueTypeParser> fieldValueTypeParserList;
    @Autowired
    List<CustomFuncParser> customFuncParserList;
    @Autowired
    List<RightCondTypeParser> rightCondParserList;
    @Autowired
    List<LimitActionParser> limitActionParserList;
    @Autowired
    List<LimitConditionParser> limitConditionParserList;
    @Autowired
    List<AbstractAbilityComponentHandler> abilityComponentHandlerList;

    public JudgeBasisParser getJudgeParserByType(String type) {
        if (CollectionUtils.isEmpty(this.judgeBasisParserList)) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object)type)) {
            return null;
        }
        Optional<JudgeBasisParser> judgeParserOptional = this.judgeBasisParserList.stream().filter(v -> v.accept(type)).findFirst();
        if (judgeParserOptional.isPresent()) {
            return judgeParserOptional.get();
        }
        return null;
    }

    public HooksParser getHooksParserByConfig(MechanismConditionConfig config) {
        if (CollectionUtils.isEmpty(this.hooksParserList)) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object)config)) {
            return null;
        }
        Optional<HooksParser> hooksParserOptional = this.hooksParserList.stream().filter(v -> v.accept(config)).findFirst();
        if (hooksParserOptional.isPresent()) {
            return hooksParserOptional.get();
        }
        return null;
    }

    public FieldValueTypeParser getFieldTypeParserByConfig(String config) {
        if (CollectionUtils.isEmpty(this.fieldValueTypeParserList)) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object)config)) {
            return null;
        }
        Optional<FieldValueTypeParser> hooksParserOptional = this.fieldValueTypeParserList.stream().filter(v -> v.accept(config)).findFirst();
        if (hooksParserOptional.isPresent()) {
            return hooksParserOptional.get();
        }
        return null;
    }

    public CustomFuncParser getCustomFuncParserByName(String func) {
        if (CollectionUtils.isEmpty(this.customFuncParserList)) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object)func)) {
            return null;
        }
        Optional<CustomFuncParser> hooksParserOptional = this.customFuncParserList.stream().filter(v -> v.accept(func)).findFirst();
        if (hooksParserOptional.isPresent()) {
            return hooksParserOptional.get();
        }
        return null;
    }

    public RightCondTypeParser getRightCondParserByType(String type) {
        if (CollectionUtils.isEmpty(this.rightCondParserList)) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object)type)) {
            return null;
        }
        Optional<RightCondTypeParser> hooksParserOptional = this.rightCondParserList.stream().filter(v -> v.accept(type)).findFirst();
        if (hooksParserOptional.isPresent()) {
            return hooksParserOptional.get();
        }
        return null;
    }

    public AbstractAbilityComponentHandler getAbilityHandlerByType(String type) {
        Optional<AbstractAbilityComponentHandler> hooksParserOptional;
        if (CollectionUtils.isEmpty(this.abilityComponentHandlerList)) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object)type)) {
            return null;
        }
        MechanismComponentDTO dto = new MechanismComponentDTO();
        dto.setType(type);
        if (ComponentTypeEnum.MechanismLimit.name().equalsIgnoreCase(type)) {
            dto.setMechanismVersion("2.0");
        }
        if ((hooksParserOptional = this.abilityComponentHandlerList.stream().filter(v -> v.accept(dto)).findFirst()).isPresent()) {
            return hooksParserOptional.get();
        }
        return null;
    }

    public LimitActionParser getLimitActionParserByType(String type) {
        if (CollectionUtils.isEmpty(this.limitActionParserList)) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object)type)) {
            return null;
        }
        Optional<LimitActionParser> hooksParserOptional = this.limitActionParserList.stream().filter(v -> v.accept(type)).findFirst();
        if (hooksParserOptional.isPresent()) {
            return hooksParserOptional.get();
        }
        return null;
    }

    public LimitConditionParser getLimitConditionParserByType(String type) {
        if (CollectionUtils.isEmpty(this.limitConditionParserList)) {
            return null;
        }
        if (ObjectUtils.isEmpty((Object)type)) {
            return null;
        }
        Optional<LimitConditionParser> hooksParserOptional = this.limitConditionParserList.stream().filter(v -> v.accept(type)).findFirst();
        if (hooksParserOptional.isPresent()) {
            return hooksParserOptional.get();
        }
        return null;
    }
}

