/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.convert.parsers;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.convert.JsExpression;
import com.digiwin.athena.datamap.mechanism.convert.JsExpressionParser;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import org.springframework.stereotype.Service;

@Service
public class BooleanExpressionParser
implements JsExpressionParser {
    @Override
    public boolean accept(MechanismConditionConfig config) {
        return "boolean".equalsIgnoreCase(config.getLeft().getData_type());
    }

    @Override
    public JsExpression parse(MechanismConditionConfig config, BindingContext context) throws DWBusinessException {
        String op;
        StringBuilder sb = new StringBuilder();
        switch (op = config.getOpType()) {
            case "eq": {
                sb.append(this.pathExpr(config.getLeft().getData_name(), context)).append(" == ").append(config.getRight().getTo().getValue());
                break;
            }
            default: {
                throw new DWBusinessException("not support opType:" + op);
            }
        }
        JsExpression jsExpression = new JsExpression();
        jsExpression.setExpression(sb.toString());
        return jsExpression;
    }
}

