/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.datamap.mechanism.convert.parsers;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.datamap.mechanism.convert.DynamicFunction;
import com.digiwin.athena.datamap.mechanism.convert.JsExpression;
import com.digiwin.athena.datamap.mechanism.convert.JsExpressionParser;
import com.digiwin.athena.datamap.mechanism.support.BindingContext;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
class HighGradeExpressionParser
implements JsExpressionParser {
    private static final Logger log = LoggerFactory.getLogger(HighGradeExpressionParser.class);

    HighGradeExpressionParser() {
    }

    @Override
    public boolean accept(MechanismConditionConfig config) {
        return config.getType().equalsIgnoreCase("highGrade");
    }

    @Override
    public JsExpression parse(MechanismConditionConfig config, BindingContext context) throws DWBusinessException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        MechanismVariable left = config.getLeft();
        parameters.put("highGradeParameter1", this.jointPath(left.getFrom()));
        parameters.put("highGradeParameter2", this.jointPath(left.getTo()));
        MechanismVariable right = config.getRight();
        parameters.put("highGradeParameter3", this.jointPath(right.getFrom()));
        parameters.put("highGradeParameter4", right.getTo().getValue().toString());
        JsExpression jsExpression = new JsExpression();
        jsExpression.setExpression("isMatch");
        jsExpression.getDynamicFunction().add(DynamicFunction.builder().functionName("highGradeCondition").parameter(parameters).build());
        return jsExpression;
    }

    private String jointPath(MechanismVariable variable) {
        String str = variable.getData_name();
        if (variable.getPath().isEmpty()) {
            str = variable.getPath() + "." + variable.getData_name();
        }
        return str;
    }
}

